/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.persist;

import blackboard.data.BbObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Results
implements Serializable {
    private final ArrayList<Error> _aList;
    static final long serialVersionUID = -577604791192974418L;

    public Results() {
        this._aList = new ArrayList();
    }

    public Results(int size) {
        this._aList = new ArrayList(size);
    }

    public int getErrorCount() {
        return this._aList.size();
    }

    public ArrayList<Error> getList() {
        return this._aList;
    }

    public Error getError(int pos) {
        return this._aList.get(pos);
    }

    public void addError(BbObject obj, Exception pe) {
        this._aList.add(new Error(obj, pe));
    }

    public void addAllResults(Results newResults) {
        this._aList.addAll(newResults.getList());
    }

    public void addError(Error err) {
        this._aList.add(err);
    }

    public static class Error
    implements Serializable {
        transient BbObject _obj;
        Exception _exc;
        String _embeddedText;
        List<Exception> _excList = new ArrayList<Exception>();
        private static final long serialVersionUID = 655038315495859336L;

        public Error() {
        }

        public Error(BbObject obj, Exception exc) {
            this();
            this._obj = obj;
            this._embeddedText = this._obj.getBbAttributes().getSafeString("embed");
            this._exc = exc;
            this._excList.add(this._exc);
        }

        public BbObject getObject() {
            return this._obj;
        }

        public String getEmbeddedText() {
            return this._embeddedText;
        }

        public void addException(Exception exc) {
            this._excList.add(exc);
        }

        public Exception getException() {
            return this._exc;
        }

        public List<Exception> getAllExceptions() {
            return this._excList;
        }
    }
}

