/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.persist.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.course.CourseSite;
import blackboard.admin.data.course.Membership;
import blackboard.admin.data.course.Organization;
import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.manager.impl.TemporarySnapshotSessionManagerFactory;
import blackboard.admin.persist.datasource.DataSourceLoader;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.SnapshotPersister;
import blackboard.admin.snapshot.persist.impl.SessionProcedureQuery;
import blackboard.admin.snapshot.persist.impl.SnapshotProcedureQuery;
import blackboard.admin.snapshot.persist.impl.SnapshotRemoveProcedureQuery;
import blackboard.base.AppVersion;
import blackboard.data.BbAttribute;
import blackboard.data.BbObject;
import blackboard.data.Identifiable;
import blackboard.data.ValidationException;
import blackboard.db.ConnectionNotAvailableException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.course.impl.CourseCache;
import blackboard.persist.impl.NewBaseDbPersister;
import blackboard.persist.impl.Query;
import blackboard.persist.impl.mapping.DbObjectMap;
import blackboard.platform.LicenseComponent;
import blackboard.platform.LicenseManagerFactory;
import blackboard.platform.RuntimeBbServiceException;
import blackboard.platform.batch.enroll.PostBatchEnrollMessageHandler;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.ExceptionUtil;
import blackboard.util.UuidFactory;
import java.util.List;
import java.util.Set;

public abstract class SnapshotDbPersister<E extends Identifiable>
extends NewBaseDbPersister<E>
implements SnapshotPersister<E> {
    private boolean _uniqueSession = false;

    public void init(BbPersistenceManager pm, AppVersion appVersion) {
        block2: {
            super.init(pm, appVersion);
            try {
                this.checkApiLicensing();
            }
            catch (RuntimeBbServiceException exc) {
                if (!LicenseManagerFactory.getInstance().isLicensed(LicenseComponent.INTEGRATION_APIS)) break block2;
                throw exc;
            }
        }
    }

    protected void checkApiLicensing() {
        LicenseManagerFactory.getInstance().runtimeAssertIsLicensed(LicenseComponent.INTEGRATION_APIS);
    }

    protected String _createSession(String dataSourceBatchUid, String tableName) throws PersistenceException {
        String sessionId = UuidFactory.createUuid();
        this._uniqueSession = true;
        this._createSession(dataSourceBatchUid, tableName, sessionId);
        return sessionId;
    }

    protected void _createSession(String dataSourceBatchUid, String tableName, String sessionId) throws PersistenceException {
        TemporarySnapshotSessionManagerFactory.getInstance().createSnapshotSession(sessionId);
        DataSourceLoader dLoader = DataSourceLoader.Default.getInstance();
        DataSource dSource = dLoader.loadByBatchUid(dataSourceBatchUid);
        SessionProcedureQuery sQuery = new SessionProcedureQuery(tableName, dSource.getId(), sessionId);
        sQuery.init(this._bbDatabase, this._pm.getContainer());
        super.runQuery((Query)sQuery, null);
    }

    protected void closeSession(String strSessionId, String tableName) throws PersistenceException, KeyNotFoundException {
        SessionProcedureQuery sQuery = new SessionProcedureQuery(tableName, strSessionId);
        sQuery.init(this._bbDatabase, this._pm.getContainer());
        super.runQuery((Query)sQuery, null);
        if (this._uniqueSession) {
            TemporarySnapshotSessionManagerFactory.getInstance().deleteBySessionId(strSessionId);
        }
    }

    protected void save(DbObjectMap map, IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.handleAttributeTokens(obj);
        obj.validate();
        SnapshotProcedureQuery sQuery = new SnapshotProcedureQuery(map, (BbObject)obj, strSessionId);
        sQuery.init(this._bbDatabase, this._pm.getContainer());
        super.runQuery((Query)sQuery, null);
    }

    protected Results save(DbObjectMap map, List<E> objList, String strSessionId) throws PersistenceException {
        this.handleAttributeTokens(objList);
        SnapshotProcedureQuery sQuery = new SnapshotProcedureQuery(map, null, strSessionId);
        sQuery.init(this._bbDatabase, this._pm.getContainer());
        return sQuery.executeBatchQuery(objList);
    }

    protected Results remove(DbObjectMap map, List<E> objList) throws PersistenceException {
        SnapshotRemoveProcedureQuery sQuery = new SnapshotRemoveProcedureQuery(map, null);
        sQuery.init(this._bbDatabase, this._pm.getContainer());
        try {
            return sQuery.executeBatchQuery(objList);
        }
        catch (ConnectionNotAvailableException cna) {
            throw new PersistenceException((Throwable)cna);
        }
    }

    protected void flushCacheById(Identifiable obj) {
        Id objId = obj.getId();
        try {
            if (objId.getDataType() == CourseSite.DATA_TYPE || objId.getDataType() == Organization.DATA_TYPE) {
                CourseCache.getInstance().flushCourseById(objId.toExternalString());
            }
        }
        catch (Exception exc) {
            LogServiceFactory.getInstance().logDebug("flush attempt failed", (Throwable)exc);
        }
    }

    protected void flushCacheById(List<? extends Identifiable> objList) {
        for (Identifiable identifiable : objList) {
            this.flushCacheById(identifiable);
        }
    }

    protected void _checkForConstraintViolation(PersistenceException exc, String[] constraints) throws PersistenceException, ConstraintViolationException {
        if (ExceptionUtil.isSqlConstraintViolation((Throwable)exc, (String[])constraints)) {
            throw new ConstraintViolationException((Throwable)exc);
        }
        throw exc;
    }

    protected void sendPostEnrollmentEvents(List<? extends IAdminObject> list) {
        try {
            Set<String> courseIds = Membership.getCourseIdsSet(list);
            this.sendPostEnrollmentEvents(courseIds);
        }
        catch (PersistenceException e) {
            String msg = "Error gettings courses associated with committed enrollments. Could not post individual commit Snapshot Enrollment event.";
            LogServiceFactory.getInstance().logError(msg, (Throwable)e);
        }
    }

    protected void sendPostEnrollmentEvents(Set<String> courseIds) {
        PostBatchEnrollMessageHandler.submit(courseIds, (boolean)true);
    }

    protected E getSingleItem(List<E> items, E objTemplate) throws KeyNotFoundException {
        if (items.isEmpty()) {
            throw new KeyNotFoundException(objTemplate.getId().toString());
        }
        Identifiable item = (Identifiable)items.get(0);
        return (E)item;
    }

    protected void handleAttributeTokens(List<E> items) {
        for (Identifiable item : items) {
            if (!(item instanceof IAdminObject)) continue;
            this.handleAttributeTokens((IAdminObject)item);
        }
    }

    protected void handleAttributeTokens(IAdminObject obj) {
        for (BbAttribute bbAttr : obj.getBbAttributes().getBbAttributeList()) {
            if (bbAttr.getType() != BbAttribute.Type.STRING || bbAttr.getValue() == null || !((String)bbAttr.getValue()).equals("{CLEAR_VALUE}")) continue;
            bbAttr.setValue((Object)"");
        }
    }
}

