/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.category;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.category.AdminCategory;
import blackboard.admin.snapshot.serialize.Parser;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.data.BbAttributes;
import blackboard.data.ValidationException;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.StringUtil;
import blackboard.util.TextFormat;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.StringTokenizer;

public abstract class CategoryDelimitedParser
extends Parser {
    static final String CONTROLLED_SETTINGS = "category.bb.controlled.fields";
    static String[] _dataColumnList = new String[]{"external_category_key", "row_status", "available_ind", "title", "frontpage_ind", "new_data_source_key", "parent_category_key", "new_external_category_key", "description", "restrict_ind"};
    static String[] _requiredFieldList = new String[]{"external_category_key"};

    @Override
    protected String[] getBbListing() {
        return _dataColumnList;
    }

    @Override
    protected boolean validateHeaderForRequiredFields(String header) {
        for (String element : _requiredFieldList) {
            int pos = header.indexOf(element);
            int mrk = pos + element.length();
            if (pos <= -1 || mrk != header.length() && header.charAt(mrk) != this._authority.getConfigurationManager().getDelimiter()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean validateHeaderLabel(String line) {
        boolean bStatus = false;
        for (String element : _dataColumnList) {
            if (!element.equals(line)) continue;
            bStatus = true;
            break;
        }
        return bStatus;
    }

    @Override
    protected void handleAttributeMapping(IAdminObject obj, int absolutePos, String tmp, boolean bFlagNotDirty) throws ValidationException {
        AdminCategory objToReturn = (AdminCategory)obj;
        BbAttributes attribs = objToReturn.getBbAttributes();
        switch (absolutePos) {
            case 0: {
                objToReturn.setBatchUid(this.formatString(bFlagNotDirty, tmp, -1));
                break;
            }
            case 1: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setRowStatus(this._conversionUtil.stringToRowStatus(tmp));
                attribs.getBbAttribute("RowStatus").setIsDirty(bFlagNotDirty);
                break;
            }
            case 2: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setIsAvailable(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("IsAvailable").setIsDirty(bFlagNotDirty);
                break;
            }
            case 4: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setFrontPageInd(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("FrontPageInd").setIsDirty(bFlagNotDirty);
                break;
            }
            case 3: {
                objToReturn.setTitle(this.formatString(bFlagNotDirty, tmp, 255));
                attribs.getBbAttribute("Title").setIsDirty(bFlagNotDirty);
                break;
            }
            case 5: {
                objToReturn.setDataSourceBatchUid(this.formatString(bFlagNotDirty, tmp, -1));
                attribs.getBbAttribute("DataSourceBatchUid").setIsDirty(bFlagNotDirty);
                break;
            }
            case 6: {
                objToReturn.setParentBatchUid(this.formatString(bFlagNotDirty, tmp, -1));
                attribs.getBbAttribute("ParentBatchUid").setIsDirty(bFlagNotDirty);
                break;
            }
            case 7: {
                objToReturn.setReplacementBatchUid(this.formatString(bFlagNotDirty, tmp, -1));
                attribs.getBbAttribute("ReplacementBatchUid").setIsDirty(bFlagNotDirty);
                break;
            }
            case 8: {
                objToReturn.setDescription(this.formatString(bFlagNotDirty, tmp, 1000));
                attribs.getBbAttribute("Description").setIsDirty(bFlagNotDirty);
                break;
            }
            case 9: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setIsRestricted(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("IsRestricted").setIsDirty(bFlagNotDirty);
            }
        }
    }

    @Override
    protected void controlMaskInitialization() {
        String tmp = this._authority.getConfigurationManager().getSetting(CONTROLLED_SETTINGS);
        if (StringUtil.isEmpty((String)tmp)) {
            return;
        }
        StringTokenizer tkn = new StringTokenizer(tmp, ",");
        while (tkn.hasMoreElements()) {
            String txt = (String)tkn.nextElement();
            try {
                this._overrides.set(this.getPositionMapping().indexOf(txt.toLowerCase().trim()));
            }
            catch (IndexOutOfBoundsException io2) {
                LogServiceFactory.getInstance().logDebug("IndexOutOfBoundsException occurred in controlMaskInitialization. txt is " + txt, (Throwable)io2);
            }
        }
    }

    @Override
    protected void parameterMappingInitialization() {
        this._posMapping = new LinkedList();
        for (String element : _dataColumnList) {
            this._posMapping.addLast(element);
        }
        this._overrides = new BitSet(_dataColumnList.length);
    }
}

