/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.course;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.course.AdminCourse;
import blackboard.admin.data.course.AdminCourseXmlDef;
import blackboard.admin.data.course.CourseSite;
import blackboard.admin.data.course.CourseStandardSubDocument;
import blackboard.admin.data.course.Organization;
import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.config.OverriddenSetting;
import blackboard.admin.snapshot.serialize.XmlHandler;
import blackboard.admin.snapshot.serialize.XmlParser;
import blackboard.admin.snapshot.serialize.course.CourseDelimitedParser;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.admin.snapshot.util.TimeFormat;
import blackboard.base.BbEnum;
import blackboard.data.BbAttributes;
import blackboard.data.ValidationException;
import blackboard.data.course.ButtonStyle;
import blackboard.data.course.Classification;
import blackboard.data.course.Course;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.StringUtil;
import blackboard.xml.XmlUtil;
import java.util.ArrayDeque;
import java.util.Calendar;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CourseXmlHandler
extends XmlHandler
implements AdminCourseXmlDef {
    public static final String XML_REGISTRY = "group";
    static final String CONTROLLED_SETTINGS = "group.bb.controlled.fields";
    static final String TIME_FORMAT_ERROR_STR = "Course [%s]: Unable to generate %s date from string [%s]. Use format \"yyyy-MM-dd\" or \"yyyy-MM-dd'T'HH:mm:ss\"";
    private AdminCourse _obj;
    private final Map<String, String> _ovrMap = new HashMap<String, String>();
    private String _activeElement;
    private BbAttributes _bbAttribs;
    private DataType _dataType;
    private final Deque<CourseStandardSubDocument> _associations = new ArrayDeque<CourseStandardSubDocument>();
    private final XmlParser _xmlParser;
    private StringBuffer _xPath = new StringBuffer("");
    private NodeHandler _activeNodeHandler;
    private final Map<String, NodeHandler> _nodeHandlers = new HashMap<String, NodeHandler>();

    public CourseXmlHandler(XmlParser parser) {
        this._xmlParser = parser;
    }

    @Override
    public void init(Authority authority) {
        super.init(authority);
        try {
            this._dataType = new DataType(Class.forName(authority.getConfigurationManager().getSetting("DATA_TYPE_TOGGLE")));
        }
        catch (Exception exc) {
            this._dataType = CourseSite.DATA_TYPE;
        }
        String tmp = authority.getConfigurationManager().getSetting(CONTROLLED_SETTINGS);
        this.initNodeHandlers();
        if (StringUtil.isEmpty((String)tmp)) {
            return;
        }
        StringTokenizer tkn = new StringTokenizer(tmp, ",");
        while (tkn.hasMoreElements()) {
            String txt = (String)tkn.nextElement();
            if (authority.getOperation() == Authority.Operation.CLONE && txt.indexOf("template") > -1) continue;
            this._ovrMap.put(txt.toLowerCase(), "ignore");
        }
        this.initDelimitedXmlMapping();
    }

    private void initDelimitedXmlMapping() {
        this.handleDelimitedArrayXmlMapping(CourseDelimitedParser._eeDataColumnList);
        this.handleDelimitedArrayXmlMapping(CourseDelimitedParser._bbCrsDataColumnList);
        this.handleDelimitedArrayXmlMapping(CourseDelimitedParser._bbOrgDataColumnList);
    }

    private void handleDelimitedArrayXmlMapping(String[] elementList) {
        block31: for (int cnt = 0; cnt < elementList.length; ++cnt) {
            String value = elementList[cnt];
            if (value == null || value.length() == 0 || !this._ovrMap.containsKey(value.toLowerCase())) continue;
            switch (cnt) {
                case 0: {
                    this._ovrMap.put("short", "ignore");
                    continue block31;
                }
                case 2: {
                    this._ovrMap.put("long", "ignore");
                    continue block31;
                }
                case 3: {
                    this._ovrMap.put("full", "ignore");
                    continue block31;
                }
                case 4: {
                    this._ovrMap.put("begin", "ignore");
                    continue block31;
                }
                case 5: {
                    this._ovrMap.put("end", "ignore");
                    continue block31;
                }
                case 6: {
                    this._ovrMap.put("x_bb_classificationkey", "ignore");
                    continue block31;
                }
                case 27: {
                    this._ovrMap.put("x_bb_replacementkey", "ignore");
                    continue block31;
                }
                case 8: {
                    this._ovrMap.put("x_bb_row_status", "ignore");
                    continue block31;
                }
                case 9: {
                    this._ovrMap.put("x_bb_enrollment_type", "ignore");
                    continue block31;
                }
                case 10: {
                    this._ovrMap.put("x_bb_available", "ignore");
                    continue block31;
                }
                case 11: {
                    this._ovrMap.put("x_bb_catalog", "ignore");
                    continue block31;
                }
                case 13: {
                    this._ovrMap.put("x_bb_duration", "ignore");
                    continue block31;
                }
                case 14: {
                    this._ovrMap.put("x_bb_lockout_indicator", "ignore");
                    continue block31;
                }
                case 15: {
                    this._ovrMap.put("x_bb_pace", "ignore");
                    continue block31;
                }
                case 16: {
                    this._ovrMap.put("typevalue", "ignore");
                    continue block31;
                }
                case 17: {
                    this._ovrMap.put("x_bb_absolute_limit", "ignore");
                    continue block31;
                }
                case 18: {
                    this._ovrMap.put("x_bb_soft_limit", "ignore");
                    continue block31;
                }
                case 19: {
                    this._ovrMap.put("x_bb_upload_limit", "ignore");
                    continue block31;
                }
                case 20: {
                    this._ovrMap.put("x_bb_enroll_start", "ignore");
                    continue block31;
                }
                case 21: {
                    this._ovrMap.put("x_bb_enroll_end", "ignore");
                    continue block31;
                }
                case 22: {
                    this._ovrMap.put("x_bb_days_of_use", "ignore");
                    continue block31;
                }
                case 23: {
                    this._ovrMap.put("x_bb_institution_name", "ignore");
                    continue block31;
                }
                case 24: {
                    this._ovrMap.put("x_bb_fee", "ignore");
                    continue block31;
                }
                case 25: {
                    this._ovrMap.put("x_bb_allow_guests", "ignore");
                    continue block31;
                }
                case 26: {
                    this._ovrMap.put("x_bb_enrollment_access_code", "ignore");
                    continue block31;
                }
                case 7: {
                    this._ovrMap.put("x_bb_datasource_key", "ignore");
                    continue block31;
                }
                case 28: {
                    this._ovrMap.put("x_bb_templatekey", "ignore");
                    continue block31;
                }
                case 29: {
                    this._ovrMap.put("x_bb_allow_observers", "ignore");
                    continue block31;
                }
                case 32: {
                    this._ovrMap.put(OverriddenSetting.excludeDiscussionStarterPosts.name(), "ignore");
                }
            }
        }
    }

    private void initNodeHandlers() {
        this._nodeHandlers.put("/sourcedid", new SourcedIdHandler());
        this._nodeHandlers.put("/grouptype", new GroupTypeHandler());
        this._nodeHandlers.put("/description", new DescriptionHandler());
        this._nodeHandlers.put("/timeframe", new TimeFrameHandler());
        this._nodeHandlers.put("/extension", new ExtensionHandler());
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) {
        if (name.equalsIgnoreCase(XML_REGISTRY)) {
            this._obj = this._dataType.equals((Object)Organization.DATA_TYPE) ? new Organization() : new CourseSite();
            this._bbAttribs = this._obj.getBbAttributes();
            String recStatus = XmlUtil.getAttributeValue((Attributes)atts, (String)"recstatus", (String)"4");
            this._obj.setRecStatus((IAdminObject.RecStatus)IAdminObject.RecStatus.fromFieldName((String)recStatus, IAdminObject.RecStatus.class));
            return;
        }
        this._activeElement = name.toLowerCase();
        this._xPath = this._xPath.append("/").append(name);
        if (this._nodeHandlers.containsKey(this._xPath.toString())) {
            this._activeNodeHandler = this._nodeHandlers.get(this._xPath.toString());
            this._activeNodeHandler.handleAttributes(atts);
        }
        if ("sub_doc_batch_uid".equalsIgnoreCase(name)) {
            CourseStandardSubDocument association = new CourseStandardSubDocument();
            association.setCourseBatchUid(this._obj.getBatchUid());
            this._associations.push(association);
        }
        if (this._authority.getOperation() != Authority.Operation.REMOVE && "course_std_sub_doc_associations".equalsIgnoreCase(name)) {
            this._obj.setAssociationRefreshRequired(true);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        boolean bDirtyFlag;
        if (this._activeElement == null) {
            return;
        }
        String value = super.updateCharacterBuffer(ch, start, length).trim();
        boolean bl = bDirtyFlag = !this._ovrMap.containsKey(this._activeElement);
        if (this._activeNodeHandler != null) {
            this._activeNodeHandler.handleCharacters(value, bDirtyFlag);
        }
    }

    @Override
    public IAdminObject endElement(String uri, String local, String name) {
        super.endElement(uri, local, name);
        if (this._activeNodeHandler != null && this._xPath.toString().equalsIgnoreCase(this._activeNodeHandler.getPath())) {
            this._activeNodeHandler = null;
        }
        if (this._xPath.length() > 0) {
            this._xPath = this._xPath.delete(this._xPath.lastIndexOf("/"), this._xPath.length());
        }
        if (this._activeNodeHandler == null) {
            this._activeNodeHandler = this._nodeHandlers.get(this._xPath.toString());
        }
        if (name.equalsIgnoreCase(XML_REGISTRY)) {
            this._xmlParser.queue(this._obj);
            if (this._authority.getOperation() != Authority.Operation.REMOVE) {
                while (!this._associations.isEmpty()) {
                    this._xmlParser.queue(this._associations.pop());
                }
            }
        }
        return null;
    }

    @Override
    public void release() {
        this._obj = null;
    }

    private class ExtensionHandler
    implements NodeHandler {
        public static final String PATH = "/extension";

        private ExtensionHandler() {
        }

        @Override
        public void handleAttributes(Attributes atts) {
        }

        @Override
        public String getPath() {
            return PATH;
        }

        @Override
        public void handleCharacters(String value, boolean bFlagDirty) {
            if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_replacementkey")) {
                CourseXmlHandler.this._obj.setReplacementBatchUid(value);
                CourseXmlHandler.this._bbAttribs.getBbAttribute("ReplacementBatchUid").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_templatekey")) {
                CourseXmlHandler.this._obj.setTemplateBatchUid(value);
                CourseXmlHandler.this._bbAttribs.getBbAttribute("TemplateBatchUid").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_datasource_key")) {
                CourseXmlHandler.this._obj.setDataSourceBatchUid(value);
                CourseXmlHandler.this._bbAttribs.getBbAttribute("DataSourceBatchUid").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_row_status")) {
                CourseXmlHandler.this._obj.setRowStatus(CourseXmlHandler.this._cvUtility.intToRowStatus(XmlUtil.parseInteger((String)value)));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("RowStatus").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_available")) {
                CourseXmlHandler.this._obj.setIsAvailable(ConversionUtility.getBoolean(value));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("IsAvailable").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_days_of_use")) {
                if (value != null && "-1".equals(value)) {
                    CourseXmlHandler.this._bbAttribs.setInteger("NumDaysOfUse", null);
                } else if (value != null) {
                    CourseXmlHandler.this._bbAttribs.setInteger("NumDaysOfUse", XmlUtil.parseInteger((String)value));
                    CourseXmlHandler.this._obj.setDurationType(Course.Duration.FIXED_NUM_DAYS);
                    CourseXmlHandler.this._bbAttribs.getBbAttribute("NumDaysOfUse").setIsDirty(bFlagDirty);
                }
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_enrollment_access_code")) {
                CourseXmlHandler.this._bbAttribs.setString("EnrollmentAccessCode", value);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_catalog")) {
                CourseXmlHandler.this._obj.setShowInCatalog(ConversionUtility.getBoolean(value));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("ShowInCatalog").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_description_page")) {
                CourseXmlHandler.this._obj.setHasDescriptionPage(ConversionUtility.getBoolean(value));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("HasDescriptionPage").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_allow_guests")) {
                CourseXmlHandler.this._obj.setAllowGuests(ConversionUtility.getBoolean(value));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("AllowGuests").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_allow_observers")) {
                CourseXmlHandler.this._obj.setAllowObservers(ConversionUtility.getBoolean(value));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("AllowObservers").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_pace")) {
                CourseXmlHandler.this._obj.setPaceType(CourseXmlHandler.this._cvUtility.intToPace(XmlUtil.parseInteger((String)value)));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("PaceType").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_institution_name")) {
                CourseXmlHandler.this._obj.setInstitutionName(value);
                CourseXmlHandler.this._bbAttribs.getBbAttribute("InstitutionName").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_classificationkey")) {
                CourseXmlHandler.this._obj.setClassificationBatchUid(value);
                CourseXmlHandler.this._bbAttribs.getBbAttribute("ClassificationBatchUid").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_fee")) {
                CourseXmlHandler.this._obj.setFee(XmlUtil.parseFloat((String)value));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("Fee").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_locale")) {
                CourseXmlHandler.this._obj.setLocale(value);
                CourseXmlHandler.this._bbAttribs.getBbAttribute("Locale").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_locale_enforced_indicator")) {
                CourseXmlHandler.this._obj.setIsLocaleEnforced(ConversionUtility.getBoolean(value));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("IsLocaleEnforced").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_embedded_source")) {
                CourseXmlHandler.this._obj.getBbAttributes().setString("embed", value);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_data_source_id")) {
                try {
                    CourseXmlHandler.this._bbAttribs.setId("DataSourceId", Id.generateId((DataType)DataSource.DATA_TYPE, (String)value));
                }
                catch (Exception exc) {
                    CourseXmlHandler.this._bbAttribs.setId("DataSourceId", Id.UNSET_ID);
                }
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_internal_id")) {
                try {
                    CourseXmlHandler.this._obj.setId(Id.generateId((DataType)CourseXmlHandler.this._obj.getDataType(), (String)value));
                }
                catch (Exception exc) {
                    CourseXmlHandler.this._obj.setId(Id.UNSET_ID);
                }
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_internal_buttonstyles_id")) {
                try {
                    CourseXmlHandler.this._obj.setButtonStyleId(Id.generateId((DataType)ButtonStyle.DATA_TYPE, (String)value));
                }
                catch (Exception exc) {
                    LogServiceFactory.getInstance().logWarning("Unable to generate ButtonStyle id. value is " + value, (Throwable)exc);
                }
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_internal_classification_id")) {
                try {
                    CourseXmlHandler.this._obj.setClassificationId(Id.generateId((DataType)Classification.DATA_TYPE, (String)value));
                }
                catch (Exception exc) {
                    LogServiceFactory.getInstance().logWarning("Unable to generate Classification id. value is " + value, (Throwable)exc);
                }
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_enrollment_type")) {
                CourseXmlHandler.this._obj.setEnrollmentType(CourseXmlHandler.this._cvUtility.intToEnrollment(XmlUtil.parseInteger((String)value)));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("EnrollmentType").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_enroll_start")) {
                CourseXmlHandler.this._obj.setEnrollmentStartDate(TimeFormat.stringToCalendar(value));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("EnrollmentStartDate").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_enroll_end")) {
                CourseXmlHandler.this._obj.setEnrollmentEndDate(TimeFormat.stringToCalendar(value));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("EnrollmentEndDate").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_navstyle")) {
                try {
                    CourseXmlHandler.this._obj.setNavStyle(CourseXmlHandler.this._cvUtility.stringToNavStyle(value));
                }
                catch (ValidationException ve) {
                    CourseXmlHandler.this._obj.setNavStyle(Course.NavStyle.DEFAULT);
                }
                CourseXmlHandler.this._bbAttribs.getBbAttribute("NavStyle").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_duration")) {
                CourseXmlHandler.this._obj.setDurationType(CourseXmlHandler.this._cvUtility.intToDuration(XmlUtil.parseInteger((String)value)));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("DurationType").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_content_package")) {
                CourseXmlHandler.this._bbAttribs.setString("x_bb_content_package", value);
                CourseXmlHandler.this._bbAttribs.getBbAttribute("x_bb_content_package").setIsDirty(true);
            } else if ("sub_doc_batch_uid".equalsIgnoreCase(CourseXmlHandler.this._activeElement)) {
                ((CourseStandardSubDocument)CourseXmlHandler.this._associations.peek()).setSubDocBatchUid(value);
            }
        }
    }

    private class TimeFrameHandler
    implements NodeHandler {
        public static final String PATH = "/timeframe";

        private TimeFrameHandler() {
        }

        @Override
        public String getPath() {
            return PATH;
        }

        @Override
        public void handleAttributes(Attributes atts) {
        }

        @Override
        public void handleCharacters(String value, boolean bFlagDirty) {
            if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("begin")) {
                Calendar startDate = TimeFormat.stringToCalendar(value);
                if (startDate == null && StringUtil.notEmpty((String)value)) {
                    Object bUid = CourseXmlHandler.this._bbAttribs.getBbAttribute("BatchUid").getValue();
                    try {
                        CourseXmlHandler.this._xmlParser.warning(new SAXParseException(String.format(CourseXmlHandler.TIME_FORMAT_ERROR_STR, bUid == null ? "UNKNOWN" : bUid.toString(), "start", value), null));
                    }
                    catch (SAXException e) {
                        // empty catch block
                    }
                }
                CourseXmlHandler.this._obj.setStartDate(startDate);
                CourseXmlHandler.this._bbAttribs.getBbAttribute("StartDate").setIsDirty(bFlagDirty);
                CourseXmlHandler.this._obj.setDurationType(Course.Duration.DATE_RANGE);
                CourseXmlHandler.this._bbAttribs.getBbAttribute("DurationType").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("end")) {
                Calendar endDate = TimeFormat.stringToCalendar(value);
                if (endDate != null) {
                    endDate.set(11, 23);
                    endDate.set(12, 59);
                    endDate.set(13, 59);
                } else if (StringUtil.notEmpty((String)value)) {
                    Object bUid = CourseXmlHandler.this._bbAttribs.getBbAttribute("BatchUid").getValue();
                    try {
                        CourseXmlHandler.this._xmlParser.warning(new SAXParseException(String.format(CourseXmlHandler.TIME_FORMAT_ERROR_STR, bUid == null ? "UNKNOWN" : bUid.toString(), "end", value), null));
                    }
                    catch (SAXException e) {
                        // empty catch block
                    }
                }
                CourseXmlHandler.this._obj.setEndDate(endDate);
                CourseXmlHandler.this._bbAttribs.getBbAttribute("EndDate").setIsDirty(bFlagDirty);
                CourseXmlHandler.this._obj.setDurationType(Course.Duration.DATE_RANGE);
                CourseXmlHandler.this._bbAttribs.getBbAttribute("DurationType").setIsDirty(bFlagDirty);
            }
        }
    }

    private class DescriptionHandler
    implements NodeHandler {
        public static final String PATH = "/description";

        private DescriptionHandler() {
        }

        @Override
        public String getPath() {
            return PATH;
        }

        @Override
        public void handleAttributes(Attributes atts) {
        }

        @Override
        public void handleCharacters(String value, boolean bFlagDirty) {
            if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("short")) {
                CourseXmlHandler.this._obj.setCourseId(value);
                CourseXmlHandler.this._bbAttribs.getBbAttribute("CourseId").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("long")) {
                CourseXmlHandler.this._obj.setTitle(value);
                CourseXmlHandler.this._bbAttribs.getBbAttribute("Title").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("full")) {
                CourseXmlHandler.this._obj.setDescription(value);
                CourseXmlHandler.this._bbAttribs.getBbAttribute("Description").setIsDirty(bFlagDirty);
            }
        }
    }

    private class GroupTypeHandler
    implements NodeHandler {
        public static final String PATH = "/grouptype";

        private GroupTypeHandler() {
        }

        @Override
        public String getPath() {
            return PATH;
        }

        @Override
        public void handleAttributes(Attributes atts) {
        }

        @Override
        public void handleCharacters(String value, boolean bFlagDirty) {
            if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("typevalue")) {
                CourseXmlHandler.this._obj.getBbAttributes().setBbEnum("ServiceLevelType", (BbEnum)CourseXmlHandler.this._cvUtility.intToServiceLevel(XmlUtil.parseInteger((String)value)));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("ServiceLevelType").setIsDirty(bFlagDirty);
            }
        }
    }

    private class SourcedIdHandler
    implements NodeHandler {
        public static final String PATH = "/sourcedid";

        private SourcedIdHandler() {
        }

        @Override
        public String getPath() {
            return PATH;
        }

        @Override
        public void handleCharacters(String value, boolean bFlagDirty) {
            if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("id")) {
                CourseXmlHandler.this._obj.setBatchUid(value);
                CourseXmlHandler.this._bbAttribs.getBbAttribute("BatchUid").setIsDirty(bFlagDirty);
            }
        }

        @Override
        public void handleAttributes(Attributes atts) {
        }
    }

    private static interface NodeHandler {
        public String getPath();

        public void handleCharacters(String var1, boolean var2);

        public void handleAttributes(Attributes var1);
    }
}

