/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.integration;

import blackboard.admin.data.course.CourseSite;
import blackboard.admin.data.course.Membership;
import blackboard.admin.data.course.StaffAssignment;
import blackboard.admin.data.user.Person;
import blackboard.admin.snapshot.serialize.integration.SnapshotReader;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.util.StringUtil;
import org.dom4j.Element;

public abstract class AbstractSnapshotReader
implements SnapshotReader {
    static final String LEVEL = "level";
    protected ConversionUtility _cvUtility = new ConversionUtility();

    @Override
    public Person unmarshallPersonNode(Element node) {
        String txt;
        Element nElement;
        Person obj = new Person();
        Element sourcedidNode = node.element("sourcedid");
        if (sourcedidNode == null) {
            throw new RuntimeException("Id node not found.");
        }
        String strId = sourcedidNode.elementText("id");
        obj.setBatchUid(strId);
        obj.setUserName(node.elementText("userid"));
        Element nameNode = node.element("name");
        if (nameNode != null && (nElement = nameNode.element("n")) != null) {
            obj.setFamilyName(nElement.elementText("family"));
            obj.setGivenName(nElement.elementText("given"));
            obj.setTitle(nElement.elementText("prefix"));
            obj.setMiddleName(nElement.elementText("other"));
            obj.setOtherName(nElement.elementText("other"));
            obj.setSuffix(nElement.elementText("suffix"));
        }
        if (StringUtil.isEmpty((String)obj.getFamilyName())) {
            obj.setFamilyName("lastname");
        }
        if (StringUtil.isEmpty((String)obj.getGivenName())) {
            obj.setGivenName("firstname");
        }
        if (StringUtil.notEmpty((String)(txt = node.elementText("email")))) {
            obj.setEmailAddress(txt);
        }
        obj.setPassword("{empty}");
        obj.getBbAttributes().setString("embed", strId + "(" + obj.getUserName() + ")");
        return obj;
    }

    protected String unmarshallSourcedId(Element node) {
        Element objNode = node.element("sourcedid");
        if (objNode == null) {
            throw new RuntimeException("Id node not found.");
        }
        return objNode.elementText("id");
    }

    @Override
    public CourseSite unmarshallGroupNode(Element node) {
        CourseSite course = new CourseSite();
        String strId = this.unmarshallSourcedId(node);
        if (StringUtil.isEmpty((String)strId)) {
            throw new RuntimeException("Source id value not supplied.");
        }
        course.setBatchUid(strId);
        course.setCourseId(strId);
        Element type = null;
        type = node.element("grouptype");
        if (type == null) {
            return course;
        }
        if ((type = type.element("typevalue")) == null) {
            return course;
        }
        String theType = type.attribute(LEVEL).getText();
        course.getBbAttributes().setString(LEVEL, theType);
        course.getBbAttributes().setString("embed", strId);
        return course;
    }

    protected Membership unmarshallMembershipItem(Element node) {
        StaffAssignment enrollmentObj = new StaffAssignment();
        Element parent = node.getParent();
        Element objNode = parent.element("sourcedid");
        if (objNode == null) {
            throw new RuntimeException("Id node not found.");
        }
        enrollmentObj.setCourseSiteBatchUid(objNode.elementText("id"));
        objNode = node.element("sourcedid");
        if (objNode == null) {
            throw new RuntimeException("Id node not found.");
        }
        enrollmentObj.setPersonBatchUid(objNode.elementText("id"));
        enrollmentObj.getBbAttributes().setString("embed", enrollmentObj.getPersonBatchUid());
        return enrollmentObj;
    }
}

