/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.user;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.user.Person;
import blackboard.admin.snapshot.serialize.Parser;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.StringUtil;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class IntegrationPersonDelimitedParser
extends Parser {
    static final String CONTROLLED_SETTINGS = "person.bb.controlled.fields";
    static String[] _bbDataColumnList = new String[]{"user_id"};
    static String[] _requiredFieldList = new String[]{"user_id"};

    @Override
    public void checkApiLicensing() {
    }

    @Override
    protected String[] getBbListing() {
        return _bbDataColumnList;
    }

    @Override
    protected boolean validateHeaderForRequiredFields(String header) {
        for (String element : _requiredFieldList) {
            int pos = header.indexOf(element);
            int mrk = pos + element.length();
            if (pos <= -1 || mrk != header.length() && header.charAt(mrk) != this._authority.getConfigurationManager().getDelimiter()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean validateHeaderLabel(String line) {
        boolean bStatus = false;
        for (String element : _bbDataColumnList) {
            if (!element.equals(line)) continue;
            bStatus = true;
            break;
        }
        return bStatus;
    }

    @Override
    protected IAdminObject getObjectInstance() {
        return new Person();
    }

    @Override
    protected void handleAttributeMapping(IAdminObject obj, int absolutePos, String tmp, boolean bFlagNotDirty) {
        Person objToReturn = (Person)obj;
        switch (absolutePos) {
            case 0: {
                objToReturn.setUserName(this.formatString(bFlagNotDirty, tmp, -1));
            }
        }
    }

    @Override
    protected void controlMaskInitialization() {
        String tmp = this._authority.getConfigurationManager().getSetting(CONTROLLED_SETTINGS);
        if (StringUtil.isEmpty((String)tmp)) {
            return;
        }
        StringTokenizer tkn = new StringTokenizer(tmp, ",");
        while (tkn.hasMoreElements()) {
            String txt = (String)tkn.nextElement();
            try {
                this._overrides.set(this.getLegacyPositionMapping().indexOf(txt.toLowerCase().trim()));
            }
            catch (IndexOutOfBoundsException ioe) {
                LogServiceFactory.getInstance().logDebug("IndexOutOfBoundsException occurred 01. txt is " + txt, (Throwable)ioe);
            }
            try {
                this._overrides.set(this.getPositionMapping().indexOf(txt.toLowerCase().trim()));
            }
            catch (IndexOutOfBoundsException io2) {
                LogServiceFactory.getInstance().logDebug("IndexOutOfBoundsException occurred 02. txt is " + txt, (Throwable)io2);
            }
        }
    }

    @Override
    protected void parameterMappingInitialization() {
        this._legacyPosMapping = new LinkedList();
        this._posMapping = new LinkedList();
        for (String element : _bbDataColumnList) {
            this._posMapping.addLast(element);
        }
        this._overrides = new BitSet(_bbDataColumnList.length);
    }
}

