/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.user;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.data.user.ObserverAssociation;
import blackboard.admin.data.user.ObserverAssociationXmlDef;
import blackboard.admin.data.user.Person;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.serialize.XmlHandler;
import blackboard.admin.snapshot.serialize.user.ObserverAssociationDelimitedParser;
import blackboard.base.BbEnum;
import blackboard.data.BbAttributes;
import blackboard.data.BbObject;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.util.StringUtil;
import blackboard.xml.XmlUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;

public class ObserverAssociationXmlHandler
extends XmlHandler
implements ObserverAssociationXmlDef {
    public static final String XML_REGISTRY_1 = "observer_membership";
    public static final String XML_REGISTRY_2 = "observer_user";
    static final String CONTROLLED_SETTINGS = "observerassociation.bb.controlled.fields";
    private BbObject _obj;
    private final Map<String, String> _ovrMap = new HashMap<String, String>();
    private String _activeElement;
    private String _activeEntityElement;
    private BbAttributes _bbAttribs;
    private String _observerBatchUid;

    @Override
    public void init(Authority authority) {
        super.init(authority);
        String tmp = authority.getConfigurationManager().getSetting(CONTROLLED_SETTINGS);
        if (StringUtil.isEmpty((String)tmp)) {
            return;
        }
        StringTokenizer tkn = new StringTokenizer(tmp, ",");
        while (tkn.hasMoreElements()) {
            String txt = (String)tkn.nextElement();
            this._ovrMap.put(txt.toLowerCase(), "ignore");
        }
        this.initDelimitedXmlMapping();
    }

    private void initDelimitedXmlMapping() {
        this.handleDelimitedArrayXmlMapping(ObserverAssociationDelimitedParser.REQUIRED_FIELD_LIST);
    }

    private void handleDelimitedArrayXmlMapping(String[] elementList) {
        int index = 0;
        for (String value : elementList) {
            if (value != null && value.length() > 0 && this._ovrMap.containsKey(value.toLowerCase())) {
                switch (index) {
                    case 0: {
                        this._ovrMap.put("id", "ignore");
                        break;
                    }
                    case 2: {
                        this._ovrMap.put("x_bb_row_status", "ignore");
                        break;
                    }
                    case 3: {
                        this._ovrMap.put("x_bb_datasource_key", "ignore");
                    }
                }
            }
            ++index;
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) {
        if (name.equalsIgnoreCase(XML_REGISTRY_1)) {
            this._activeEntityElement = name;
        } else if (name.equalsIgnoreCase(XML_REGISTRY_2)) {
            this._obj = new ObserverAssociation();
            this._bbAttribs = this._obj.getBbAttributes();
            this._activeEntityElement = name;
            this._bbAttribs.setString("ObserverBatchUid", this._observerBatchUid);
            if (this._observerBatchUid != null) {
                this._bbAttribs.getBbAttribute("ObserverBatchUid").setIsDirty(true);
            }
            String recStatus = XmlUtil.getAttributeValue((Attributes)atts, (String)"recstatus", (String)"4");
            this._obj.getBbAttributes().setBbEnum("RecStatus", IAdminObject.RecStatus.fromFieldName((String)recStatus, IAdminObject.RecStatus.class));
        } else {
            this._activeElement = name.toLowerCase();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        boolean bDirtyFlag;
        if (this._activeElement == null) {
            return;
        }
        String value = super.updateCharacterBuffer(ch, start, length).trim();
        boolean bl = bDirtyFlag = !this._ovrMap.containsKey(this._activeElement);
        if (this._activeEntityElement.equalsIgnoreCase(XML_REGISTRY_1)) {
            this.unMarshallMembershipSourceIdNode(value, bDirtyFlag);
        } else if (!this.unMarshallMemberSourceIdNode(value, bDirtyFlag)) {
            this.unMarshallExtensionNode(value, bDirtyFlag);
        }
    }

    @Override
    public IAdminObject endElement(String uri, String local, String name) {
        super.endElement(uri, local, name);
        if (name.equalsIgnoreCase(XML_REGISTRY_2)) {
            return (IAdminObject)this._obj;
        }
        return null;
    }

    @Override
    public void release() {
        this._obj = null;
    }

    protected boolean unMarshallMembershipSourceIdNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("id")) {
            this._observerBatchUid = value;
            return true;
        }
        return false;
    }

    protected boolean unMarshallMemberSourceIdNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("id")) {
            this._obj.getBbAttributes().setString("UserBatchUid", value);
            this._bbAttribs.getBbAttribute("UserBatchUid").setIsDirty(bFlagDirty);
            return true;
        }
        return false;
    }

    protected boolean unMarshallExtensionNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("x_bb_row_status")) {
            this._obj.getBbAttributes().setBbEnum("RowStatus", (BbEnum)this._cvUtility.intToRowStatus(XmlUtil.parseInteger((String)value)));
            this._bbAttribs.getBbAttribute("RowStatus").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_datasource_key")) {
            this._obj.getBbAttributes().setString("DataSourceBatchUid", value);
            this._bbAttribs.getBbAttribute("DataSourceBatchUid").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_embedded_source")) {
            this._obj.getBbAttributes().setString("embed", value);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_data_source_id")) {
            try {
                this._bbAttribs.setId("DataSourceId", Id.generateId((DataType)DataSource.DATA_TYPE, (String)value));
            }
            catch (Exception e) {
                this._bbAttribs.setId("DataSourceId", Id.UNSET_ID);
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_internal_id")) {
            try {
                this._obj.setId(Id.generateId((DataType)DataSource.DATA_TYPE, (String)value));
            }
            catch (Exception e) {
                // empty catch block
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_user_id")) {
            DataType dataType = Person.DATA_TYPE;
            try {
                this._obj.getBbAttributes().setId("UsersId", Id.generateId((DataType)dataType, (String)value));
            }
            catch (Exception e) {
                // empty catch block
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_observer_id")) {
            DataType dataType = Person.DATA_TYPE;
            try {
                this._obj.getBbAttributes().setId("ObserverId", Id.generateId((DataType)dataType, (String)value));
            }
            catch (Exception e) {
                // empty catch block
            }
            return true;
        }
        return false;
    }
}

