/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.user;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.user.Person;
import blackboard.admin.snapshot.serialize.Parser;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.data.BbAttributes;
import blackboard.data.ValidationException;
import blackboard.data.user.User;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.StringUtil;
import blackboard.util.TextFormat;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class PersonDelimitedParser
extends Parser {
    static final String CONTROLLED_SETTINGS = "person.bb.controlled.fields";
    static String[] EE_DATA_COLUMN_LIST = new String[]{"campus_role", "campus_user_key", "username", "user_password", "title", "first_name", "middle_name", "last_name", "home_phone", "home_fax", "mobile_phone", "is_phone_avail", "user_email", "is_email_avail", "birthday", "address_line_1", "address_line_2", "city", "state_province", "zip_postal_code", "country", "is_home_avail", "company", "company_department", "job_title", "work_phone", "work_fax", "is_work_avail", "is_public", "person_id", "institution_role", "", "", "", "", "", "", "", "", "", "new_campus_user_key", "", "", "", ""};
    static String[] BB_DATA_COLUMN_LIST = new String[]{"system_role", "external_person_key", "user_id", "passwd", "title", "firstname", "middlename", "lastname", "h_phone_1", "h_fax", "m_phone", "phone_ind", "email", "email_ind", "birthdate", "street_1", "street_2", "city", "state", "zip_code", "country", "address_ind", "company", "department", "job_title", "b_phone_1", "b_fax", "work_ind", "public_ind", "student_id", "institution_role", "row_status", "gender", "b_phone_2", "h_phone_2", "webpage", "educ_level", "available_ind", "new_data_source_key", "settings", "new_external_person_key", "locale", "card_number", "othername", "suffix"};
    static String[] REQUIRED_FIELD_LIST = new String[]{"external_person_key", "campus_user_key"};

    @Override
    protected String[] getBbListing() {
        return BB_DATA_COLUMN_LIST;
    }

    @Override
    protected boolean validateHeaderForRequiredFields(String header) {
        for (String element : REQUIRED_FIELD_LIST) {
            int pos = header.indexOf(element);
            int mrk = pos + element.length();
            if (pos <= -1 || mrk != header.length() && header.charAt(mrk) != this._authority.getConfigurationManager().getDelimiter()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean validateHeaderLabel(String line) {
        for (String element : EE_DATA_COLUMN_LIST) {
            if (!element.equals(line)) continue;
            return true;
        }
        for (String element : BB_DATA_COLUMN_LIST) {
            if (!element.equals(line)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected IAdminObject getObjectInstance() {
        return new Person();
    }

    @Override
    protected void handleAttributeMapping(IAdminObject obj, int absolutePos, String tmp, boolean bFlagNotDirty) throws ValidationException {
        Person objToReturn = (Person)obj;
        BbAttributes _attribs = objToReturn.getBbAttributes();
        switch (absolutePos) {
            case 0: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                User.SystemRole role = this._conversionUtil.stringToSystemRole(tmp);
                if (null != role) {
                    objToReturn.setSystemRole(role);
                } else {
                    objToReturn.setSystemRoleIdentifier(tmp);
                }
                _attribs.getBbAttribute("SystemRole").setIsDirty(bFlagNotDirty);
                break;
            }
            case 1: {
                objToReturn.setBatchUid(this.formatString(bFlagNotDirty, tmp, -1));
                break;
            }
            case 2: {
                objToReturn.setUserName(this.formatString(bFlagNotDirty, tmp, -1));
                _attribs.getBbAttribute("UserName").setIsDirty(bFlagNotDirty);
                break;
            }
            case 3: {
                String password = this.formatString(bFlagNotDirty, tmp, -1);
                if (ConversionUtility.getBoolean(this._authority.getConfigurationManager().getSetting("encrypt.password"))) {
                    password = ConversionUtility.getHashValue(password);
                }
                objToReturn.setPassword(password);
                _attribs.getBbAttribute("Password").setIsDirty(bFlagNotDirty);
                break;
            }
            case 4: {
                objToReturn.setTitle(this.formatString(bFlagNotDirty, tmp, 100));
                _attribs.getBbAttribute("Title").setIsDirty(bFlagNotDirty);
                break;
            }
            case 5: {
                objToReturn.setGivenName(this.formatString(bFlagNotDirty, tmp, 100));
                _attribs.getBbAttribute("GivenName").setIsDirty(bFlagNotDirty);
                break;
            }
            case 6: {
                objToReturn.setMiddleName(this.formatString(bFlagNotDirty, tmp, 100));
                _attribs.getBbAttribute("MiddleName").setIsDirty(bFlagNotDirty);
                break;
            }
            case 7: {
                objToReturn.setFamilyName(this.formatString(bFlagNotDirty, tmp, 100));
                _attribs.getBbAttribute("FamilyName").setIsDirty(bFlagNotDirty);
                break;
            }
            case 43: {
                objToReturn.setOtherName(this.formatString(bFlagNotDirty, tmp, 100));
                _attribs.getBbAttribute("OtherName").setIsDirty(bFlagNotDirty);
                break;
            }
            case 44: {
                objToReturn.setSuffix(this.formatString(bFlagNotDirty, tmp, 100));
                _attribs.getBbAttribute("Suffix").setIsDirty(bFlagNotDirty);
                break;
            }
            case 8: {
                objToReturn.setHomePhone1(this.formatString(bFlagNotDirty, tmp, 50));
                _attribs.getBbAttribute("HomePhone1").setIsDirty(bFlagNotDirty);
                break;
            }
            case 9: {
                objToReturn.setHomeFax(this.formatString(bFlagNotDirty, tmp, 50));
                _attribs.getBbAttribute("HomeFax").setIsDirty(bFlagNotDirty);
                break;
            }
            case 10: {
                objToReturn.setMobilePhone(this.formatString(bFlagNotDirty, tmp, 50));
                _attribs.getBbAttribute("MobilePhone").setIsDirty(bFlagNotDirty);
                break;
            }
            case 11: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setShowAddContactInfo(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                _attribs.getBbAttribute("ShowAddContactInfo").setIsDirty(bFlagNotDirty);
                break;
            }
            case 12: {
                objToReturn.setEmailAddress(this.formatString(bFlagNotDirty, tmp, 100));
                _attribs.getBbAttribute("Email").setIsDirty(bFlagNotDirty);
                break;
            }
            case 13: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setShowEmailInfo(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                _attribs.getBbAttribute("ShowEmailInfo").setIsDirty(bFlagNotDirty);
                break;
            }
            case 14: {
                objToReturn.setBirthDate(this._conversionUtil.stringToCalendar(TextFormat.trimString((String)tmp, (int)-1)));
                _attribs.getBbAttribute("BirthDate").setIsDirty(bFlagNotDirty);
                break;
            }
            case 15: {
                objToReturn.setStreet1(this.formatString(bFlagNotDirty, tmp, 100));
                _attribs.getBbAttribute("Street1").setIsDirty(bFlagNotDirty);
                break;
            }
            case 16: {
                objToReturn.setStreet2(this.formatString(bFlagNotDirty, tmp, 100));
                _attribs.getBbAttribute("Street2").setIsDirty(bFlagNotDirty);
                break;
            }
            case 17: {
                objToReturn.setCity(this.formatString(bFlagNotDirty, tmp, 50));
                _attribs.getBbAttribute("City").setIsDirty(bFlagNotDirty);
                break;
            }
            case 18: {
                objToReturn.setState(this.formatString(bFlagNotDirty, tmp, 50));
                _attribs.getBbAttribute("State").setIsDirty(bFlagNotDirty);
                break;
            }
            case 19: {
                objToReturn.setZipCode(this.formatString(bFlagNotDirty, tmp, 50));
                _attribs.getBbAttribute("ZipCode").setIsDirty(bFlagNotDirty);
                break;
            }
            case 20: {
                objToReturn.setCountry(this.formatString(bFlagNotDirty, tmp, 50));
                _attribs.getBbAttribute("Country").setIsDirty(bFlagNotDirty);
                break;
            }
            case 21: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setShowAddressInfo(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                _attribs.getBbAttribute("ShowAddressInfo").setIsDirty(bFlagNotDirty);
                break;
            }
            case 22: {
                objToReturn.setCompany(this.formatString(bFlagNotDirty, tmp, 100));
                _attribs.getBbAttribute("Company").setIsDirty(bFlagNotDirty);
                break;
            }
            case 23: {
                objToReturn.setDepartment(this.formatString(bFlagNotDirty, tmp, 100));
                _attribs.getBbAttribute("Department").setIsDirty(bFlagNotDirty);
                break;
            }
            case 24: {
                objToReturn.setJobTitle(this.formatString(bFlagNotDirty, tmp, 100));
                _attribs.getBbAttribute("JobTitle").setIsDirty(bFlagNotDirty);
                break;
            }
            case 25: {
                objToReturn.setBusinessPhone1(this.formatString(bFlagNotDirty, tmp, 50));
                _attribs.getBbAttribute("BusinessPhone1").setIsDirty(bFlagNotDirty);
                break;
            }
            case 26: {
                objToReturn.setBusinessFax(this.formatString(bFlagNotDirty, tmp, 50));
                _attribs.getBbAttribute("BusinessFax").setIsDirty(bFlagNotDirty);
                break;
            }
            case 27: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setShowWorkInfo(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                _attribs.getBbAttribute("ShowWorkInfo").setIsDirty(bFlagNotDirty);
                break;
            }
            case 28: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setIsInfoPublic(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                _attribs.getBbAttribute("IsInfoPublic").setIsDirty(bFlagNotDirty);
                break;
            }
            case 29: {
                objToReturn.setStudentId(this.formatString(bFlagNotDirty, tmp, 100));
                _attribs.getBbAttribute("StudentId").setIsDirty(bFlagNotDirty);
                break;
            }
            case 30: {
                if (this._authority.getConfigurationManager().isSOAPEnabled()) {
                    objToReturn.getBbAttributes().setString("StringPortalRole", tmp);
                    break;
                }
                objToReturn.setPortalRole(this._conversionUtil.stringToInstitutionRole(tmp));
                _attribs.getBbAttribute("PortalRoleId").setIsDirty(bFlagNotDirty);
                _attribs.getBbAttribute("PortalRole").setIsDirty(bFlagNotDirty);
                break;
            }
            case 31: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setRowStatus(this._conversionUtil.stringToRowStatus(tmp));
                _attribs.getBbAttribute("RowStatus").setIsDirty(bFlagNotDirty);
                break;
            }
            case 32: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setGender(this._conversionUtil.stringToGender(tmp));
                _attribs.getBbAttribute("Gender").setIsDirty(bFlagNotDirty);
                break;
            }
            case 33: {
                objToReturn.setBusinessPhone2(this.formatString(bFlagNotDirty, tmp, 100));
                _attribs.getBbAttribute("BusinessPhone2").setIsDirty(bFlagNotDirty);
                break;
            }
            case 34: {
                objToReturn.setHomePhone2(this.formatString(bFlagNotDirty, tmp, 100));
                _attribs.getBbAttribute("HomePhone2").setIsDirty(bFlagNotDirty);
                break;
            }
            case 35: {
                objToReturn.setWebPage(this.formatString(bFlagNotDirty, tmp, 100));
                _attribs.getBbAttribute("WebPage").setIsDirty(bFlagNotDirty);
                break;
            }
            case 36: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setEducationLevel(this._conversionUtil.stringToEducationLevel(tmp));
                _attribs.getBbAttribute("EducationLevel").setIsDirty(bFlagNotDirty);
                break;
            }
            case 37: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setIsAvailable(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                _attribs.getBbAttribute("IsAvailable").setIsDirty(bFlagNotDirty);
                break;
            }
            case 38: {
                objToReturn.setDataSourceBatchUid(this.formatString(bFlagNotDirty, tmp, -1));
                _attribs.getBbAttribute("DataSourceBatchUid").setIsDirty(bFlagNotDirty);
                break;
            }
            case 39: {
                objToReturn.setSettings(this.formatString(bFlagNotDirty, tmp, 2000));
                _attribs.getBbAttribute("Settings").setIsDirty(bFlagNotDirty);
                break;
            }
            case 40: {
                objToReturn.setReplacementBatchUid(this.formatString(bFlagNotDirty, tmp, -1));
                _attribs.getBbAttribute("ReplacementBatchUid").setIsDirty(bFlagNotDirty);
                break;
            }
            case 41: {
                objToReturn.setLocale(this.formatString(bFlagNotDirty, tmp, -1));
                _attribs.getBbAttribute("Locale").setIsDirty(bFlagNotDirty);
                break;
            }
        }
    }

    @Override
    protected void controlMaskInitialization() {
        String tmp = this._authority.getConfigurationManager().getSetting(CONTROLLED_SETTINGS);
        if (StringUtil.isEmpty((String)tmp)) {
            return;
        }
        StringTokenizer tkn = new StringTokenizer(tmp, ",");
        while (tkn.hasMoreElements()) {
            String txt = (String)tkn.nextElement();
            try {
                this._overrides.set(this.getLegacyPositionMapping().indexOf(txt.toLowerCase().trim()));
            }
            catch (IndexOutOfBoundsException ioe) {
                LogServiceFactory.getInstance().logDebug("IndexOutOfBoundsException occurred for: " + txt, (Throwable)ioe);
            }
            try {
                this._overrides.set(this.getPositionMapping().indexOf(txt.toLowerCase().trim()));
            }
            catch (IndexOutOfBoundsException io2) {
                LogServiceFactory.getInstance().logDebug("IndexOutOfBoundsException occurred for: " + txt, (Throwable)io2);
            }
        }
    }

    @Override
    protected void parameterMappingInitialization() {
        this._legacyPosMapping = new LinkedList();
        for (String element : EE_DATA_COLUMN_LIST) {
            this._legacyPosMapping.addLast(element);
        }
        this._posMapping = new LinkedList();
        for (String element : BB_DATA_COLUMN_LIST) {
            this._posMapping.addLast(element);
        }
        this._overrides = new BitSet(BB_DATA_COLUMN_LIST.length);
    }
}

