/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.util;

import blackboard.admin.data.course.AdminCourse;
import blackboard.util.BbSystemWrapper;
import java.text.MessageFormat;

public class AdminTextUtil {
    public static void flushMessageBuffer(String previousMessage, String message) {
        String clear = AdminTextUtil.buildClearLine(previousMessage, message);
        BbSystemWrapper.print((String)clear);
    }

    protected static String buildClearLine(String previousMessage, String message) {
        boolean doEmptyFirst;
        String lastLineOfPrevious;
        StringBuilder clear = new StringBuilder("\r");
        String firstLineOfReplacement = message;
        int eol = firstLineOfReplacement.indexOf(10);
        if (-1 != eol) {
            firstLineOfReplacement = firstLineOfReplacement.substring(0, eol);
        }
        if (-1 != (eol = firstLineOfReplacement.indexOf(13))) {
            firstLineOfReplacement = firstLineOfReplacement.substring(0, eol);
        }
        if (-1 != (eol = (lastLineOfPrevious = previousMessage).lastIndexOf(10))) {
            lastLineOfPrevious = lastLineOfPrevious.substring(eol + 1);
        }
        boolean bl = doEmptyFirst = firstLineOfReplacement.length() < lastLineOfPrevious.length();
        if (doEmptyFirst) {
            for (long i = 0L; i < (long)lastLineOfPrevious.length(); ++i) {
                clear.append(" ");
            }
            clear.append("\r");
        }
        String clear1 = clear.toString();
        return clear1;
    }

    public static String getInterval(long difference) {
        long seconds;
        long minutes;
        MessageFormat format = new MessageFormat("{0}:{1}:{2}.{3}");
        long held = difference;
        long hours = held / 3600000L;
        if (hours > 0L) {
            held -= hours * 60L * 60L * 1000L;
        }
        if ((minutes = held / 60000L) > 0L) {
            held -= minutes * 60L * 1000L;
        }
        if ((seconds = held / 1000L) > 0L) {
            held -= seconds * 1000L;
        }
        long millis = held;
        String strHours = AdminTextUtil.formatNumber(hours, 2);
        String strMinutes = AdminTextUtil.formatNumber(minutes, 2);
        String strSeconds = AdminTextUtil.formatNumber(seconds, 2);
        String strMillis = AdminTextUtil.formatNumber(millis, 3);
        Object[] messageArgs = new Object[]{strHours, strMinutes, strSeconds, strMillis};
        return format.format(messageArgs);
    }

    private static String formatNumber(long number, int numPlaces) {
        String result = String.valueOf(number);
        for (int i = result.length(); i < numPlaces; ++i) {
            result = "0" + result;
        }
        return result;
    }

    public static String replaceIllegalChars(String text) {
        if (text == null) {
            return "";
        }
        char[] charBuffer = text.toCharArray();
        for (int pos = 0; pos < charBuffer.length; ++pos) {
            if (Character.isLetterOrDigit(charBuffer[pos])) continue;
            boolean isValidChar = false;
            for (int val = 0; val < AdminCourse.getValidChars().length; ++val) {
                if (charBuffer[pos] != AdminCourse.getValidChars()[val]) continue;
                isValidChar = true;
                break;
            }
            if (isValidChar) continue;
            charBuffer[pos] = 95;
        }
        return String.valueOf(charBuffer);
    }
}

