/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import java.util.Map;
import java.util.Properties;

public class AuthorizationRequiredException
extends RuntimeException {
    private String _scheme;
    private Map _properties;

    public static AuthorizationRequiredException createBasicAuthenticationRequiredException(String realm) {
        Properties props = new Properties();
        props.put("realm", realm);
        return new AuthorizationRequiredException("Basic", props);
    }

    static AuthorizationRequiredException createException(String scheme, Map properties) {
        return new AuthorizationRequiredException(scheme, properties);
    }

    private AuthorizationRequiredException(String scheme, Map properties) {
        this._scheme = scheme;
        this._properties = properties;
    }

    public String getMessage() {
        return this._scheme + " authentication required: " + this._properties;
    }

    public String getAuthenticationScheme() {
        return this._scheme;
    }

    public String getAuthenticationParameter(String parameterName) {
        return this.unQuote((String)this._properties.get(parameterName));
    }

    private String unQuote(String value) {
        if (value == null || value.length() <= 1 || !value.startsWith("\"") || !value.endsWith("\"")) {
            return value;
        }
        return value.substring(1, value.length() - 1);
    }
}

