/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FrameSelector;
import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.HTMLElementScriptable;
import com.meterware.httpunit.HTMLSegment;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.ParsedHTML;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import com.meterware.httpunit.scripting.ScriptingHandler;
import java.net.URL;
import org.w3c.dom.Node;

public abstract class BlockElement
extends ParsedHTML
implements HTMLSegment,
HTMLElement {
    private ScriptingHandler _scriptable;
    private Node _node;

    public String getText() {
        if (this._node.getNodeType() == 3) {
            return this._node.getNodeValue().trim();
        }
        if (this._node == null || !this._node.hasChildNodes()) {
            return "";
        }
        return NodeUtils.asText(this._node.getChildNodes()).trim();
    }

    public String getTagName() {
        return this._node == null ? "p" : this._node.getNodeName();
    }

    public Node getDOM() {
        return super.getDOM();
    }

    public String getID() {
        return this.getAttribute("id");
    }

    public String getClassName() {
        return this.getAttribute("class");
    }

    public String getName() {
        return this.getAttribute("name");
    }

    public String getTitle() {
        return this.getAttribute("title");
    }

    public ScriptingHandler getScriptingHandler() {
        if (this._scriptable == null) {
            this._scriptable = HttpUnitOptions.getScriptingEngine().createHandler(this);
        }
        return this._scriptable;
    }

    public boolean doEvent(String eventScript) {
        return this.doEventScript(eventScript);
    }

    public boolean doEventScript(String eventScript) {
        return this.getScriptingHandler().doEventScript(eventScript);
    }

    public boolean handleEvent(String eventName) {
        return this.getScriptingHandler().handleEvent(eventName);
    }

    public ScriptableDelegate getParentDelegate() {
        return this.getResponse().getDocumentScriptable();
    }

    public ScriptableDelegate newScriptable() {
        return new HTMLElementScriptable(this);
    }

    public String getAttribute(String name) {
        return NodeUtils.getNodeAttribute(this._node, name);
    }

    public void setAttribute(String name, Object value) {
        NodeUtils.setNodeAttribute(this._node, name, value == null ? null : value.toString());
    }

    public void removeAttribute(String name) {
        NodeUtils.removeNodeAttribute(this._node, name);
    }

    public boolean isSupportedAttribute(String name) {
        return false;
    }

    public Node getNode() {
        return this._node;
    }

    public boolean equals(Object obj) {
        return this.getClass().equals(obj.getClass()) && this.equals((BlockElement)obj);
    }

    private boolean equals(BlockElement block) {
        return this._node.equals(block._node);
    }

    public int hashCode() {
        return this._node.hashCode();
    }

    protected BlockElement(WebResponse response, FrameSelector frame, URL baseURL, String baseTarget, Node rootNode, String characterSet) {
        super(response, frame, baseURL, baseTarget, rootNode, characterSet);
        this._node = rootNode;
    }

    protected int getAttributeValue(Node node, String attributeName, int defaultValue) {
        return NodeUtils.getAttributeValue(node, attributeName, defaultValue);
    }
}

