/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.Button;
import com.meterware.httpunit.CheckboxFormControl;
import com.meterware.httpunit.FileSubmitFormControl;
import com.meterware.httpunit.FormParameter;
import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.HTMLElementBase;
import com.meterware.httpunit.HTMLElementScriptable;
import com.meterware.httpunit.HiddenFieldFormControl;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.MissingParameterValueException;
import com.meterware.httpunit.PasswordFieldFormControl;
import com.meterware.httpunit.RadioButtonFormControl;
import com.meterware.httpunit.ResetButton;
import com.meterware.httpunit.SubmitButton;
import com.meterware.httpunit.TextAreaFormControl;
import com.meterware.httpunit.TextFieldFormControl;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.controls.SelectionFormControl;
import com.meterware.httpunit.dom.HTMLControl;
import com.meterware.httpunit.dom.HTMLInputElementImpl;
import com.meterware.httpunit.dom.HTMLSelectElementImpl;
import com.meterware.httpunit.dom.HTMLTextAreaElementImpl;
import com.meterware.httpunit.protocol.ParameterProcessor;
import com.meterware.httpunit.scripting.Input;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class FormControl
extends HTMLElementBase {
    static final String[] NO_VALUE = new String[0];
    private final WebForm _form;
    private HTMLControl _control;
    public static final String UNDEFINED_TYPE = "undefined";
    public static final String BUTTON_TYPE = "button";
    public static final String RESET_BUTTON_TYPE = "reset";
    public static final String SUBMIT_BUTTON_TYPE = "submit";
    public static final String IMAGE_BUTTON_TYPE = "image";
    public static final String RADIO_BUTTON_TYPE = "radio";
    public static final String CHECKBOX_TYPE = "checkbox";
    public static final String TEXT_TYPE = "text";
    public static final String PASSWORD_TYPE = "password";
    public static final String HIDDEN_TYPE = "hidden";
    public static final String TEXTAREA_TYPE = "textarea";
    public static final String FILE_TYPE = "file";
    public static final String SINGLE_TYPE = "select-one";
    public static final String MULTIPLE_TYPE = "select-multiple";

    public abstract String getType();

    static ScriptableDelegate newSelectionOption() {
        return new SelectionFormControl.Option();
    }

    FormControl(WebForm form) {
        this(form, FormControl.newEmptyControlElement(form));
    }

    private static HTMLControl newEmptyControlElement(WebForm form) {
        return (HTMLControl)form.getElement().getOwnerDocument().createElement("input");
    }

    protected FormControl(WebForm form, HTMLControl control) {
        super(control);
        this._control = control;
        this._form = form;
        this.supportAttribute("tabindex");
        this.supportAttribute("disabled");
        Set customAttributes = HttpUnitOptions.getCustomAttributes();
        if (customAttributes != null) {
            Iterator iter = customAttributes.iterator();
            while (iter.hasNext()) {
                this.supportAttribute((String)iter.next());
            }
        }
    }

    protected abstract String[] getValues();

    Object getDelegate() {
        return this.getScriptingHandler();
    }

    protected final WebForm getForm() {
        return this._form;
    }

    public ScriptableDelegate getParentDelegate() {
        return (ScriptableDelegate)this.getForm().getScriptingHandler();
    }

    public String[] getOptionValues() {
        return NO_VALUE;
    }

    protected String[] getDisplayedOptions() {
        return NO_VALUE;
    }

    protected boolean isReadOnly() {
        return this.isDisabled() || this._control.getReadOnly();
    }

    public boolean isHidden() {
        return false;
    }

    void setDisabled(boolean disabled) {
        this._control.setDisabled(disabled);
    }

    public boolean isDisabled() {
        return this._control.getDisabled();
    }

    boolean isTextControl() {
        return false;
    }

    boolean isExclusive() {
        return false;
    }

    protected boolean isMultiValued() {
        return false;
    }

    boolean isFileParameter() {
        return false;
    }

    protected abstract void addValues(ParameterProcessor var1, String var2) throws IOException;

    void claimRequiredValues(List values) {
    }

    void claimValue(List values) {
    }

    protected void claimUniqueValue(List values) {
    }

    void claimUploadSpecification(List files) {
    }

    protected void reset() {
        this._control.reset();
    }

    public void toggle() {
        throw new FormParameter.IllegalCheckboxParameterException(this.getName(), "toggleCheckbox");
    }

    public void setState(boolean state) {
        throw new FormParameter.IllegalCheckboxParameterException(this.getName(), "setCheckbox");
    }

    protected void sendOnChangeEvent() {
        this.doOnChangeEvent();
    }

    protected boolean doOnChangeEvent() {
        return this.handleEvent("onchange");
    }

    protected void sendOnClickEvent() {
        this.doOnClickEvent();
    }

    protected boolean doOnClickEvent() {
        return this.handleEvent("onclick");
    }

    protected void sendOnMouseUpEvent() {
        this.doOnMouseUpEvent();
    }

    protected boolean doOnMouseUpEvent() {
        return this.handleEvent("onmouseup");
    }

    protected void sendOnMouseDownEvent() {
        this.doOnMouseDownEvent();
    }

    protected boolean doOnMouseDownEvent() {
        return this.handleEvent("onmousedown");
    }

    public ScriptableDelegate newScriptable() {
        return new Scriptable();
    }

    protected String getValueAttribute() {
        return "";
    }

    protected void setValueAttribute(String value) {
    }

    protected final void claimValueIsRequired(List values, String value) {
        if (!values.contains(value)) {
            throw new MissingParameterValueException(this.getName(), value, values.toArray(new String[values.size()]));
        }
        values.remove(value);
    }

    static String[] getControlElementTags() {
        return new String[]{TEXTAREA_TYPE, "select", BUTTON_TYPE, "input"};
    }

    static FormControl newFormParameter(WebForm form, Node node) {
        if (node.getNodeType() != 1) {
            return null;
        }
        if (node.getNodeName().equalsIgnoreCase(TEXTAREA_TYPE)) {
            return new TextAreaFormControl(form, (HTMLTextAreaElementImpl)node);
        }
        if (node.getNodeName().equalsIgnoreCase("select")) {
            return new SelectionFormControl(form, (HTMLSelectElementImpl)node);
        }
        if (node.getNodeName().equalsIgnoreCase(BUTTON_TYPE)) {
            HTMLControl control = (HTMLControl)node;
            String type = control.getType();
            if (type.equalsIgnoreCase(SUBMIT_BUTTON_TYPE)) {
                return new SubmitButton(form, control);
            }
            if (type.equalsIgnoreCase(RESET_BUTTON_TYPE)) {
                return new ResetButton(form, control);
            }
            return new Button(form, control);
        }
        if (!node.getNodeName().equalsIgnoreCase("input")) {
            return null;
        }
        HTMLInputElementImpl element = (HTMLInputElementImpl)node;
        String type = element.getType();
        if (type.equalsIgnoreCase(TEXT_TYPE)) {
            return new TextFieldFormControl(form, element);
        }
        if (type.equalsIgnoreCase(PASSWORD_TYPE)) {
            return new PasswordFieldFormControl(form, element);
        }
        if (type.equalsIgnoreCase(HIDDEN_TYPE)) {
            return new HiddenFieldFormControl(form, element);
        }
        if (type.equalsIgnoreCase(RADIO_BUTTON_TYPE)) {
            return new RadioButtonFormControl(form, element);
        }
        if (type.equalsIgnoreCase(CHECKBOX_TYPE)) {
            return new CheckboxFormControl(form, element);
        }
        if (type.equalsIgnoreCase(SUBMIT_BUTTON_TYPE) || type.equalsIgnoreCase(IMAGE_BUTTON_TYPE)) {
            return new SubmitButton(form, (HTMLControl)element);
        }
        if (type.equalsIgnoreCase(BUTTON_TYPE)) {
            return new Button(form, (HTMLControl)node);
        }
        if (type.equalsIgnoreCase(RESET_BUTTON_TYPE)) {
            return new ResetButton(form, (HTMLControl)node);
        }
        if (type.equalsIgnoreCase(FILE_TYPE)) {
            return new FileSubmitFormControl(form, element);
        }
        return new TextFieldFormControl(form, element);
    }

    protected String emptyIfNull(String value) {
        return value == null ? "" : value;
    }

    public class Scriptable
    extends HTMLElementScriptable
    implements Input {
        public String getName() {
            return FormControl.this.getName();
        }

        public String getID() {
            return FormControl.this.getID();
        }

        public Scriptable() {
            super(FormControl.this);
        }

        public Object get(String propertyName) {
            if (propertyName.equalsIgnoreCase("name")) {
                return FormControl.this.getName();
            }
            if (propertyName.equalsIgnoreCase("type")) {
                return FormControl.this.getType();
            }
            return super.get(propertyName);
        }

        public void set(String propertyName, Object value) {
            if (propertyName.equalsIgnoreCase("value")) {
                FormControl.this.setValueAttribute(value.toString());
            } else if (propertyName.equalsIgnoreCase("disabled")) {
                FormControl.this.setDisabled(value instanceof Boolean && (Boolean)value != false);
            } else {
                super.set(propertyName, value);
            }
        }

        public void setAttribute(String attributeName, Object value) {
            FormControl.this.supportAttribute(attributeName);
            super.setAttribute(attributeName, value);
        }

        public void click() throws IOException, SAXException {
            HTMLElement element = this.get_element();
            if (element instanceof FormControl) {
                FormControl control = (FormControl)element;
                control.sendOnClickEvent();
            }
        }

        public void blur() {
            this.handleEvent("onblur");
        }

        public void focus() {
            this.handleEvent("onfocus");
        }

        public void sendOnChangeEvent() {
            HTMLElement element = this.get_element();
            if (element instanceof FormControl) {
                FormControl control = (FormControl)element;
                control.sendOnChangeEvent();
            }
        }
    }
}

