/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FormControl;
import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.dom.HTMLControl;
import com.meterware.httpunit.protocol.ParameterProcessor;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.io.IOException;
import java.util.List;

abstract class TextFormControl
extends FormControl {
    public TextFormControl(WebForm form, HTMLControl control) {
        super(form, control);
    }

    public String[] getValues() {
        return new String[]{this.getValue()};
    }

    protected abstract String getDefaultValue();

    protected abstract String getValue();

    protected abstract void setValue(String var1);

    public boolean isTextControl() {
        return true;
    }

    public ScriptableDelegate newScriptable() {
        return new Scriptable();
    }

    protected void addValues(ParameterProcessor processor, String characterSet) throws IOException {
        if (!this.isDisabled() && this.getName().length() > 0) {
            processor.addParameter(this.getName(), this.getValues()[0], characterSet);
        }
    }

    void claimValue(List values) {
        boolean same;
        if (this.isReadOnly()) {
            return;
        }
        String oldValue = this.getValue();
        if (values.isEmpty()) {
            this.setValue("");
        } else {
            this.setValue((String)values.get(0));
            values.remove(0);
        }
        boolean bl = same = oldValue == null && this.getValue() == null;
        if (oldValue != null) {
            same = oldValue.equals(this.getValue());
        }
        if (!same) {
            this.sendOnChangeEvent();
        }
    }

    void claimRequiredValues(List values) {
        if (this.isReadOnly()) {
            this.claimValueIsRequired(values);
        }
    }

    protected void claimValueIsRequired(List values) {
        this.claimValueIsRequired(values, this.getDefaultValue());
    }

    class Scriptable
    extends FormControl.Scriptable {
        Scriptable() {
        }

        public Object get(String propertyName) {
            if (propertyName.equalsIgnoreCase("value")) {
                return TextFormControl.this.getValue();
            }
            if (propertyName.equalsIgnoreCase("defaultValue")) {
                return TextFormControl.this.getDefaultValue();
            }
            return super.get(propertyName);
        }

        public void set(String propertyName, Object value) {
            if (!propertyName.equalsIgnoreCase("value")) {
                super.set(propertyName, value);
            } else if (value instanceof Number) {
                TextFormControl.this.setValue(HttpUnitUtils.trimmedValue((Number)value));
            } else {
                TextFormControl.this.setValue(value == null ? null : value.toString());
            }
        }
    }
}

