/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FrameSelector;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.HttpsProtocolSupport;
import com.meterware.httpunit.HttpsURLStreamHandler;
import com.meterware.httpunit.IllegalButtonPositionException;
import com.meterware.httpunit.IllegalNonFileParameterException;
import com.meterware.httpunit.IllegalRequestParameterException;
import com.meterware.httpunit.JavascriptURLStreamHandler;
import com.meterware.httpunit.MultipartFormRequiredException;
import com.meterware.httpunit.ParameterHolder;
import com.meterware.httpunit.SubmitButton;
import com.meterware.httpunit.UncheckedParameterHolder;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebRequestSource;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.protocol.ParameterProcessor;
import com.meterware.httpunit.protocol.UploadFileSpec;
import com.meterware.httpunit.scripting.ScriptingHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class WebRequest {
    static final String REFERER_HEADER_NAME = "Referer";
    private static URLStreamHandler JAVASCRIPT_STREAM_HANDLER = new JavascriptURLStreamHandler();
    private static URLStreamHandler HTTPS_STREAM_HANDLER = new HttpsURLStreamHandler();
    private final ParameterHolder _parameterHolder;
    private URL _urlBase;
    private FrameSelector _sourceFrame;
    private String _requestTarget;
    private String _urlString;
    private Hashtable _headers;
    private WebRequestSource _webRequestSource;
    private WebResponse _referringPage;
    private SubmitButton _button;
    private Element _sourceElement;
    private String _characterSet;
    protected String method;
    static final String TOP_FRAME = "_top";
    static final String PARENT_FRAME = "_parent";
    static final String NEW_WINDOW = "_blank";
    static final String SAME_FRAME = "_self";

    public void setHeaderField(String headerName, String headerValue) {
        this.getHeaderDictionary().put(headerName, headerValue);
    }

    public Dictionary getHeaders() {
        return (Dictionary)this.getHeaderDictionary().clone();
    }

    public URL getURL() throws MalformedURLException {
        if (this.getURLBase() == null || this.getURLBase().toString().indexOf("?") < 0) {
            return this.newURL(this.getURLBase(), this.getURLString());
        }
        String urlBaseString = this.getURLBase().toString();
        URL newurlbase = new URL(urlBaseString.substring(0, urlBaseString.indexOf("?")));
        return this.newURL(newurlbase, this.getURLString());
    }

    private URL newURL(URL base, String spec) throws MalformedURLException {
        if (spec.toLowerCase().startsWith("javascript:")) {
            return new URL("javascript", null, -1, spec.substring("javascript:".length()), JAVASCRIPT_STREAM_HANDLER);
        }
        if (spec.toLowerCase().startsWith("https:") && !HttpsProtocolSupport.hasHttpsSupport()) {
            return new URL("https", null, -1, spec.substring("https:".length()), HTTPS_STREAM_HANDLER);
        }
        if (this.getURLBase() == null || this.getURLString().indexOf(58) > 0) {
            if (this.getURLString().indexOf(58) <= 0) {
                throw new RuntimeException("No protocol specified in URL '" + this.getURLString() + "'");
            }
            HttpsProtocolSupport.verifyProtocolSupport(this.getURLString().substring(0, this.getURLString().indexOf(58)));
        }
        return spec.startsWith("?") ? new URL(base + spec) : this.newCombinedURL(base, spec);
    }

    private URL newCombinedURL(URL base, String spec) throws MalformedURLException {
        if (base == null) {
            return new URL(this.getNormalizedURL(spec));
        }
        if (spec.startsWith("..")) {
            return new URL(this.getNormalizedURL(this.getURLDirectory(base) + spec));
        }
        return new URL(base, this.getNormalizedURL(spec));
    }

    private String getURLDirectory(URL base) {
        String url = base.toExternalForm();
        int i = url.lastIndexOf(47);
        return url.substring(0, i + 1);
    }

    private String getNormalizedURL(String url) {
        int questionIndex = url.indexOf(63);
        if (questionIndex < 0) {
            return this.getNormalizedPath(url);
        }
        return this.getNormalizedPath(url.substring(0, questionIndex)) + url.substring(questionIndex);
    }

    private String getNormalizedPath(String path) {
        if (path.lastIndexOf("//") > path.lastIndexOf("://") + 1) {
            return this.getNormalizedPath(this.stripDoubleSlashes(path));
        }
        if (path.indexOf("/..") > 0) {
            return this.getNormalizedPath(this.stripUpNavigation(path));
        }
        if (path.indexOf("/./") > 0) {
            return this.getNormalizedPath(this.stripInPlaceNavigation(path));
        }
        return path;
    }

    private String stripInPlaceNavigation(String url) {
        int i = url.lastIndexOf("/./");
        return url.substring(0, i + 1) + url.substring(i + 2);
    }

    private String stripUpNavigation(String url) {
        int i = url.indexOf("/..");
        int j = url.lastIndexOf("/", i - 1);
        return url.substring(0, j + 1) + url.substring(i + 3);
    }

    private String stripDoubleSlashes(String url) {
        int i = url.lastIndexOf("//");
        return url.substring(0, i) + url.substring(i + 1);
    }

    public String getTarget() {
        return this._requestTarget;
    }

    FrameSelector getSourceFrame() {
        return this._sourceFrame;
    }

    public String getMethod() {
        return this.method;
    }

    public String getQueryString() {
        return "";
    }

    public void setParameter(String name, String value) {
        this._parameterHolder.setParameter(name, value);
    }

    public void setParameter(String name, String[] values) {
        this._parameterHolder.setParameter(name, values);
    }

    public void setParameter(String parameterName, UploadFileSpec[] files) {
        if (!this.maySelectFile(parameterName)) {
            throw new IllegalNonFileParameterException(parameterName);
        }
        if (!this.isMimeEncoded()) {
            throw new MultipartFormRequiredException();
        }
        this._parameterHolder.setParameter(parameterName, files);
    }

    public void setImageButtonClickPosition(int x, int y) throws IllegalRequestParameterException {
        if (this._button == null) {
            throw new IllegalButtonPositionException();
        }
        this._parameterHolder.selectImageButtonPosition(this._button, x, y);
    }

    public boolean isFileParameter(String name) {
        return this._parameterHolder.isFileParameter(name);
    }

    public void selectFile(String parameterName, File file) {
        this.setParameter(parameterName, new UploadFileSpec[]{new UploadFileSpec(file)});
    }

    public void selectFile(String parameterName, File file, String contentType) {
        this.setParameter(parameterName, new UploadFileSpec[]{new UploadFileSpec(file, contentType)});
    }

    public void selectFile(String parameterName, String fileName, InputStream inputStream, String contentType) {
        this.setParameter(parameterName, new UploadFileSpec[]{new UploadFileSpec(fileName, inputStream, contentType)});
    }

    public String[] getRequestParameterNames() {
        final HashSet names = new HashSet();
        ParameterProcessor pp = new ParameterProcessor(){

            public void addParameter(String name, String value, String characterSet) throws IOException {
                names.add(name);
            }

            public void addFile(String parameterName, UploadFileSpec fileSpec) throws IOException {
                names.add(parameterName);
            }
        };
        try {
            this._parameterHolder.recordPredefinedParameters(pp);
            this._parameterHolder.recordParameters(pp);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return names.toArray(new String[names.size()]);
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        return values.length == 0 ? "" : values[0];
    }

    public String[] getParameterValues(String name) {
        return this._parameterHolder.getParameterValues(name);
    }

    public void removeParameter(String name) {
        this._parameterHolder.removeParameter(name);
    }

    public String toString() {
        return this.getMethod() + " request for (" + this.getURLBase() + ") " + this.getURLString();
    }

    protected WebRequest(String urlString) {
        this(null, urlString);
    }

    protected WebRequest(URL urlBase, String urlString) {
        this(urlBase, urlString, TOP_FRAME);
    }

    protected WebRequest(WebRequest baseRequest, String urlString, String target) throws MalformedURLException {
        this(baseRequest.getURL(), urlString, target);
    }

    protected WebRequest(URL urlBase, String urlString, String target) {
        this(urlBase, urlString, FrameSelector.TOP_FRAME, target);
    }

    protected WebRequest(WebResponse referer, Element sourceElement, URL urlBase, String urlString, String target) {
        this(urlBase, urlString, referer.getFrame(), target != null ? target : referer.getBaseTarget());
        this._sourceElement = sourceElement;
        this._referringPage = referer;
        this.setHeaderField(REFERER_HEADER_NAME, referer.getURL().toExternalForm());
    }

    protected WebRequest(URL urlBase, String urlString, FrameSelector frame, String target) {
        this(urlBase, urlString, frame, target, new UncheckedParameterHolder());
    }

    protected WebRequest(WebForm sourceForm, ParameterHolder parameterHolder, SubmitButton button, int x, int y) {
        this(sourceForm, parameterHolder);
        if (button != null && button.isValidImageButton()) {
            this._button = button;
            this._parameterHolder.selectImageButtonPosition(this._button, x, y);
        }
    }

    protected WebRequest(WebRequestSource requestSource, ParameterHolder parameterHolder) {
        this(requestSource.getBaseURL(), requestSource.getRelativePage(), requestSource.getFrame(), requestSource.getTarget(), parameterHolder);
        this._webRequestSource = requestSource;
        this._sourceElement = requestSource.getElement();
    }

    static ParameterHolder newParameterHolder(WebRequestSource requestSource) {
        if (HttpUnitOptions.getParameterValuesValidated()) {
            return requestSource;
        }
        return new UncheckedParameterHolder(requestSource);
    }

    private WebRequest(URL urlBase, String urlString, FrameSelector sourceFrame, String requestTarget, ParameterHolder parameterHolder) {
        this._urlBase = urlBase;
        this._sourceFrame = sourceFrame;
        this._requestTarget = requestTarget;
        this._urlString = urlString.toLowerCase().startsWith("http") ? WebRequest.escape(urlString) : urlString;
        this._parameterHolder = parameterHolder;
        this._characterSet = parameterHolder.getCharacterSet();
    }

    private static String escape(String urlString) {
        if (urlString.indexOf(32) < 0) {
            return urlString;
        }
        StringBuffer sb = new StringBuffer();
        int start = 0;
        while (true) {
            int index;
            if ((index = urlString.indexOf(32, start)) < 0) break;
            sb.append(urlString.substring(start, index)).append("%20");
            start = index + 1;
        }
        sb.append(urlString.substring(start));
        return sb.toString();
    }

    protected boolean maySelectFile(String parameterName) {
        return this.isFileParameter(parameterName);
    }

    protected boolean isMimeEncoded() {
        return false;
    }

    protected String getContentType() {
        return null;
    }

    protected final String getCharacterSet() {
        return this._characterSet;
    }

    protected void completeRequest(URLConnection connection) throws IOException {
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).setRequestMethod(this.getMethod());
        }
    }

    protected void writeMessageBody(OutputStream stream) throws IOException {
    }

    protected final URL getURLBase() {
        return this._urlBase;
    }

    protected String getURLString() {
        String queryString = this.getQueryString();
        if (queryString.length() == 0) {
            return this._urlString;
        }
        return this._urlString + "?" + queryString;
    }

    protected final ParameterHolder getParameterHolder() {
        return this._parameterHolder;
    }

    Hashtable getHeaderDictionary() {
        if (this._headers == null) {
            this._headers = new Hashtable();
            if (this.getContentType() != null) {
                this._headers.put("Content-Type", this.getContentType());
            }
        }
        return this._headers;
    }

    String getReferer() {
        return this._headers == null ? null : (String)this._headers.get(REFERER_HEADER_NAME);
    }

    ScriptingHandler getSourceScriptingHandler() {
        WebRequestSource wrs = this._webRequestSource;
        if (wrs != null) {
            return wrs.getScriptingHandler();
        }
        if (this._referringPage != null && this._sourceElement != null) {
            try {
                this._referringPage.getReceivedPage().getElement(this._sourceElement).getScriptingHandler();
            }
            catch (SAXException e) {
                return null;
            }
        }
        return null;
    }
}

