/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.dom;

import com.meterware.httpunit.ParsedHTML;
import com.meterware.httpunit.dom.HTMLCollectionImpl;
import com.meterware.httpunit.dom.NodeImpl;
import com.meterware.httpunit.dom.NodeListImpl;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLCollection;

class HTMLContainerDelegate {
    private NodeImpl.IteratorMask _iteratorMask = NodeImpl.SKIP_IFRAMES;

    HTMLContainerDelegate(NodeImpl.IteratorMask iteratorMask) {
        this._iteratorMask = iteratorMask;
    }

    HTMLCollection getLinks(NodeImpl rootNode) {
        ArrayList<Node> elements = new ArrayList<Node>();
        Iterator each = rootNode.preOrderIteratorAfterNode(this._iteratorMask);
        while (each.hasNext()) {
            Node node = (Node)each.next();
            if (node.getNodeType() != 1 || !ParsedHTML.isWebLink(node)) continue;
            elements.add(node);
        }
        return HTMLCollectionImpl.createHTMLCollectionImpl(new NodeListImpl(elements));
    }

    HTMLCollection getForms(NodeImpl rootNode) {
        ArrayList<Node> elements = new ArrayList<Node>();
        Iterator each = rootNode.preOrderIteratorAfterNode(this._iteratorMask);
        while (each.hasNext()) {
            Node node = (Node)each.next();
            if (node.getNodeType() != 1 || !"form".equalsIgnoreCase(((Element)node).getTagName())) continue;
            elements.add(node);
        }
        return HTMLCollectionImpl.createHTMLCollectionImpl(new NodeListImpl(elements));
    }

    HTMLCollection getAnchors(NodeImpl rootNode) {
        NodeList nodeList = rootNode.getElementsByTagName("A");
        ArrayList<Node> elements = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getAttributes().getNamedItem("name") == null) continue;
            elements.add(node);
        }
        return HTMLCollectionImpl.createHTMLCollectionImpl(new NodeListImpl(elements));
    }

    HTMLCollection getImages(NodeImpl rootNode) {
        ArrayList elements = new ArrayList();
        rootNode.appendElementsWithTags(new String[]{"img"}, elements);
        return HTMLCollectionImpl.createHTMLCollectionImpl(new NodeListImpl(elements));
    }

    HTMLCollection getApplets(NodeImpl rootNode) {
        ArrayList elements = new ArrayList();
        rootNode.appendElementsWithTags(new String[]{"applet"}, elements);
        return HTMLCollectionImpl.createHTMLCollectionImpl(new NodeListImpl(elements));
    }
}

