/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.dom;

import com.meterware.httpunit.dom.HTMLElementImpl;
import com.meterware.httpunit.protocol.ParameterProcessor;
import java.io.IOException;
import java.util.Iterator;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLFormElement;

public class HTMLControl
extends HTMLElementImpl {
    public boolean getDisabled() {
        return this.getBooleanAttribute("disabled");
    }

    public HTMLFormElement getForm() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && !"form".equalsIgnoreCase(parent.getNodeName()); parent = parent.getParentNode()) {
        }
        if (parent != null) {
            return (HTMLFormElement)parent;
        }
        Iterator here = this.preOrderIterator();
        while (here.hasNext()) {
            Object o = here.next();
            if (!(o instanceof HTMLFormElement)) continue;
            return this.getPreviousForm((HTMLFormElement)o);
        }
        return this.getLastFormInDocument();
    }

    private HTMLFormElement getPreviousForm(HTMLFormElement nextForm) {
        HTMLCollection forms = this.getHtmlDocument().getForms();
        for (int i = 0; i < forms.getLength(); ++i) {
            if (nextForm != forms.item(i)) continue;
            return i == 0 ? null : (HTMLFormElement)forms.item(i - 1);
        }
        return null;
    }

    private HTMLFormElement getLastFormInDocument() {
        HTMLCollection forms = this.getHtmlDocument().getForms();
        return forms.getLength() == 0 ? null : (HTMLFormElement)forms.item(forms.getLength() - 1);
    }

    public String getName() {
        return this.getAttributeWithNoDefault("name");
    }

    public boolean getReadOnly() {
        return this.getBooleanAttribute("readonly");
    }

    public int getTabIndex() {
        return this.getIntegerAttribute("tabindex");
    }

    public String getType() {
        return this.getAttributeWithDefault("type", "text");
    }

    public void setDisabled(boolean disabled) {
        this.setAttribute("disabled", disabled);
    }

    public void setName(String name) {
        this.setAttribute("name", name);
    }

    public void setReadOnly(boolean readOnly) {
        this.setAttribute("readonly", readOnly);
    }

    public void setTabIndex(int tabIndex) {
        this.setAttribute("tabindex", tabIndex);
    }

    public void reset() {
    }

    void addValues(ParameterProcessor processor, String characterSet) throws IOException {
    }

    public void silenceSubmitButton() {
    }
}

