/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.parsing;

import com.meterware.httpunit.parsing.HTMLParserFactory;
import com.meterware.httpunit.parsing.HTMLParserListener;
import java.net.URL;
import java.util.Enumeration;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLParseException;

class ErrorHandler
implements XMLErrorHandler {
    private URL _url = null;

    ErrorHandler(URL url) {
        this._url = url;
    }

    public void warning(String domain, String key, XMLParseException warningException) throws XNIException {
        if (HTMLParserFactory.isParserWarningsEnabled()) {
            System.out.println("At line " + warningException.getLineNumber() + ", column " + warningException.getColumnNumber() + ": " + warningException.getMessage());
        }
        Enumeration listeners = HTMLParserFactory.getHTMLParserListeners().elements();
        while (listeners.hasMoreElements()) {
            ((HTMLParserListener)listeners.nextElement()).warning(this._url, warningException.getMessage(), warningException.getLineNumber(), warningException.getColumnNumber());
        }
    }

    public void error(String domain, String key, XMLParseException errorException) throws XNIException {
        Enumeration listeners = HTMLParserFactory.getHTMLParserListeners().elements();
        while (listeners.hasMoreElements()) {
            ((HTMLParserListener)listeners.nextElement()).error(this._url, errorException.getMessage(), errorException.getLineNumber(), errorException.getColumnNumber());
        }
    }

    public void fatalError(String domain, String key, XMLParseException fatalError) throws XNIException {
        this.error(domain, key, fatalError);
        throw fatalError;
    }
}

