/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.protocol;

import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.protocol.MessageBody;
import com.meterware.httpunit.protocol.ParameterCollection;
import com.meterware.httpunit.protocol.URLEncodedString;
import java.io.IOException;
import java.io.OutputStream;

class URLEncodedMessageBody
extends MessageBody {
    URLEncodedMessageBody(String characterSet) {
        super(characterSet);
    }

    public String getContentType() {
        return "application/x-www-form-urlencoded" + (!HttpUnitOptions.isPostIncludesCharset() ? "" : "; charset=" + this.getCharacterSet());
    }

    public void writeTo(OutputStream outputStream, ParameterCollection parameters) throws IOException {
        outputStream.write(this.getParameterString(parameters).getBytes());
    }

    private String getParameterString(ParameterCollection parameters) {
        try {
            URLEncodedString encoder = new URLEncodedString();
            parameters.recordParameters(encoder);
            return encoder.getString();
        }
        catch (IOException e) {
            throw new RuntimeException("Programming error: " + e);
        }
    }
}

