/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.servletunit;

import com.meterware.servletunit.RequestDispatcherImpl;
import com.meterware.servletunit.WebApplication;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class ServletUnitServletContext
implements ServletContext {
    private PrintStream _logStream = System.out;
    public static final String DEFAULT_SERVER_INFO = "ServletUnit test framework";
    private static final Vector EMPTY_VECTOR = new Vector();
    private Hashtable _attributes = new Hashtable();
    private WebApplication _application;

    ServletUnitServletContext(WebApplication application) {
        this._application = application;
    }

    public ServletContext getContext(String A) {
        return null;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 4;
    }

    public String getMimeType(String filePath) {
        return URLConnection.getFileNameMap().getContentTypeFor(filePath);
    }

    public URL getResource(String path) {
        try {
            File resourceFile = this._application.getResourceFile(path);
            return resourceFile == null ? null : resourceFile.toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public InputStream getResourceAsStream(String path) {
        try {
            File resourceFile = this._application.getResourceFile(path);
            return resourceFile == null ? null : new FileInputStream(resourceFile);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        try {
            URL url = new URL("http", "localhost", this._application.getContextPath() + path);
            return new RequestDispatcherImpl(this._application, url);
        }
        catch (ServletException e) {
            return null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public RequestDispatcher getNamedDispatcher(String A) {
        return null;
    }

    public Servlet getServlet(String A) {
        return null;
    }

    public Enumeration getServlets() {
        return EMPTY_VECTOR.elements();
    }

    public Enumeration getServletNames() {
        return EMPTY_VECTOR.elements();
    }

    public void log(String message) {
        this._logStream.println(message);
    }

    public void log(Exception e, String message) {
        this.log(message, e);
    }

    public void log(String message, Throwable t) {
        this._logStream.print(message);
        this._logStream.print(":");
        if (t != null) {
            t.printStackTrace(this._logStream);
        }
    }

    public String getRealPath(String path) {
        return this._application.getResourceFile(path).getAbsolutePath();
    }

    public String getServerInfo() {
        return DEFAULT_SERVER_INFO;
    }

    public String getInitParameter(String name) {
        return (String)this.getContextParams().get(name);
    }

    public Enumeration getInitParameterNames() {
        return this.getContextParams().keys();
    }

    public Object getAttribute(String name) {
        return this._attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this._attributes.keys();
    }

    public void setAttribute(String name, Object attribute) {
        if (!this._attributes.containsKey(name)) {
            this._attributes.put(name, attribute);
            this._application.sendAttributeAdded(name, attribute);
        } else {
            Object oldValue = this._attributes.get(name);
            this._attributes.put(name, attribute);
            this._application.sendAttributeReplaced(name, oldValue);
        }
    }

    public void removeAttribute(String name) {
        Object oldValue = this._attributes.get(name);
        this._attributes.remove(name);
        this._application.sendAttributeRemoved(name, oldValue);
    }

    public Set getResourcePaths(String path) {
        return null;
    }

    public String getServletContextName() {
        return this._application.getDisplayName();
    }

    public String getContextPath() {
        return null;
    }

    void setInitParameter(String name, Object initParameter) {
        this.getContextParams().put(name, initParameter);
    }

    void removeInitParameter(String name) {
        this.getContextParams().remove(name);
    }

    private Hashtable getContextParams() {
        return this._application.getContextParameters();
    }

    public void setLogStream(PrintStream logStream) {
        this._logStream = logStream;
    }
}

