/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.cxutil;

import blackboard.persist.Id;
import blackboard.platform.contentsystem.data.ICSResourceLink;
import blackboard.platform.intl.BbResourceBundle;
import blackboard.platform.intl.BundleManagerFactory;
import blackboard.util.StringUtil;

public class CSResource {
    public static final String GENERIC_PARENT_TYPE_KEY = "cx.import.copy.link.component.name.course.item";
    private final Id _courseId;
    private final String _xythosId;
    private final String _parentTitle;
    private final String _parentTypeKey;
    private final String _attachedResourceName;
    private final CSStatus _status;
    private final ICSResourceLink.StorageType _storageType;
    private Id _parentId;

    protected CSResource(Id courseId, Id parentId, String parentTitle, String parentTypeKey, String xythosId, String attachedResourceName, CSStatus status, ICSResourceLink.StorageType storageType) {
        if (!Id.isValid((Id)courseId) || status == null) {
            throw new IllegalArgumentException("Invalid course id and status passed in to CSResource.");
        }
        this._courseId = courseId;
        this._parentId = parentId;
        this._xythosId = xythosId;
        this._parentTitle = parentTitle;
        this._parentTypeKey = parentTypeKey;
        this._storageType = storageType;
        this._attachedResourceName = attachedResourceName;
        this._status = status;
    }

    public String getStatusMessage(BbResourceBundle bundle) {
        String parentName;
        if (bundle == null) {
            bundle = BundleManagerFactory.getInstance().getBundle("content_exchange");
        }
        String messageKey = this._status.getEmbeddedItemStatusResourceKey();
        String csResourceId = this._xythosId;
        if (StringUtil.notEmpty((String)this._attachedResourceName)) {
            messageKey = this._status.getAttachedItemStatusResourceKey();
            csResourceId = this._attachedResourceName;
        }
        if (StringUtil.isEmpty((String)(parentName = this._parentTitle))) {
            parentName = Id.isValid((Id)this._parentId) ? this._parentId.toExternalString() : "";
        }
        String parentTypeName = bundle.getString(this._parentTypeKey);
        String message = bundle.getString(messageKey, new String[]{parentTypeName, parentName, csResourceId});
        return message;
    }

    public Id getCourseId() {
        return this._courseId;
    }

    public Id getParentId() {
        return this._parentId;
    }

    public String getXythosId() {
        return this._xythosId;
    }

    public ICSResourceLink.StorageType getStorageType() {
        return this._storageType;
    }

    public void setParentId(Id parentId) {
        this._parentId = parentId;
    }

    public static enum CSStatus {
        Succeeded("cx.import.copy.link.success.heading", "cx.import.copy.link.success.attached.item.report", "cx.import.copy.link.success.embedded.item.report"),
        FileNotFound("cx.import.copy.link.broken.file.not.exist.heading", "cx.import.copy.link.broken.file.not.exist.attached.item.report", "cx.import.copy.link.broken.file.not.exist.embedded.item.report"),
        InsufficientPermission("cx.import.copy.link.broken.invalid.permission.heading", "cx.import.copy.link.broken.invalid.permission.attached.item.report", "cx.import.copy.link.broken.invalid.permission.embedded.item.report"),
        OtherException("copy.link.broken.other.exceptions.heading", "cx.import.copy.link.broken.other.exceptions.attached.item.report", "cx.import.copy.link.broken.other.exceptions.embedded.item.report");

        private String _titleResourceKey;
        private String _attachedItemStatusResourceKey;
        private String _embeddedItemStatusResourceKey;

        private CSStatus(String titleResourceKey, String attachedItemStatusResourceKey, String embeddedItemStatusResourceKey) {
            this._titleResourceKey = titleResourceKey;
            this._attachedItemStatusResourceKey = attachedItemStatusResourceKey;
            this._embeddedItemStatusResourceKey = embeddedItemStatusResourceKey;
        }

        public String getTitleResourceKey() {
            return this._titleResourceKey;
        }

        public String getAttachedItemStatusResourceKey() {
            return this._attachedItemStatusResourceKey;
        }

        public String getEmbeddedItemStatusResourceKey() {
            return this._embeddedItemStatusResourceKey;
        }
    }
}

