/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.cxutil;

import blackboard.admin.cxutil.CSResource;
import blackboard.persist.Id;
import blackboard.platform.contentsystem.data.ICSResourceLink;
import blackboard.platform.log.LogService;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.StringUtil;
import java.util.HashMap;
import java.util.Map;

public class CSResultSet {
    private final Id _courseId;
    private final String _parentTitle;
    private final String _parentTypeKey;
    private final Map<CSResource.CSStatus, Map<String, CSResource>> _resultMap;
    private final ICSResourceLink.StorageType _storageType;
    private Id _parentId;
    private boolean _diskQuotaError = false;

    public CSResultSet(Id courseId, Id parentId, String parentTitle, String parentTypeKey) {
        this(courseId, parentId, parentTitle, parentTypeKey, ICSResourceLink.StorageType.PUBLIC);
    }

    public CSResultSet(Id courseId, Id parentId, String parentTitle, String parentTypeKey, ICSResourceLink.StorageType storageType) {
        if (!Id.isValid((Id)courseId)) {
            throw new IllegalArgumentException("Invalid course id passed in to CSResultSet.");
        }
        this._courseId = courseId;
        this._parentId = parentId;
        this._parentTitle = parentTitle;
        this._parentTypeKey = StringUtil.isEmpty((String)parentTypeKey) ? "cx.import.copy.link.component.name.course.item" : parentTypeKey;
        this._storageType = storageType == null ? ICSResourceLink.StorageType.PUBLIC : storageType;
        this._resultMap = new HashMap<CSResource.CSStatus, Map<String, CSResource>>();
    }

    public CSResource addCSResource(String xythosId, String attachedResourceName, CSResource.CSStatus status) {
        CSResource resource = null;
        if (StringUtil.notEmpty((String)xythosId) || StringUtil.notEmpty((String)attachedResourceName)) {
            resource = new CSResource(this._courseId, this._parentId, this._parentTitle, this._parentTypeKey, xythosId, attachedResourceName, status, this._storageType);
            Map<String, CSResource> resourceMap = this._resultMap.get((Object)status);
            if (resourceMap == null) {
                resourceMap = new HashMap<String, CSResource>();
                this._resultMap.put(status, resourceMap);
            }
            String key = StringUtil.notEmpty((String)xythosId) ? xythosId : attachedResourceName;
            resourceMap.put(key, resource);
        } else {
            LogServiceFactory.getInstance().log("Invalid xythos id and resource name passed in to add Course Files resource.", LogService.Verbosity.WARNING);
        }
        return resource;
    }

    public Map<CSResource.CSStatus, Map<String, CSResource>> getResultMap() {
        return this._resultMap;
    }

    public Map<String, CSResource> getCSResourceByStatus(CSResource.CSStatus status) {
        return this._resultMap.get((Object)status);
    }

    public void setParentId(Id parentId) {
        if (Id.isValid((Id)parentId)) {
            this._parentId = parentId;
            if (!this._resultMap.isEmpty()) {
                for (Map<String, CSResource> resourceMap : this._resultMap.values()) {
                    for (CSResource resource : resourceMap.values()) {
                        resource.setParentId(parentId);
                    }
                }
            }
        }
    }

    public boolean hasLinkStatusData() {
        return !this._resultMap.isEmpty();
    }

    public boolean wasDiskQuotaErrorThrown() {
        return this._diskQuotaError;
    }

    public void setDiskQuotaErrorThrown() {
        this._diskQuotaError = true;
    }
}

