/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.cxutil;

import blackboard.admin.cxutil.CSFileCopyHandlerFactory;
import blackboard.admin.cxutil.CSResource;
import blackboard.admin.cxutil.CSResourceStatusMap;
import blackboard.admin.cxutil.CSResultSet;
import blackboard.admin.cxutil.SyllabusContentCopier;
import blackboard.admin.manager.impl.TemporarySnapshotSessionManagerFactory;
import blackboard.base.BbList;
import blackboard.base.FormattedText;
import blackboard.data.BbObject;
import blackboard.data.ValidationException;
import blackboard.data.content.AbstractContentFile;
import blackboard.data.content.Content;
import blackboard.data.content.ContentFile;
import blackboard.data.content.ContentFolder;
import blackboard.data.content.CourseLinkController;
import blackboard.data.content.LessonPlan;
import blackboard.data.content.LessonPlanComponent;
import blackboard.data.content.Link;
import blackboard.data.course.Course;
import blackboard.data.navigation.CourseToc;
import blackboard.db.ConnectionManager;
import blackboard.db.DatabaseTransaction;
import blackboard.db.DbUtil;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.Container;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.content.ContentDbLoader;
import blackboard.persist.content.ContentDbPersister;
import blackboard.persist.content.ContentFileDbLoader;
import blackboard.persist.content.ContentFileDbPersister;
import blackboard.persist.content.impl.ContentDbMap;
import blackboard.persist.course.CourseDbLoader;
import blackboard.persist.impl.Bb5Util;
import blackboard.persist.impl.DbBbObjectMapUnmarshaller;
import blackboard.persist.impl.DbUnmarshaller;
import blackboard.persist.impl.ModificationQuery;
import blackboard.persist.impl.Query;
import blackboard.persist.impl.QueryLoader;
import blackboard.persist.impl.SelectQuery;
import blackboard.persist.impl.StoredProcedureQuery;
import blackboard.persist.impl.UnmarshallSelectQuery;
import blackboard.platform.content.event.ContentLifecycleEventManager;
import blackboard.platform.contentsystem.manager.DocumentManagerEx;
import blackboard.platform.contentsystem.service.ContentSystemServiceExFactory;
import blackboard.platform.coursecontent.CourseContentManagerFactory;
import blackboard.platform.coursemap.CourseMapManagerFactory;
import blackboard.platform.dataintegration.mapping.CourseCloneConfig;
import blackboard.platform.filesystem.FileSystemException;
import blackboard.platform.filesystem.FileSystemServiceFactory;
import blackboard.platform.filesystem.manager.CourseContentFileManager;
import blackboard.platform.intl.JsResource;
import blackboard.platform.log.LogServiceFactory;
import blackboard.platform.plugin.ContentHandler;
import blackboard.platform.plugin.ContentHandlerInfo;
import blackboard.platform.plugin.PlugInManagerFactory;
import blackboard.platform.proxytool.ContentBodyTextHelper;
import blackboard.platform.proxytool.ProxyToolManagerFactory;
import blackboard.platform.proxytool.ProxyToolUtil;
import blackboard.platform.proxytool.dao.ProxyTool;
import blackboard.util.FileUtil;
import blackboard.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class ContentCopier {
    private final Id _originalContentId;
    private final Id _destinationId;
    private final boolean _deleteAfterCopy;
    private final boolean _copyAlignments;
    private final boolean _createLink;
    private final CourseCloneConfig.CloneOptions _cloneOptions;
    private final String _sessionUuid;
    private final BbPersistenceManager _bbPM;
    private final Map<String, String> _oldToNewXythosIdMapping;
    private final CSResourceStatusMap _csLinkStatusMap;
    private boolean _hasLeftItemsLoaded = false;
    private String _notCopiedItems;
    private Map<Id, Id> _idContentMapping;
    private List<Content> _notCopiedContents;
    private List<Content> _linkCreatedContents;
    private Content _originalContent;
    private ContentFolder _destination;
    private Course _originalCourse;
    private Course _destinationCourse;

    public ContentCopier(Id originalContentId, Id destinationId, boolean deleteAfterCopy, boolean copyAlignments, boolean createLink, CourseCloneConfig.CloneOptions cloneOptions, BbPersistenceManager bbPM) {
        this._originalContentId = originalContentId;
        this._destinationId = destinationId;
        this._deleteAfterCopy = deleteAfterCopy;
        this._copyAlignments = copyAlignments;
        this._createLink = createLink;
        this._cloneOptions = cloneOptions;
        this._sessionUuid = TemporarySnapshotSessionManagerFactory.getInstance().createSnapshotSession();
        this._bbPM = bbPM;
        this._oldToNewXythosIdMapping = new HashMap<String, String>();
        this._csLinkStatusMap = new CSResourceStatusMap();
    }

    public void execute() throws Exception {
        ConnectionManager cm = ConnectionManager.getDefaultInstance();
        cm.performTransaction(new DatabaseTransaction("ContentCopier.execute"){

            public void run(Connection con) throws PersistenceException, ValidationException {
                try {
                    ContentCopier.this.verifyIds(con);
                    if (ContentCopier.this._deleteAfterCopy && ContentCopier.this._originalCourse.getId().equals((Object)ContentCopier.this._destinationCourse.getId())) {
                        int position = ContentCopier.this.getTargetPosition(con);
                        ContentCopier.this._originalContent.setParentId(ContentCopier.this._destinationId);
                        ContentCopier.this._originalContent.setPosition(position);
                        ContentLifecycleEventManager.setEventContext((BbObject)ContentCopier.this._originalContent, (ContentLifecycleEventManager.EventContext)ContentLifecycleEventManager.EventContext.ContentMove);
                        ContentDbPersister.Default.getInstance().persist(ContentCopier.this._originalContent, con);
                    } else {
                        ContentCopier.this.doDatabaseCopy(con);
                        ContentCopier.this.retrieveIdMappings(con);
                        ContentCopier.this.copyAssociatedCSAndLocalFiles(con);
                        ContentCopier.this.createCourseLinksToNotCopiedItems(con);
                        ContentCopier.this.doPostCopyProxyServerNotification(false, con);
                        ContentCopier.this.doPostCopyCleanup(con);
                        ContentCopier.this.createNotificationItems(con);
                    }
                    CourseMapManagerFactory.getInstance().invalidateCache(ContentCopier.this._destination.getCourseId());
                    TemporarySnapshotSessionManagerFactory.getInstance().deleteBySessionId(ContentCopier.this._sessionUuid);
                }
                catch (Exception e) {
                    throw new PersistenceException((Throwable)e);
                }
            }
        });
    }

    private void createNotificationItems(Connection con) throws Exception {
        Collection<Id> destIdContentColl = this._idContentMapping.values();
        for (Id destIdContent : destIdContentColl) {
            try {
                Content destinationContentObj = ContentDbLoader.Default.getInstance().loadById(destIdContent, con);
                ContentLifecycleEventManager.EventContext eventContext = this._deleteAfterCopy ? ContentLifecycleEventManager.EventContext.ContentMove : ContentLifecycleEventManager.EventContext.ContentCopy;
                ContentLifecycleEventManager.setEventContext((BbObject)destinationContentObj, (ContentLifecycleEventManager.EventContext)eventContext);
                ((ContentLifecycleEventManager)ContentLifecycleEventManager.Factory.getInstance()).fireAfterPersist(null, destinationContentObj);
            }
            catch (Exception e) {
                LogServiceFactory.getInstance().logError("Error generating notifications for content item after content copy operation. Id: " + destIdContent.toString(), (Throwable)e);
            }
        }
    }

    private void copyAssociatedCSAndLocalFiles(Connection con) throws Exception {
        Id destIdContent;
        boolean isCopyBetweenDifferentCourse = this.isCopyBetweenDifferentCourses();
        DocumentManagerEx docMgrEx = ContentSystemServiceExFactory.getInstance().getDocumentManagerEx();
        String sourceCourseHomeDir = docMgrEx.getHomeDirectory(this._originalCourse);
        String destCourseHomeDir = docMgrEx.findOrCreateCourseHomeDirectory(this._destinationCourse).getLocation();
        for (Id sourceIdContent : this._idContentMapping.keySet()) {
            destIdContent = this._idContentMapping.get(sourceIdContent);
            Content destinationContentObj = ContentDbLoader.Default.getInstance().loadById(destIdContent, con);
            if (isCopyBetweenDifferentCourse) {
                this.processReferencedFilesForCopyBetweenDifferentCourse(sourceIdContent, sourceCourseHomeDir, destCourseHomeDir, destinationContentObj);
                this.processEmbeddedFilesForCopyBetweenDifferentCourse(sourceCourseHomeDir, destCourseHomeDir, destinationContentObj, con);
                this.processAttachmentsForCopyBetweenDifferentCourse(sourceCourseHomeDir, destCourseHomeDir, destinationContentObj, con);
                if (StringUtil.isEqual((String)ContentHandlerInfo.LessonPlan.getHandle(), (String)destinationContentObj.getContentHandler())) {
                    LessonPlan destinationLessonPlan = (LessonPlan)destinationContentObj;
                    this.processEmbeddedFilesInLessonPlanComponent(sourceCourseHomeDir, destCourseHomeDir, destinationLessonPlan, con);
                }
            }
            this.copyFilesOnLocalDisk(sourceIdContent, destIdContent);
            if (!StringUtil.isEqual((String)ContentHandlerInfo.Syllabus.getHandle(), (String)destinationContentObj.getContentHandler())) continue;
            SyllabusContentCopier syllabusCopier = new SyllabusContentCopier(this._originalCourse, this._destinationCourse, this._destination, this._oldToNewXythosIdMapping, this._csLinkStatusMap, CourseCloneConfig.CloneOptions.LINKS != this._cloneOptions);
            syllabusCopier.copyEmbeddedLinks(sourceCourseHomeDir, destCourseHomeDir, destinationContentObj);
        }
        if (isCopyBetweenDifferentCourse) {
            this.registerCSLinksForCopyBetweenDifferentCourse();
        } else {
            for (Id sourceIdContent : this._idContentMapping.keySet()) {
                destIdContent = this._idContentMapping.get(sourceIdContent);
                this.registerCSLinksForCopyInSameCourse(destIdContent, con);
            }
        }
    }

    private boolean isCopyBetweenDifferentCourses() {
        return !this._originalCourse.getId().equals((Object)this._destinationCourse.getId());
    }

    private void registerCSLinksForCopyInSameCourse(Id destIdContent, Connection con) throws KeyNotFoundException, PersistenceException {
        DocumentManagerEx docMgrEx = ContentSystemServiceExFactory.getInstance().getDocumentManagerEx();
        Content destinationContentObj = ContentDbLoader.Default.getInstance().loadById(destIdContent, con);
        BbList cFileList = ContentFileDbLoader.Default.getInstance().loadByContentId(destIdContent, con);
        for (ContentFile cfile : cFileList) {
            if (!cfile.getStorageType().getFieldName().equals(AbstractContentFile.StorageType.CS.getFieldName())) continue;
            docMgrEx.registerResourceLink(this._destinationCourse.getId(), cfile.getId(), cfile.getName());
        }
        docMgrEx.registerEmbeddedResourceLinks(this._destinationCourse.getId(), destIdContent, destinationContentObj.getBody());
    }

    private void registerCSLinksForCopyBetweenDifferentCourse() {
        CSResourceStatusMap.registerLinks(this._csLinkStatusMap.getCsLinkStatusList(CSResource.CSStatus.Succeeded));
        CSResourceStatusMap.registerLinks(this._csLinkStatusMap.getCsLinkStatusList(CSResource.CSStatus.InsufficientPermission));
    }

    private void processEmbeddedFilesInLessonPlanComponent(String sourceCourseHomeDir, String destCourseHomeDir, LessonPlan destinationLessonPlan, Connection con) throws Exception, ValidationException, PersistenceException {
        boolean lessonPlanNeedsUpdate = false;
        List lessonPlanComponents = destinationLessonPlan.getComponents();
        for (LessonPlanComponent lessonPlanComponent : lessonPlanComponents) {
            boolean replacedEmbeddedLinks = this.copyEmbeddedFilesInLessonPlanComponent(lessonPlanComponent, destinationLessonPlan, sourceCourseHomeDir, destCourseHomeDir, CourseCloneConfig.CloneOptions.LINKS != this._cloneOptions);
            if (!replacedEmbeddedLinks || lessonPlanNeedsUpdate) continue;
            lessonPlanNeedsUpdate = true;
        }
        if (lessonPlanNeedsUpdate) {
            destinationLessonPlan.setComponents(lessonPlanComponents);
            ContentDbPersister.Default.getInstance().persist((Content)destinationLessonPlan, con);
        }
    }

    private void processAttachmentsForCopyBetweenDifferentCourse(String sourceCourseHomeDir, String destCourseHomeDir, Content destinationContentObj, Connection con) throws KeyNotFoundException, PersistenceException, Exception, ValidationException {
        BbList cFileList = ContentFileDbLoader.Default.getInstance().loadByContentId(destinationContentObj.getId(), con);
        for (ContentFile cfile : cFileList) {
            if (!cfile.getStorageType().getFieldName().equals(AbstractContentFile.StorageType.CS.getFieldName())) continue;
            String xythosIdPrefixedName = cfile.getName();
            String linkName = cfile.getLinkName();
            CSResultSet resultSet = new CSResultSet(this._destinationCourse.getId(), cfile.getId(), destinationContentObj.getTitle(), "cx.import.copy.link.component.name.content.item");
            String newXythosIdPrefixedName = null;
            newXythosIdPrefixedName = CourseCloneConfig.CloneOptions.LINKS != this._cloneOptions ? CSFileCopyHandlerFactory.getInstance().copyCSFileByXythosIdUrl(xythosIdPrefixedName, sourceCourseHomeDir, destCourseHomeDir, this._destinationCourse, this._originalCourse, true, this._oldToNewXythosIdMapping, linkName, resultSet, true, false, null) : xythosIdPrefixedName;
            if (StringUtil.notEmpty((String)newXythosIdPrefixedName)) {
                cfile.setName(newXythosIdPrefixedName);
                ContentFileDbPersister.Default.getInstance().persist(cfile, con);
            }
            this._csLinkStatusMap.addCsLinkStatus(resultSet);
        }
    }

    private void processEmbeddedFilesForCopyBetweenDifferentCourse(String sourceCourseHomeDir, String destCourseHomeDir, Content destinationContentObj, Connection con) throws Exception, ValidationException, PersistenceException {
        FormattedText formattedVtbeText = destinationContentObj.getBody();
        String originalVtbeText = formattedVtbeText.getText();
        if (StringUtil.notEmpty((String)originalVtbeText)) {
            String newVtbeText = originalVtbeText;
            CSResultSet resultSet = new CSResultSet(this._destinationCourse.getId(), destinationContentObj.getId(), destinationContentObj.getTitle(), "cx.import.copy.link.component.name.content.item");
            newVtbeText = CSFileCopyHandlerFactory.getInstance().parseVTBEText(newVtbeText, sourceCourseHomeDir, destCourseHomeDir, this._destinationCourse, this._originalCourse, CourseCloneConfig.CloneOptions.LINKS != this._cloneOptions, this._oldToNewXythosIdMapping, resultSet, true, false, null);
            this._csLinkStatusMap.addCsLinkStatus(resultSet);
            if (!StringUtil.isEqual((String)originalVtbeText, (String)newVtbeText)) {
                destinationContentObj.setBody(new FormattedText(newVtbeText, destinationContentObj.getBody().getType()));
                ContentDbPersister.Default.getInstance().persist(destinationContentObj, con);
            }
        }
    }

    private void processReferencedFilesForCopyBetweenDifferentCourse(Id contentId, String sourceCourseHomeDir, String destCourseHomeDir, Content destinationContentObj) throws KeyNotFoundException, PersistenceException, Exception, ValidationException {
        if (CourseCloneConfig.CloneOptions.LINKS == this._cloneOptions) {
            return;
        }
        CSResultSet resultSet = new CSResultSet(this._destinationCourse.getId(), destinationContentObj.getId(), destinationContentObj.getTitle(), "cx.import.copy.link.component.name.content.item");
        CSFileCopyHandlerFactory.getInstance().copyReferencedLinks(this._cloneOptions, contentId, sourceCourseHomeDir, destCourseHomeDir, this._destinationCourse, this._originalCourse, this._oldToNewXythosIdMapping, resultSet);
        this._csLinkStatusMap.addCsLinkStatus(resultSet);
    }

    private boolean copyEmbeddedFilesInLessonPlanComponent(LessonPlanComponent lessonPlanComponent, LessonPlan lessonPlan, String sourceCourseHomeDir, String destCourseHomeDir, boolean copyFiles) throws Exception {
        String originalVtbeText;
        boolean replacedEmbeddedLinks = false;
        if (lessonPlanComponent.hasEmbeddedLinks() && StringUtil.notEmpty((String)(originalVtbeText = lessonPlanComponent.getValue()))) {
            String newVtbeText = originalVtbeText;
            CSResultSet resultSet = new CSResultSet(this._destinationCourse.getId(), lessonPlan.getId(), lessonPlan.getTitle(), "cx.import.copy.link.component.name.content.item");
            newVtbeText = CSFileCopyHandlerFactory.getInstance().parseVTBEText(newVtbeText, sourceCourseHomeDir, destCourseHomeDir, this._destinationCourse, this._originalCourse, copyFiles, this._oldToNewXythosIdMapping, resultSet, true, false, null);
            this._csLinkStatusMap.addCsLinkStatus(resultSet);
            if (!StringUtil.isEqual((String)originalVtbeText, (String)newVtbeText)) {
                lessonPlanComponent.setValue(newVtbeText);
                replacedEmbeddedLinks = true;
            }
        }
        return replacedEmbeddedLinks;
    }

    private int getTargetPosition(Connection con) throws PersistenceException {
        int targetPosition = 0;
        try {
            LoadMaxPositionQuery loadMaxPositionQuery = new LoadMaxPositionQuery(this._destination.getId());
            this._bbPM.runDbQuery((Query)loadMaxPositionQuery, con);
            BbList maxList = new QueryLoader().getResults((SelectQuery)loadMaxPositionQuery);
            Integer maxPosition = (Integer)maxList.get(0);
            return maxPosition + 1;
        }
        catch (KeyNotFoundException knfe) {
            targetPosition = 0;
            return targetPosition;
        }
    }

    public Id getNewContentId() {
        return this._idContentMapping.get(this._originalContentId);
    }

    public boolean didAllItemsCopy() {
        return StringUtil.isEmpty((String)this._notCopiedItems);
    }

    public List<Content> getLinkCreatedItems() {
        return this._linkCreatedContents;
    }

    public List<Content> getNotCopiedItems() throws PersistenceException {
        if (!this._hasLeftItemsLoaded) {
            this._notCopiedContents = new ArrayList<Content>();
            if (StringUtil.notEmpty((String)this._notCopiedItems)) {
                StringTokenizer st = new StringTokenizer(this._notCopiedItems);
                while (st.hasMoreElements()) {
                    String idString = st.nextToken();
                    Id id = Id.generateId((DataType)Content.DATA_TYPE, (String)idString);
                    Content content = ContentDbLoader.Default.getInstance().loadById(id);
                    this._notCopiedContents.add(content);
                }
            }
            this._hasLeftItemsLoaded = true;
        }
        return this._notCopiedContents;
    }

    private void verifyIds(Connection con) throws KeyNotFoundException, PersistenceException, ValidationException {
        if (this._destination == null) {
            Content tempDest = ContentDbLoader.Default.getInstance().loadById(this._destinationId, con);
            if (tempDest instanceof ContentFolder) {
                this._destination = (ContentFolder)tempDest;
            } else {
                throw new ValidationException("Destination Id does not correspond to a Folder or Lesson.");
            }
        }
        if (this._originalContent == null) {
            this._originalContent = ContentDbLoader.Default.getInstance().loadById(this._originalContentId, con);
        }
        if (!this._destination.acceptsType(this._originalContent.getContentHandler())) {
            throw new ValidationException("Destination can not accept content of type " + this._originalContent.getContentHandler() + ".");
        }
        this._destinationCourse = CourseDbLoader.Default.getInstance().loadById(this._destination.getCourseId(), con);
        this._originalCourse = CourseDbLoader.Default.getInstance().loadById(this._originalContent.getCourseId(), con);
    }

    private void doDatabaseCopy(Connection con) throws PersistenceException {
        LoadDescendantsNeedingUpdateQuery updateContentVersionsQuery = new LoadDescendantsNeedingUpdateQuery(this._originalContentId);
        this._bbPM.runDbQuery((Query)updateContentVersionsQuery, con);
        CopyContentQuery ccQuery = new CopyContentQuery(this);
        this._bbPM.runDbQuery((Query)ccQuery, con);
        this._notCopiedItems = ccQuery.getNotCopiedList();
    }

    private void retrieveIdMappings(Connection con) throws PersistenceException {
        this._idContentMapping = new HashMap<Id, Id>();
        LoadIdMappingQuery idMappingQuery = new LoadIdMappingQuery(this._sessionUuid);
        this._bbPM.runDbQuery((Query)idMappingQuery, con);
        this._idContentMapping = idMappingQuery.getOldToNewIdContentMap();
        idMappingQuery.getOldToNewIdFileMap();
        RemoveMappingsQuery removeQuery = new RemoveMappingsQuery(this._sessionUuid);
        this._bbPM.runDbQuery((Query)removeQuery, con);
    }

    private void createCourseLinksToNotCopiedItems(Connection con) throws PersistenceException {
        if (!this._createLink) {
            return;
        }
        try {
            this._linkCreatedContents = new ArrayList<Content>();
            for (Content content : this.getNotCopiedItems()) {
                CourseLinkController linkUtil = new CourseLinkController();
                linkUtil.setIsContent(true);
                linkUtil.setIsAdd(true);
                linkUtil.setParentId(this._idContentMapping.get(content.getParentId()));
                linkUtil.setCourseId(content.getCourseId());
                linkUtil.setCourseLinkTitle(content.getTitle());
                linkUtil.setReferredToId(content.getId());
                linkUtil.setReferredToType(Link.ReferredToType.CONTENT);
                linkUtil.setIsAvailable(true);
                Id parentId = content.getParentId();
                String location = "/" + JsResource.encodeHTML((String)content.getTitle());
                try {
                    while (null != parentId && Id.UNSET_ID != parentId) {
                        Content parent = ContentDbLoader.Default.getInstance().loadById(parentId);
                        location = "/" + JsResource.encodeHTML((String)parent.getTitle()) + location;
                        parentId = parent.getParentId();
                    }
                    linkUtil.setLinkTitle(location);
                    linkUtil.setPosition(content.getPosition());
                    linkUtil.persistCourseLink(con);
                    this._linkCreatedContents.add(content);
                }
                catch (Exception e) {
                    LogServiceFactory.getInstance().logError("Cannot create link for " + content.getTitle() + " under " + this._destination.getTitle(), (Throwable)e);
                }
            }
        }
        catch (PersistenceException e) {
            LogServiceFactory.getInstance().logError("Not able to get content Ids to create links", (Throwable)e);
            throw e;
        }
        for (Content content : this._linkCreatedContents) {
            this._notCopiedContents.remove(content);
        }
    }

    private void copyFilesOnLocalDisk(Id sourceIdContent, Id destinationIdContent) throws FileSystemException, IOException {
        CourseContentFileManager cMgr = (CourseContentFileManager)FileSystemServiceFactory.getInstance().getFileManager(Content.DATA_TYPE);
        File origDir = cMgr.getRootDirectory(this._originalCourse, sourceIdContent);
        File newDir = cMgr.getRootDirectory(this._destinationCourse, destinationIdContent);
        FileUtil.copyDirectory((File)origDir, (File)newDir);
    }

    private void doPostCopyProxyServerNotification(boolean sendDelete, Connection con) throws PersistenceException {
        boolean res = true;
        StringBuilder failedServers = new StringBuilder();
        for (Id id : this._idContentMapping.keySet()) {
            Id ptId;
            Content c = ContentDbLoader.Default.getInstance().loadById(id, con);
            ContentHandler ch = PlugInManagerFactory.getInstance().getContentHandler(c.getContentHandler());
            if (ch == null || (ptId = ch.getProxyToolId()).equals((Object)Id.UNSET_ID)) continue;
            ProxyTool proxyTool = ProxyToolManagerFactory.getInstance().loadToolById(ptId);
            boolean result = true;
            FormattedText body = c.getBody();
            ContentBodyTextHelper cbth = new ContentBodyTextHelper(body == null ? "" : body.getText());
            result = sendDelete ? ProxyToolUtil.getInstance().sendContentDeleted(proxyTool, ch.getHandle(), ch.getId(), id, this._originalCourse.getId(), cbth.getExtId()) : ProxyToolUtil.getInstance().sendContentCopied(proxyTool, ch.getHandle(), ch.getId(), id, this._originalCourse.getId(), this._idContentMapping.get(id), this._destinationCourse.getId(), cbth.getExtId());
            if (result) continue;
            failedServers.append(" " + proxyTool.getBaseurl());
            res = false;
        }
        if (!res) {
            LogServiceFactory.getInstance().logError("Failed to notify proxy tool server (" + failedServers + " ) of content " + (sendDelete ? "deletion" : "copy"));
        }
    }

    private void doPostCopyCleanup(Connection con) throws PersistenceException, FileSystemException {
        if (this._deleteAfterCopy) {
            this.doPostCopyProxyServerNotification(true, con);
            LoadDescendantIdsQuery descendantsIdsQuery = new LoadDescendantIdsQuery(this._originalContentId);
            this._bbPM.runDbQuery((Query)descendantsIdsQuery, con);
            BbList descendantsIdsIds = new QueryLoader().getResults((SelectQuery)descendantsIdsQuery);
            ArrayList<Id> notCopiedListIds = new ArrayList<Id>();
            if (StringUtil.notEmpty((String)this._notCopiedItems)) {
                StringTokenizer st = new StringTokenizer(this._notCopiedItems);
                while (st.hasMoreElements()) {
                    String idString = st.nextToken();
                    Id id = Id.generateId((DataType)Content.DATA_TYPE, (String)idString);
                    if (!descendantsIdsIds.contains(id)) continue;
                    notCopiedListIds.add(id);
                }
                this.deleteCopiedContent((List<Id>)descendantsIdsIds, notCopiedListIds, con);
            } else {
                ContentDbPersister.Default.getInstance().deleteById(this._originalContentId, con);
                for (Id idToDelete : notCopiedListIds) {
                    if (notCopiedListIds.contains(idToDelete)) continue;
                    ContentDbPersister.Default.getInstance().deleteById(idToDelete, con);
                }
            }
            CourseContentFileManager cMgr = (CourseContentFileManager)FileSystemServiceFactory.getInstance().getFileManager(Content.DATA_TYPE);
            for (Id idToDelete : descendantsIdsIds) {
                File dirToDelete;
                if (notCopiedListIds.contains(idToDelete) || !(dirToDelete = cMgr.getRootDirectory(this._originalCourse, idToDelete)).exists()) continue;
                FileUtil.delete((File)dirToDelete);
            }
        }
    }

    private void deleteCopiedContent(List<Id> allDescendantIds, List<Id> notCopiedListIds, Connection con) throws PersistenceException {
        Content contentItem;
        ArrayList<Id> folderContentFolderIds = new ArrayList<Id>();
        ArrayList<Id> folderContentIds = new ArrayList<Id>();
        for (Id id : allDescendantIds) {
            contentItem = ContentDbLoader.Default.getInstance().loadById(id, con);
            if (contentItem.getIsFolder()) {
                folderContentFolderIds.add(contentItem.getId());
                folderContentIds.add(contentItem.getId());
                continue;
            }
            folderContentIds.add(contentItem.getId());
        }
        for (Id descendantId : allDescendantIds) {
            if (notCopiedListIds.contains(descendantId) || folderContentFolderIds.contains(descendantId)) continue;
            ContentDbPersister.Default.getInstance().deleteById(descendantId, con);
            folderContentIds.remove(descendantId);
        }
        for (Id fId : folderContentIds) {
            contentItem = ContentDbLoader.Default.getInstance().loadById(fId, con);
            if (!folderContentFolderIds.contains(contentItem.getParentId())) continue;
            folderContentFolderIds.remove(contentItem.getParentId());
        }
        for (Id id : folderContentFolderIds) {
            ContentDbPersister.Default.getInstance().deleteById(id, con);
        }
    }

    private static class LoadMaxPositionQuery
    extends SelectQuery {
        Id _destinationParentId = Id.UNSET_ID;

        public LoadMaxPositionQuery(Id destinationParentId) {
            this._destinationParentId = destinationParentId;
        }

        protected Statement prepareStatement(Connection con) throws KeyNotFoundException, SQLException {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT count(pk1) childrenCount, max(position) maxPosition");
            sql.append(" FROM course_contents");
            sql.append(" WHERE parent_pk1 = ? ");
            PreparedStatement stmt = con.prepareStatement(sql.toString());
            Bb5Util.setId((PreparedStatement)stmt, (int)1, (Id)this._destinationParentId);
            return stmt;
        }

        protected void processRow(ResultSet rst) throws SQLException {
            int position = rst.getInt("maxPosition");
            int count = rst.getInt("childrenCount");
            if (count == 0) {
                position = -1;
            } else if (count != 0 && count != position + 1) {
                try {
                    position = CourseContentManagerFactory.getInstance().correctChildrenPositions(this._destinationParentId);
                }
                catch (PersistenceException pe) {
                    // empty catch block
                }
            }
            this.addResult(position);
        }
    }

    private static class LoadDescendantsNeedingUpdateQuery
    extends UnmarshallSelectQuery {
        Id _id = Id.UNSET_ID;

        public LoadDescendantsNeedingUpdateQuery(Id id) {
            this._id = id;
        }

        protected DbUnmarshaller createUnmarshaller() {
            DbBbObjectMapUnmarshaller um = new DbBbObjectMapUnmarshaller(ContentDbMap.MAP, "cc");
            return um;
        }

        protected Statement prepareStatement(Connection con) throws KeyNotFoundException, SQLException {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT " + ContentDbMap.MAP.getSelectColumnListSql("cc") + ", xcc.distance, cc.position position_1");
            sql.append(" FROM " + ContentDbMap.MAP.getTableName() + " cc,");
            sql.append("      " + ContentDbMap.MAP.getTableName() + " cc2,");
            sql.append("      x_course_contents xcc ");
            sql.append(" WHERE cc2.pk1 = ?  AND cc.DATA_VERSION < ?");
            sql.append("       AND xcc.ancestor_pk1 = cc2.pk1");
            sql.append("       AND xcc.descendant_pk1 = cc.pk1");
            sql.append(" ");
            sql.append("UNION ALL");
            sql.append(" ");
            sql.append("SELECT " + ContentDbMap.MAP.getSelectColumnListSql("cc") + ", 0, cc.position");
            sql.append(" FROM " + ContentDbMap.MAP.getTableName() + " cc");
            sql.append(" WHERE cc.pk1 = ? and cc.DATA_VERSION < ?");
            sql.append(" ORDER BY distance, position_1");
            this._id.assertIsSet();
            PreparedStatement stmt = con.prepareStatement(sql.toString());
            Bb5Util.setId((PreparedStatement)stmt, (int)1, (Id)this._id);
            DbUtil.setInteger((PreparedStatement)stmt, (int)2, (int)3);
            Bb5Util.setId((PreparedStatement)stmt, (int)3, (Id)this._id);
            DbUtil.setInteger((PreparedStatement)stmt, (int)4, (int)3);
            return stmt;
        }
    }

    private static class LoadDescendantIdsQuery
    extends SelectQuery {
        Id _id = Id.UNSET_ID;

        public LoadDescendantIdsQuery(Id id) {
            this._id = id;
        }

        protected Statement prepareStatement(Connection con) throws KeyNotFoundException, SQLException {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT cc.pk1 pk1 ");
            sql.append(" FROM course_contents cc,");
            sql.append("      course_contents cc2,");
            sql.append("      x_course_contents xcc ");
            sql.append(" WHERE cc2.pk1 = ?");
            sql.append("       AND xcc.ancestor_pk1 = cc2.pk1");
            sql.append("       AND xcc.descendant_pk1 = cc.pk1");
            sql.append(" ORDER BY xcc.distance, cc.position");
            this._id.assertIsSet();
            PreparedStatement stmt = con.prepareStatement(sql.toString());
            Bb5Util.setId((PreparedStatement)stmt, (int)1, (Id)this._id);
            return stmt;
        }

        protected void processRow(ResultSet rst) throws SQLException {
            this.addResult(Bb5Util.unmarshallId((ResultSet)rst, (String)"pk1", (DataType)Content.DATA_TYPE, (Container)this.getContainer()));
        }
    }

    private static class RemoveMappingsQuery
    extends ModificationQuery {
        String _sessionGuid;

        public RemoveMappingsQuery(String sessionGuid) {
            this._sessionGuid = sessionGuid;
        }

        protected Statement prepareStatement(Connection con) throws SQLException {
            PreparedStatement stmt = con.prepareStatement("delete from tmp_ccc_key_mappings where session_guid=?");
            DbUtil.setString((PreparedStatement)stmt, (int)1, (String)this._sessionGuid);
            return stmt;
        }
    }

    private static class LoadIdMappingQuery
    extends SelectQuery {
        String _sessionGuid;
        Map<String, Map<Id, Id>> _newToOldMapOfMaps = new HashMap<String, Map<Id, Id>>();
        Map<String, Map<Id, Id>> _oldToNewMapOfMaps = new HashMap<String, Map<Id, Id>>();

        public LoadIdMappingQuery(String sessionGuid) {
            this._sessionGuid = sessionGuid;
        }

        public Map<Id, Id> getOldToNewIdContentMap() {
            return this.getOldToNewMap("course_contents");
        }

        public Map<Id, Id> getOldToNewIdFileMap() {
            return this.getOldToNewMap("files");
        }

        protected Statement prepareStatement(Connection con) throws SQLException {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT old_pk1,new_pk1,tabname ");
            sql.append("FROM   tmp_ccc_key_mappings ");
            sql.append("WHERE  session_guid = ? ");
            PreparedStatement stmt = con.prepareStatement(sql.toString());
            DbUtil.setString((PreparedStatement)stmt, (int)1, (String)this._sessionGuid);
            return stmt;
        }

        protected void processRow(ResultSet rst) throws SQLException {
            String tableName = DbUtil.getString((ResultSet)rst, (String)"tabname").toLowerCase();
            DataType dataType = DataType.NULL_DATA_TYPE;
            if (tableName.equalsIgnoreCase("course_contents")) {
                dataType = Content.DATA_TYPE;
            } else if (tableName.equalsIgnoreCase("course_toc")) {
                dataType = CourseToc.DATA_TYPE;
            } else if (tableName.equalsIgnoreCase("link")) {
                dataType = Link.DATA_TYPE;
            } else if (tableName.equalsIgnoreCase("files")) {
                dataType = ContentFile.DATA_TYPE;
            }
            Id oldId = Bb5Util.unmarshallId((ResultSet)rst, (String)"old_pk1", (DataType)dataType, (Container)this.getContainer());
            Id newId = Bb5Util.unmarshallId((ResultSet)rst, (String)"new_pk1", (DataType)dataType, (Container)this.getContainer());
            Map<Id, Id> oldToNew = this.getOldToNewMap(tableName);
            Map<Id, Id> newToOld = this.getNewToOldMap(tableName);
            oldToNew.put(oldId, newId);
            newToOld.put(newId, oldId);
        }

        private Map<Id, Id> getOldToNewMap(String tableName) {
            Map<Id, Id> tmp = this._oldToNewMapOfMaps.get(tableName);
            if (tmp == null) {
                tmp = new HashMap<Id, Id>();
                this._oldToNewMapOfMaps.put(tableName, tmp);
            }
            return tmp;
        }

        private Map<Id, Id> getNewToOldMap(String tableName) {
            Map<Id, Id> tmp = this._newToOldMapOfMaps.get(tableName);
            if (tmp == null) {
                tmp = new HashMap<Id, Id>();
                this._newToOldMapOfMaps.put(tableName, tmp);
            }
            return tmp;
        }
    }

    private static class CopyContentQuery
    extends StoredProcedureQuery {
        private final ContentCopier _contentCopier;
        private String _outputList;

        public CopyContentQuery(ContentCopier contentCopier) {
            super("course_contents_copy");
            this._contentCopier = contentCopier;
            this.addInputParameter("src_crsmain_pk1");
            this.addInputParameter("src_cc_pk1");
            this.addInputParameter("dst_crsmain_pk1");
            this.addInputParameter("dst_cc_pk1");
            this.addInputParameter("update_flag");
            this.addInputParameter("copy_alignments_flag");
            this.addInputParameter("v_session_guid");
            this.addOutputParameter("output_list");
        }

        protected void marshallParams(CallableStatement stmt) throws SQLException {
            Bb5Util.setId((PreparedStatement)stmt, (int)this.getColumnPosition("src_crsmain_pk1"), (Id)this._contentCopier._originalContent.getCourseId());
            Bb5Util.setId((PreparedStatement)stmt, (int)this.getColumnPosition("src_cc_pk1"), (Id)this._contentCopier._originalContent.getId());
            Bb5Util.setId((PreparedStatement)stmt, (int)this.getColumnPosition("dst_crsmain_pk1"), (Id)this._contentCopier._destination.getCourseId());
            Bb5Util.setId((PreparedStatement)stmt, (int)this.getColumnPosition("dst_cc_pk1"), (Id)this._contentCopier._destination.getId());
            DbUtil.setInteger((PreparedStatement)stmt, (int)this.getColumnPosition("update_flag"), (int)(this._contentCopier._deleteAfterCopy ? 1 : 0));
            DbUtil.setInteger((PreparedStatement)stmt, (int)this.getColumnPosition("copy_alignments_flag"), (int)(this._contentCopier._copyAlignments ? 1 : 0));
            DbUtil.setString((PreparedStatement)stmt, (int)this.getColumnPosition("v_session_guid"), (String)this._contentCopier._sessionUuid);
            if (!this.getUseResultSet()) {
                stmt.registerOutParameter(this.getColumnPosition("output_list"), 12);
            }
        }

        public void processResults(CallableStatement stmt) throws SQLException {
            this._outputList = stmt.getString(this.getColumnPosition("output_list"));
        }

        public void processResults(ResultSet rst) throws SQLException {
            this._outputList = rst.getString("outlist");
        }

        public String getNotCopiedList() {
            String str;
            String string = str = this._outputList != null ? this._outputList.trim() : null;
            if (str != null) {
                str = str.substring(str.indexOf(58) + 1).trim();
            }
            return str;
        }
    }
}

