/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.cxutil;

import blackboard.util.PlatformUtil;
import blackboard.util.StringUtil;
import java.io.File;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class CourseContentCopyUtil {
    private static final Pattern IDMATCHER = Pattern.compile("_(\\d+)_(\\d+)");

    public static String resolveTextBasedMapping(Map<String, String> map, String src) {
        if (map == null || src == null) {
            return src;
        }
        Matcher matches = CourseContentCopyUtil.getIdMatches(src);
        String value = null;
        while (matches.find()) {
            value = map.get(matches.group(0));
            if (value == null) continue;
            src = StringUtil.replace((String)src, (String)matches.group(0), (String)value);
        }
        return src;
    }

    public static String resolveFileBasedMapping(Map<String, String> map, String src) {
        if (map == null || src == null) {
            return src;
        }
        Matcher matches = CourseContentCopyUtil.getIdMatches(src);
        String value = null;
        String key = null;
        while (matches.find()) {
            value = map.get(matches.group(0));
            if (value == null) continue;
            if (PlatformUtil.osIsWindows()) {
                key = File.separator + File.separator + matches.group(0);
                value = File.separator + File.separator + value;
            } else {
                key = File.separator + matches.group(0);
                value = File.separator + value;
            }
            src = StringUtil.replace((String)src, (String)key, (String)value);
        }
        return src;
    }

    private static Matcher getIdMatches(String text) {
        Matcher m = null;
        try {
            m = IDMATCHER.matcher(text);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return m;
    }
}

