/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.data;

import blackboard.data.ValidationException;
import blackboard.data.ValidationWarning;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FieldValidationUtility {
    public static boolean isValidString(String src, boolean isNullable, int max) {
        if (src == null) {
            return isNullable;
        }
        if (!isNullable && src.length() == 0) {
            return false;
        }
        return src.length() <= max;
    }

    public static boolean containsInvalidCharacters(String src, Pattern pattern) throws ValidationException {
        ValidationException ve = new ValidationException();
        Matcher m = pattern.matcher(src);
        if (m.find()) {
            ve.addWarning(new ValidationWarning("Invalid value provided", "This field should not contain '" + m.group() + "'"));
        }
        if (ve.getWarnings().size() > 0) {
            throw ve;
        }
        return false;
    }

    public static boolean isEmptyString(String src) {
        return null == src || src.equals("");
    }

    public static boolean isValidInteger(int src, int min, int max) {
        return src <= max && src >= min;
    }

    public static boolean isValidInteger(Integer src, int min, int max, boolean bReq) {
        if (src == null) {
            return !bReq;
        }
        return src <= max && src >= min;
    }

    public static boolean isValidInteger(int src, int[] validValues) {
        for (int validValue : validValues) {
            if (src != validValue) continue;
            return true;
        }
        return false;
    }

    public static boolean isAscii(String value) {
        if (value == null || value.length() == 0) {
            return true;
        }
        for (int i = 0; i < value.length(); ++i) {
            char thisChar = value.charAt(i);
            if (thisChar <= '\u007f') continue;
            return false;
        }
        return true;
    }
}

