/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.data.category;

import blackboard.admin.data.FieldValidationUtility;
import blackboard.admin.data.IAdminObject;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.base.BbEnum;
import blackboard.data.ValidationException;
import blackboard.data.ValidationWarning;
import blackboard.data.category.BbAdminCategory;
import blackboard.persist.Id;
import blackboard.platform.api.PublicAPI;
import java.text.MessageFormat;

@PublicAPI
public abstract class AdminCategory
extends BbAdminCategory
implements IAdminObject {
    private static final long serialVersionUID = -1288042271754450521L;

    protected AdminCategory() {
        this._bbAttributes.removeBbAttribute("RowStatus");
        this._bbAttributes.setBbEnum("RowStatus", (BbEnum)IAdminObject.RowStatus.DEFAULT);
        this._bbAttributes.setBbEnum("RecStatus", (BbEnum)IAdminObject.RecStatus.DEFAULT);
        this._bbAttributes.setString("ParentBatchUid", null);
        this._bbAttributes.setString("ReplacementBatchUid", null);
        this._bbAttributes.setString("DataSourceBatchUid", null);
    }

    public String getReplacementBatchUid() {
        return this._bbAttributes.getSafeString("ReplacementBatchUid");
    }

    public void setReplacementBatchUid(String batchUid) {
        this._bbAttributes.setString("ReplacementBatchUid", batchUid);
    }

    public String getParentBatchUid() {
        return this._bbAttributes.getSafeString("ParentBatchUid");
    }

    public void setParentBatchUid(String batchUid) {
        this._bbAttributes.setString("ParentBatchUid", batchUid);
        this._bbAttributes.getBbAttribute("ParentId").setIsDirty(false);
    }

    @Override
    public String getDataSourceBatchUid() {
        return this._bbAttributes.getSafeString("DataSourceBatchUid");
    }

    @Override
    public void setDataSourceBatchUid(String batchUid) {
        this._bbAttributes.setString("DataSourceBatchUid", batchUid);
        this._bbAttributes.getBbAttribute("DataSourceId").setIsDirty(false);
    }

    @Override
    public void setDataSourceId(Id iDataSourceId) {
        this._bbAttributes.setId("DataSourceId", iDataSourceId);
        this._bbAttributes.getBbAttribute("DataSourceBatchUid").setIsDirty(false);
    }

    @Override
    public IAdminObject.RecStatus getRecStatus() {
        return (IAdminObject.RecStatus)this._bbAttributes.getBbEnum("RecStatus");
    }

    @Override
    public void setRecStatus(IAdminObject.RecStatus eRecStatus) {
        this._bbAttributes.setBbEnum("RecStatus", (BbEnum)eRecStatus);
    }

    @Override
    public IAdminObject.RowStatus getRowStatus() {
        return (IAdminObject.RowStatus)this._bbAttributes.getBbEnum("RowStatus");
    }

    @Override
    public void setRowStatus(IAdminObject.RowStatus eRowStatus) {
        this._bbAttributes.setBbEnum("RowStatus", (BbEnum)eRowStatus);
    }

    @Override
    public void validate() throws ValidationException {
        ValidationException ve = new ValidationException();
        String colName = "";
        Object[] args = new Object[]{colName};
        String cstr = ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.constraint");
        MessageFormat mf = new MessageFormat(ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.field"));
        colName = "DataSourceBatchUid";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getDataSourceBatchUid(), true, 256)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "BatchUid";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getBatchUid(), false, 256)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        if (this.getBbAttributes().getBbAttribute("ReplacementBatchUid").getIsDirty()) {
            colName = "ReplacementBatchUid";
            args[0] = colName;
            if (!FieldValidationUtility.isValidString(this.getReplacementBatchUid(), false, 256)) {
                ve.addWarning(new ValidationWarning(mf.format(args), cstr));
            }
        }
        colName = "Title";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getTitle(), true, 255)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "Description";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getDescription(), true, 1000)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        if (ve.getWarnings().size() > 0) {
            throw ve;
        }
    }
}

