/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.data.user;

import blackboard.admin.data.FieldValidationUtility;
import blackboard.admin.data.IAdminObject;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.base.BbEnum;
import blackboard.data.ValidationException;
import blackboard.data.ValidationWarning;
import blackboard.data.user.User;
import blackboard.persist.Id;
import blackboard.platform.api.PublicAPI;
import blackboard.platform.security.SecurityUtil;
import blackboard.util.StringUtil;
import blackboard.util.UuidFactory;
import java.text.MessageFormat;
import java.util.regex.Pattern;

@PublicAPI
public class Person
extends User
implements IAdminObject {
    private static final long serialVersionUID = 5461116043053155776L;

    public Person() {
        this._bbAttributes.removeBbAttribute("RowStatus");
        this._bbAttributes.setString("DataSourceBatchUid", null);
        this._bbAttributes.setString("ReplacementBatchUid", null);
        this._bbAttributes.setBbEnum("RowStatus", (BbEnum)IAdminObject.RowStatus.DEFAULT);
        this._bbAttributes.setBbEnum("RecStatus", (BbEnum)IAdminObject.RecStatus.DEFAULT);
        this._bbAttributes.setString("RawUserName", null);
        this._bbAttributes.reset();
    }

    public void setUserName(String strUserName) {
        this._bbAttributes.setString("RawUserName", strUserName);
        this._bbAttributes.setString("UserName", strUserName != null ? strUserName.toLowerCase() : null);
        if (strUserName != null && this._bbAttributes.getBbAttribute("Password").getValue() == null) {
            this._bbAttributes.setString("Password", RandomPasswordHolder.PLACEHOLDER_PASSWORD);
            this._bbAttributes.getBbAttribute("Password").setIsDirty(false);
        }
    }

    @Override
    public IAdminObject.RowStatus getRowStatus() {
        return (IAdminObject.RowStatus)this._bbAttributes.getBbEnum("RowStatus");
    }

    @Override
    public void setRowStatus(IAdminObject.RowStatus eRowStatus) {
        this._bbAttributes.setBbEnum("RowStatus", (BbEnum)eRowStatus);
    }

    @Override
    public IAdminObject.RecStatus getRecStatus() {
        return (IAdminObject.RecStatus)this._bbAttributes.getBbEnum("RecStatus");
    }

    @Override
    public void setRecStatus(IAdminObject.RecStatus eRecStatus) {
        this._bbAttributes.setBbEnum("RecStatus", (BbEnum)eRecStatus);
    }

    @Override
    public String getDataSourceBatchUid() {
        return this._bbAttributes.getSafeString("DataSourceBatchUid");
    }

    @Override
    public void setDataSourceBatchUid(String batchUid) {
        this._bbAttributes.setString("DataSourceBatchUid", batchUid);
        this._bbAttributes.getBbAttribute("DataSourceId").setIsDirty(false);
    }

    @Override
    public void setDataSourceId(Id iDataSourceId) {
        this._bbAttributes.setId("DataSourceId", iDataSourceId);
        this._bbAttributes.getBbAttribute("DataSourceBatchUid").setIsDirty(false);
    }

    public String getReplacementBatchUid() {
        return this._bbAttributes.getSafeString("ReplacementBatchUid");
    }

    public void setReplacementBatchUid(String batchUid) {
        this._bbAttributes.setString("ReplacementBatchUid", batchUid);
    }

    @Override
    public void validate() throws ValidationException {
        ValidationException ve = new ValidationException();
        String colName = "";
        Object[] args = new Object[]{colName};
        String cstr = ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.constraint");
        MessageFormat mf = new MessageFormat(ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.field"));
        colName = "DataSourceBatchUid";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getDataSourceBatchUid(), true, 256)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        if (this.getBbAttributes().getBbAttribute("ReplacementBatchUid").getIsDirty()) {
            colName = "ReplacementBatchUid";
            args[0] = colName;
            if (!FieldValidationUtility.isValidString(this.getReplacementBatchUid(), false, 256)) {
                ve.addWarning(new ValidationWarning(mf.format(args), cstr));
            }
        }
        colName = "BatchUid";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getBatchUid(), false, 256)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "UserName";
        args[0] = colName;
        String userName = this.getUserName();
        Pattern p = Pattern.compile("[ &#+<>%=\\\\/]");
        if (!FieldValidationUtility.isValidString(userName, false, 50) || FieldValidationUtility.containsInvalidCharacters(userName, p)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "Password";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getPassword(), true, 400)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "GivenName";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getGivenName(), false, 100)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "MiddleName";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getMiddleName(), true, 100)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "FamilyName";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getFamilyName(), false, 100)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "Title";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getTitle(), true, 100)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "OtherName";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getOtherName(), true, 100)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "Suffix";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getSuffix(), true, 100)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "Street1";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getStreet1(), true, 100)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "Street2";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getStreet2(), true, 100)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "City";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getCity(), true, 50)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "State";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getState(), true, 50)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "ZipCode";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getZipCode(), true, 50)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "Country";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getCountry(), true, 50)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "HomePhone1";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getHomePhone1(), true, 50)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "HomeFax";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getHomeFax(), true, 50)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "MobilePhone";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getMobilePhone(), true, 50)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "Email";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getEmailAddress(), true, 100)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        } else if (this.getEmailAddress() != null && StringUtil.notEmpty((String)this.getEmailAddress()) && this.getBbAttributes().getBbAttribute("Email").getIsDirty()) {
            char[] charBuffer = this.getEmailAddress().toCharArray();
            if (this.getEmailAddress().indexOf("@") == -1) {
                ve.addWarning(new ValidationWarning(mf.format(args), cstr));
            } else {
                for (int pos = 0; pos < charBuffer.length; ++pos) {
                    if (FieldValidationUtility.isAscii(this.getEmailAddress())) continue;
                    ve.addWarning(new ValidationWarning(mf.format(args), cstr));
                    break;
                }
            }
        }
        colName = "Company";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getCompany(), true, 100)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "Department";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getDepartment(), true, 100)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "JobTitle";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getJobTitle(), true, 100)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "BusinessPhone1";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getBusinessPhone1(), true, 50)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "BusinessFax";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getBusinessFax(), true, 50)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "HomePhone2";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getHomePhone2(), true, 50)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "BusinessPhone2";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getBusinessPhone2(), true, 50)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "WebPage";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getWebPage(), true, 100)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "CDRomDriveMac";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getCDRomDriveMac(), true, 20)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        colName = "CDRomDrivePC";
        args[0] = colName;
        if (!FieldValidationUtility.isValidString(this.getCDRomDrivePC(), true, 1)) {
            ve.addWarning(new ValidationWarning(mf.format(args), cstr));
        }
        if (ve.getWarnings().size() > 0) {
            throw ve;
        }
    }

    private static final class RandomPasswordHolder {
        private static final String RANDOM_PASSWORD = UuidFactory.createFormattedUuid();
        private static final String PLACEHOLDER_PASSWORD = SecurityUtil.getHashValue((String)RANDOM_PASSWORD);

        private RandomPasswordHolder() {
        }
    }
}

