/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.category.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.category.CourseCategoryMembership;
import blackboard.admin.persist.category.CourseCategoryMembershipPersister;
import blackboard.admin.persist.category.impl.CourseCategoryMembershipDbLoader;
import blackboard.admin.persist.category.impl.mapping.CourseCategoryMembershipDbMap;
import blackboard.admin.persist.category.impl.mapping.CourseCategoryMembershipDeleteDbMap;
import blackboard.admin.persist.impl.AdminInsertProcedureQuery;
import blackboard.admin.persist.impl.AdminRemoveProcedureQuery;
import blackboard.admin.persist.impl.AdminSaveProcedureQuery;
import blackboard.admin.persist.impl.AdminUpdateProcedureQuery;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.SnapshotDbPersister;
import blackboard.base.BbList;
import blackboard.data.BbObject;
import blackboard.data.Identifiable;
import blackboard.data.ValidationException;
import blackboard.data.category.BbCourseCategoryMembership;
import blackboard.data.category.CourseCategoryUID;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.category.CourseCategoryDbLoader;
import blackboard.persist.category.CourseCategoryUIDDAO;
import blackboard.persist.course.CourseDbLoader;
import blackboard.persist.impl.Query;
import blackboard.util.StringUtil;
import blackboard.util.UuidFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CourseCategoryMembershipDbPersister
extends SnapshotDbPersister<CourseCategoryMembership>
implements CourseCategoryMembershipPersister {
    String[] CONSTRAINTS = new String[]{"GATEWAY_COURSE_CATEGORIES_PK", "GATEWAY_COURSE_CATEGORIES_AK1"};

    @Override
    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        return super._createSession(dataSourceBatchUid, "gcc");
    }

    @Override
    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        super._createSession(dataSourceBatchUid, "gcc", sessionId);
    }

    @Override
    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        super.closeSession(strSessionId, "gcc");
    }

    @Override
    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, ValidationException, KeyNotFoundException {
        this.resolveBatchUid((CourseCategoryMembership)obj);
        String batchUID = this.resolveGCCBatchUid((CourseCategoryMembership)obj);
        super.save(CourseCategoryMembershipDbMap.MAP, obj, strSessionId);
        this.saveGCCBatchUID((CourseCategoryMembership)obj, batchUID);
    }

    @Override
    public Results save(List<CourseCategoryMembership> objList, String strSessionId) throws PersistenceException {
        this.resolveBatchUid(objList);
        HashMap<CourseCategoryMembership, String> batchUIDs = new HashMap<CourseCategoryMembership, String>();
        String batchUID = null;
        for (CourseCategoryMembership ccm : objList) {
            try {
                batchUID = this.resolveGCCBatchUid(ccm);
                batchUIDs.put(ccm, batchUID);
            }
            catch (PersistenceException e) {}
        }
        Results results = super.save(CourseCategoryMembershipDbMap.MAP, objList, strSessionId);
        for (Map.Entry entry : batchUIDs.entrySet()) {
            if (this.isEntryInErrors((CourseCategoryMembership)entry.getKey(), results)) continue;
            this.saveGCCBatchUID((CourseCategoryMembership)entry.getKey(), (String)entry.getValue(), results);
        }
        return results;
    }

    private boolean isEntryInErrors(CourseCategoryMembership ccm, Results results) {
        String courseBatchUid = ccm.getCourseSiteBatchUid();
        String categoryBatchUid = ccm.getCategoryBatchUid();
        CourseCategoryMembership errPrm = null;
        String errCategoryBatchUid = null;
        for (Results.Error err : results.getList()) {
            errPrm = (CourseCategoryMembership)err.getObject();
            String errCourseBatchUid = errPrm.getCourseSiteBatchUid();
            errCategoryBatchUid = errPrm.getCategoryBatchUid();
            if (!courseBatchUid.equals(errCourseBatchUid) || !categoryBatchUid.equals(errCategoryBatchUid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Results remove(List<CourseCategoryMembership> objList) throws PersistenceException {
        return super.remove(CourseCategoryMembershipDeleteDbMap.MAP, objList);
    }

    @Override
    public void save(CourseCategoryMembership objToSave, String strSessionId) throws PersistenceException, ValidationException, KeyNotFoundException {
        this.resolveBatchUid(objToSave);
        String batchUID = this.resolveGCCBatchUid(objToSave);
        super.save(CourseCategoryMembershipDbMap.MAP, objToSave, strSessionId);
        this.saveGCCBatchUID(objToSave, batchUID);
    }

    @Override
    public void insert(CourseCategoryMembership objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        objToSave.validate();
        try {
            String batchUID = this.resolveGCCBatchUid(objToSave);
            AdminInsertProcedureQuery query = new AdminInsertProcedureQuery(CourseCategoryMembershipDbMap.MAP, (BbObject)objToSave);
            super.runQuery((Query)query, null);
            this.saveGCCBatchUID(objToSave, batchUID);
        }
        catch (PersistenceException exc) {
            super._checkForConstraintViolation(exc, this.CONSTRAINTS);
        }
    }

    @Override
    public void save(CourseCategoryMembership objToSave) throws PersistenceException, ValidationException {
        this.resolveBatchUid(objToSave);
        this.handleAttributeTokens(objToSave);
        objToSave.validate();
        String batchUID = this.resolveGCCBatchUid(objToSave);
        AdminSaveProcedureQuery query = new AdminSaveProcedureQuery(CourseCategoryMembershipDbMap.MAP, (BbObject)objToSave);
        super.runQuery((Query)query, null);
        this.saveGCCBatchUID(objToSave, batchUID);
    }

    @Override
    public void update(CourseCategoryMembership objToSave) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminUpdateProcedureQuery query = new AdminUpdateProcedureQuery(CourseCategoryMembershipDbMap.MAP, (BbObject)objToSave);
        super.runQuery((Query)query, null);
    }

    @Override
    public void remove(CourseCategoryMembership objToRemove) throws KeyNotFoundException, PersistenceException {
        AdminRemoveProcedureQuery query = new AdminRemoveProcedureQuery(CourseCategoryMembershipDeleteDbMap.MAP, (BbObject)objToRemove);
        super.runQuery((Query)query, null);
    }

    private void resolveBatchUid(CourseCategoryMembership objInput) throws PersistenceException {
        if (objInput.getBbAttributes().getBbAttribute("GroupBatchUid").getIsDirty() && objInput.getBbAttributes().getBbAttribute("CategoryBatchUid").getIsDirty() || !this._pm.isValidId(objInput.getId())) {
            return;
        }
        CourseCategoryMembershipDbLoader loader = (CourseCategoryMembershipDbLoader)this._pm.getLoader("CourseCategoryMembershipLoader");
        CourseCategoryMembership obj = new CourseCategoryMembership();
        obj.setId(objInput.getId());
        BbList<CourseCategoryMembership> list = loader.load(obj);
        CourseCategoryMembership membership = this.getSingleItem(list, obj);
        objInput.setCourseSiteBatchUid(membership.getCourseSiteBatchUid());
        objInput.setCategoryBatchUid(membership.getCategoryBatchUid());
    }

    private void resolveBatchUid(List<CourseCategoryMembership> list) throws PersistenceException {
        for (CourseCategoryMembership obj : list) {
            this.resolveBatchUid(obj);
        }
    }

    private String resolveGCCBatchUid(CourseCategoryMembership obj) throws PersistenceException {
        Id courseId = null;
        Id catId = null;
        courseId = CourseDbLoader.Default.getInstance().loadByBatchUid(obj.getCourseSiteBatchUid()).getId();
        catId = ((CourseCategoryDbLoader)CourseCategoryDbLoader.Default.getInstance()).loadByBatchUid(obj.getCategoryBatchUid()).getId();
        BbCourseCategoryMembership ccm = null;
        try {
            if (null != courseId && null != catId) {
                ccm = ((blackboard.persist.category.CourseCategoryMembershipDbLoader)blackboard.persist.category.CourseCategoryMembershipDbLoader.Default.getInstance()).loadByCourseAndCategory(courseId, catId);
            }
        }
        catch (KeyNotFoundException e) {
        }
        catch (PersistenceException e) {
            throw e;
        }
        if (null != ccm && Id.isValidPkId((Id)ccm.getId())) {
            try {
                new CourseCategoryUIDDAO().loadByCourseCatMembershipId(ccm.getId());
                return null;
            }
            catch (Exception e) {
                return UuidFactory.createUuid();
            }
        }
        return UuidFactory.createUuid();
    }

    private void saveGCCBatchUID(CourseCategoryMembership obj, String batchUID, Results results) {
        block2: {
            try {
                this.saveGCCBatchUID(obj, batchUID);
            }
            catch (Exception e) {
                if (results == null) break block2;
                results.addError((BbObject)obj, e);
            }
        }
    }

    private void saveGCCBatchUID(CourseCategoryMembership obj, String batchUID) {
        if (null != obj && Id.isValid((Id)obj.getId()) && StringUtil.notEmpty((String)batchUID)) {
            CourseCategoryUIDDAO uidDAO = new CourseCategoryUIDDAO();
            uidDAO.deleteByCourseCatMembershipId(obj.getId());
            CourseCategoryUID membershipUID = new CourseCategoryUID();
            membershipUID.setBatchUID(batchUID);
            membershipUID.setCourseCategoryMembershipId(obj.getId());
            uidDAO.persist((Identifiable)membershipUID);
        }
    }
}

