/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.category.impl.soap.categorymembership;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.category.CourseCategoryMembership;
import blackboard.admin.data.category.OrganizationCategoryMembership;
import blackboard.admin.persist.category.CourseCategoryMembershipLoader;
import blackboard.admin.persist.category.CourseCategoryMembershipPersister;
import blackboard.admin.persist.category.OrganizationCategoryMembershipLoader;
import blackboard.admin.persist.category.OrganizationCategoryMembershipPersister;
import blackboard.admin.persist.category.impl.soap.categorymembership.ClientUtility;
import blackboard.admin.persist.impl.soap.IServerUtility;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.authority.RuntimeAuthority;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.SnapshotPersister;
import blackboard.admin.snapshot.persist.impl.RemoteResults;
import blackboard.data.BbObject;
import blackboard.data.ValidationException;
import blackboard.data.category.BbCategoryMembership;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.Persister;
import blackboard.platform.persistence.PersistenceServiceFactory;
import blackboard.util.ObjectSerializer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class ServerUtility
implements IServerUtility {
    public static final String ID_LIST = "categorymembership.id.list";

    public static String insert(String obj) throws PersistenceException, ConstraintViolationException, ValidationException {
        List<? extends BbCategoryMembership> list = ServerUtility.unMarshallObjects(obj);
        if (list.isEmpty()) {
            return "";
        }
        ArrayList<String> aList = new ArrayList<String>(list.size());
        BbObject pObj = (BbObject)list.get(0);
        if (pObj instanceof OrganizationCategoryMembership) {
            OrganizationCategoryMembershipPersister p = (OrganizationCategoryMembershipPersister)ServerUtility.getPersister("OrganizationCategoryMembershipPersister");
            for (OrganizationCategoryMembership organizationCategoryMembership : list) {
                p.insert(organizationCategoryMembership);
                aList.add(organizationCategoryMembership.getId().toExternalString());
            }
        } else {
            CourseCategoryMembershipPersister p = (CourseCategoryMembershipPersister)ServerUtility.getPersister("CourseCategoryMembershipPersister");
            for (CourseCategoryMembership courseCategoryMembership : list) {
                p.insert(courseCategoryMembership);
                aList.add(courseCategoryMembership.getId().toExternalString());
            }
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String update(String obj) throws PersistenceException, ValidationException {
        List<? extends BbCategoryMembership> list = ServerUtility.unMarshallObjects(obj);
        if (list.isEmpty()) {
            return "";
        }
        ArrayList<String> aList = new ArrayList<String>(list.size());
        BbObject pObj = (BbObject)list.get(0);
        if (pObj instanceof OrganizationCategoryMembership) {
            OrganizationCategoryMembershipPersister p = (OrganizationCategoryMembershipPersister)ServerUtility.getPersister("OrganizationCategoryMembershipPersister");
            for (OrganizationCategoryMembership organizationCategoryMembership : list) {
                p.update(organizationCategoryMembership);
                aList.add(organizationCategoryMembership.getId().toExternalString());
            }
        } else {
            CourseCategoryMembershipPersister p = (CourseCategoryMembershipPersister)ServerUtility.getPersister("CourseCategoryMembershipPersister");
            for (CourseCategoryMembership courseCategoryMembership : list) {
                p.update(courseCategoryMembership);
                aList.add(courseCategoryMembership.getId().toExternalString());
            }
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String save(String obj) throws PersistenceException, ValidationException {
        List<? extends BbCategoryMembership> list = ServerUtility.unMarshallObjects(obj);
        if (list.isEmpty()) {
            return "";
        }
        BbObject pObj = (BbObject)list.get(0);
        ArrayList<String> aList = new ArrayList<String>(list.size());
        if (pObj instanceof OrganizationCategoryMembership) {
            OrganizationCategoryMembershipPersister p = (OrganizationCategoryMembershipPersister)ServerUtility.getPersister("OrganizationCategoryMembershipPersister");
            for (OrganizationCategoryMembership organizationCategoryMembership : list) {
                p.save(organizationCategoryMembership);
                aList.add(organizationCategoryMembership.getId().toExternalString());
            }
        } else {
            CourseCategoryMembershipPersister p = (CourseCategoryMembershipPersister)ServerUtility.getPersister("CourseCategoryMembershipPersister");
            for (CourseCategoryMembership courseCategoryMembership : list) {
                p.save(courseCategoryMembership);
                aList.add(courseCategoryMembership.getId().toExternalString());
            }
        }
        return ObjectSerializer.serializeObject(aList);
    }

    public static String save(String obj, String session, String strProps) throws PersistenceException {
        Persister p;
        Properties props = (Properties)ObjectSerializer.deSerializeObject((String)strProps);
        List<? extends BbCategoryMembership> list = ServerUtility.unMarshallObjects(props, obj);
        BbCategoryMembership pObj = list.get(0);
        Results results = null;
        if (pObj instanceof OrganizationCategoryMembership) {
            p = (OrganizationCategoryMembershipPersister)ServerUtility.getPersister("OrganizationCategoryMembershipPersister");
            results = p.save(list, session);
        } else {
            p = (CourseCategoryMembershipPersister)ServerUtility.getPersister("CourseCategoryMembershipPersister");
            results = p.save(list, session);
        }
        Iterator<? extends BbCategoryMembership> iter = list.iterator();
        ArrayList<String> aList = new ArrayList<String>(list.size());
        while (iter.hasNext()) {
            BbObject tmp = (BbObject)iter.next();
            aList.add(tmp.getId().toExternalString());
        }
        ((RemoteResults)results).setAttribute(ID_LIST, aList);
        return ObjectSerializer.serializeObject((Object)results);
    }

    public static void remove(String obj) throws PersistenceException, ValidationException {
        List<? extends BbCategoryMembership> list = ServerUtility.unMarshallObjects(obj);
        if (list.isEmpty()) {
            return;
        }
        BbObject pObj = (BbObject)list.get(0);
        if (pObj instanceof OrganizationCategoryMembership) {
            OrganizationCategoryMembershipPersister p = (OrganizationCategoryMembershipPersister)ServerUtility.getPersister("OrganizationCategoryMembershipPersister");
            p.remove((OrganizationCategoryMembership)pObj);
        } else {
            CourseCategoryMembershipPersister p = (CourseCategoryMembershipPersister)ServerUtility.getPersister("CourseCategoryMembershipPersister");
            p.remove((CourseCategoryMembership)pObj);
        }
    }

    public static String removeList(String obj) throws PersistenceException {
        List<? extends BbCategoryMembership> list = ServerUtility.unMarshallObjects(obj);
        if (list.isEmpty()) {
            return null;
        }
        BbObject pObj = (BbObject)list.get(0);
        if (pObj instanceof OrganizationCategoryMembership) {
            OrganizationCategoryMembershipPersister p = (OrganizationCategoryMembershipPersister)ServerUtility.getPersister("OrganizationCategoryMembershipPersister");
            return ObjectSerializer.serializeObject((Object)p.remove(list));
        }
        CourseCategoryMembershipPersister p = (CourseCategoryMembershipPersister)ServerUtility.getPersister("CourseCategoryMembershipPersister");
        return ObjectSerializer.serializeObject((Object)p.remove(list));
    }

    public static String createSession(String dataSourceBatchUid, String persisterType) throws PersistenceException {
        return ServerUtility.getPersister(persisterType).createSession(dataSourceBatchUid);
    }

    public static void createSession(String dataSourceBatchUid, String persisterType, String sessionId) throws PersistenceException {
        ServerUtility.getPersister(persisterType).createSession(dataSourceBatchUid, sessionId);
    }

    public static void closeSession(String strSessionId, String persisterType) throws PersistenceException {
        ServerUtility.getPersister(persisterType).closeSession(strSessionId);
    }

    public static String load(String crsBatchUid, String categoryBatchUid, String loaderType) throws PersistenceException, KeyNotFoundException {
        IAdminObject obj = null;
        if (loaderType.equals("OrganizationCategoryMembershipLoader")) {
            OrganizationCategoryMembershipLoader l = OrganizationCategoryMembershipLoader.Default.getInstance();
            obj = l.load(crsBatchUid, categoryBatchUid);
        } else {
            CourseCategoryMembershipLoader l = CourseCategoryMembershipLoader.Default.getInstance();
            obj = l.load(crsBatchUid, categoryBatchUid);
        }
        return ClientUtility.convertToString((BbObject)obj);
    }

    public static String loadByTemplate(String template) throws PersistenceException {
        List<? extends BbCategoryMembership> list = ServerUtility.unMarshallObjects(template);
        if (list.isEmpty()) {
            return "";
        }
        BbObject pObj = (BbObject)list.get(0);
        if (pObj instanceof OrganizationCategoryMembership) {
            OrganizationCategoryMembershipLoader oLoader = OrganizationCategoryMembershipLoader.Default.getInstance();
            list = oLoader.load((OrganizationCategoryMembership)pObj);
        } else {
            CourseCategoryMembershipLoader cLoader = CourseCategoryMembershipLoader.Default.getInstance();
            list = cLoader.load((CourseCategoryMembership)pObj);
        }
        return ClientUtility.convertToString(list);
    }

    private static SnapshotPersister<?> getPersister(String persisterType) throws PersistenceException {
        return (SnapshotPersister)PersistenceServiceFactory.getInstance().getDbPersistenceManager().getPersister(persisterType);
    }

    public static List<? extends BbCategoryMembership> unMarshallObjects(String src) throws PersistenceException {
        return ServerUtility.unMarshallObjects(null, src);
    }

    public static List<? extends BbCategoryMembership> unMarshallObjects(Properties props, String src) throws PersistenceException {
        try {
            RuntimeAuthority ra = new RuntimeAuthority(props, new StringReader(src), Authority.Operation.MANUAL);
            ra.execute();
            return ra.getObjectList();
        }
        catch (Exception exc) {
            throw new PersistenceException((Throwable)exc);
        }
    }
}

