/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course;

import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.persist.course.CloneCallback;
import blackboard.base.BbEnum;
import blackboard.data.navigation.CourseToc;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.platform.api.PublicAPI;
import blackboard.platform.dataintegration.mapping.CourseCloneConfig;
import blackboard.platform.intl.BbResourceBundle;
import blackboard.platform.intl.BundleManagerFactory;
import blackboard.platform.intl.BundleMessage;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@PublicAPI
public class CloneConfig
implements Serializable {
    private Integer _tranCount = 300;
    private final ArrayList<String> _areaList;
    private final ArrayList<String> _cxComponentList;
    private final ArrayList<String> _tocIdList;
    private Boolean _bReconcile;
    private String _strDataSourceId = null;
    transient Map<String, CourseToc> _tocAreaMap;
    transient CloneCallback _callback;
    transient ArrayList<CourseToc> _originalTargetCourseTocList;
    private String _hostName;
    private String _sourceName;
    private boolean _isCommandLineRequest = false;
    private boolean _hadWarnings = false;
    private CourseCloneConfig.CloneOptions _csCloneOptions = CourseCloneConfig.CloneOptions.LINKS_AND_COURSE_FILES;
    private ArrayList<BundleMessage> _warningMessages;
    private String _rawCsDir = "";
    private String _csDir = "";
    private boolean _csDirVerified = false;
    private String _srcHomeDir = "";
    private CopyType _copyType = null;
    private Set<String> _excludedCsFolderIds = null;
    private boolean _fromAdminPanel = false;
    private boolean _useCourseCopyLog = true;
    private String _loggedOnUser;
    private boolean _cloneForDecrossList = false;
    private Map<Area, Set<String>> _includeObjectMap = new HashMap<Area, Set<String>>();
    private List<Id> _nodes = new LinkedList<Id>();
    private Id _primaryNode = null;
    private long _quota = 0L;
    static final long serialVersionUID = -6076185390264962900L;

    public CloneConfig() {
        this._areaList = new ArrayList();
        this._tocIdList = new ArrayList();
        this._cxComponentList = new ArrayList();
        this._tocAreaMap = new HashMap<String, CourseToc>();
        this._bReconcile = Boolean.FALSE;
        this._originalTargetCourseTocList = new ArrayList();
        this._warningMessages = new ArrayList();
    }

    public Boolean getReconcileFlag() {
        return this._bReconcile;
    }

    public void setReconcileFlag(Boolean reconcile) {
        if (reconcile == null) {
            reconcile = Boolean.TRUE;
        }
        this._bReconcile = reconcile;
    }

    public Id getMembershipDataSourceId() {
        Id val = null;
        try {
            if (this._strDataSourceId != null) {
                val = Id.generateId((DataType)DataSource.DATA_TYPE, (String)this._strDataSourceId);
            }
        }
        catch (Exception exc) {
            LogServiceFactory.getInstance().logWarning("Unable to generate DataSource id. _strDataSourceId is " + this._strDataSourceId, (Throwable)exc);
        }
        return val;
    }

    public void setMembershipDataSourceId(Id dataSourceId) {
        this._strDataSourceId = dataSourceId.toExternalString();
    }

    public List<String> getCourseTocIdList() {
        return this._tocIdList;
    }

    public CourseToc getRegisteredCourseToc(Id id) {
        if (this._tocAreaMap == null) {
            return null;
        }
        return this._tocAreaMap.get(id.toExternalString());
    }

    public void includeArea(CourseToc area) {
        if (this.isAreaIncluded(area)) {
            return;
        }
        this._tocAreaMap.put(area.getId().toExternalString(), area);
        this.includeArea(area.getId());
    }

    public void includeArea(Id areaId) {
        if (!this.isAreaIncluded(areaId)) {
            this._tocIdList.add(areaId.toExternalString());
            this.includeArea(Area.COURSE_TOC);
        }
    }

    public void excludeArea(CourseToc area) {
        this._tocAreaMap.remove(area.getId().toExternalString());
        this.excludeArea(area.getId());
    }

    public void excludeArea(Id areaId) {
        this._tocIdList.remove(areaId.toExternalString());
        if (this._tocAreaMap.containsKey(areaId.toExternalString())) {
            this._tocAreaMap.remove(areaId.toExternalString());
        }
        if (this._tocIdList.isEmpty()) {
            this.excludeArea(Area.COURSE_TOC);
        }
    }

    public boolean isAreaIncluded(CourseToc area) {
        return this.isAreaIncluded(area.getId());
    }

    public boolean isAreaIncluded(Id area) {
        return this._tocIdList.contains(area.toExternalString());
    }

    public boolean isCxComponentIncluded(String componentHandle) {
        return this.isAreaIncluded(Area.ALL) || this._cxComponentList.contains(componentHandle);
    }

    public void includeCxComponent(String componentHandle) {
        this._cxComponentList.add(componentHandle);
    }

    public void includeArea(Area area) {
        Area[] set;
        if (area != Area.ALL) {
            if (!this.isAreaIncluded(area)) {
                if (area == Area.GRADES) {
                    this.includeArea(Area.MEMBERSHIP);
                } else if (area == Area.CHAT_ARCHIVE) {
                    this.includeArea(Area.CHAT_SESSION);
                } else if (area == Area.MEMBERSHIP_EXACT) {
                    this.includeArea(Area.MEMBERSHIP);
                }
                this._areaList.add(area.toExternalString());
            }
            return;
        }
        for (Area element : set = Area.getValues()) {
            if (element == Area.ALL) {
                this._areaList.add(Area.ALL.toExternalString());
                continue;
            }
            this.includeArea(element);
        }
    }

    public void includeObject(Area eArea, String strId) {
        if (eArea == Area.ALL) {
            return;
        }
        Set<String> set = this._includeObjectMap.get((Object)eArea);
        if (set == null) {
            set = new HashSet<String>();
        }
        set.add(strId);
        this._includeObjectMap.put(eArea, set);
    }

    public Set<String> getIncludedObjects(Area eArea) {
        return this._includeObjectMap.get((Object)eArea);
    }

    public void excludeArea(Area area) {
        if (area == Area.ALL) {
            this._areaList.clear();
            this._tocIdList.clear();
            if (null != this._tocAreaMap) {
                this._tocAreaMap.clear();
            }
            return;
        }
        if (area == Area.COURSE_TOC) {
            this._areaList.remove(area.toExternalString());
            this._tocIdList.clear();
            if (null != this._tocAreaMap) {
                this._tocAreaMap.clear();
            }
            return;
        }
        if (area == Area.MEMBERSHIP) {
            if (this.isAreaIncluded(Area.GRADES)) {
                this.excludeArea(Area.GRADES);
            }
            if (this.isAreaIncluded(Area.MEMBERSHIP_EXACT)) {
                this.excludeArea(Area.MEMBERSHIP_EXACT);
            }
        } else if (area == Area.CHAT_SESSION && this.isAreaIncluded(Area.CHAT_ARCHIVE)) {
            this.excludeArea(Area.CHAT_ARCHIVE);
        }
        this._areaList.remove(area.toExternalString());
    }

    public boolean isAreaIncluded(Area area) {
        return this._areaList.contains(area.toExternalString());
    }

    public void setCallback(CloneCallback callback) {
        this._callback = callback;
    }

    public void setArchiveCSItems(boolean archiveCSItems) {
        this._csCloneOptions = archiveCSItems ? CourseCloneConfig.CloneOptions.LINKS_AND_REGISTERED : CourseCloneConfig.CloneOptions.LINKS;
    }

    public CloneCallback getCallback() {
        return this._callback;
    }

    public void setOriginalTargetCourseTocList(ArrayList<CourseToc> originalTargetCourseTocList) {
        this._originalTargetCourseTocList = originalTargetCourseTocList;
    }

    public ArrayList<CourseToc> getOriginalTargetCourseTocList() {
        return this._originalTargetCourseTocList;
    }

    public int getMaximumTransactionCount() {
        return this._tranCount;
    }

    public void setMaximumTransactionCount(int tranCount) {
        this._tranCount = tranCount;
    }

    @Deprecated
    public boolean getSuppressEvents() {
        return false;
    }

    @Deprecated
    public void setSuppressEvents(boolean val) {
    }

    public String getLoggedOnUser() {
        return this._loggedOnUser;
    }

    public void setLoggedOnUser(String loggedOnUser) {
        this._loggedOnUser = loggedOnUser;
    }

    public String getHostName() {
        return this._hostName;
    }

    public void setHostName(String hostName) {
        this._hostName = hostName;
    }

    public String getSourceName() {
        if (StringUtil.isEmpty((String)this._sourceName)) {
            BbResourceBundle bundle = BundleManagerFactory.getInstance().getBundle("copy");
            this._sourceName = bundle.getString("course.copy.title");
        }
        return this._sourceName;
    }

    public void setSourceName(String name) {
        this._sourceName = name;
    }

    public boolean getIsCommandLineRequest() {
        return this._isCommandLineRequest;
    }

    public void setIsCommandLineRequest(boolean commandLineRequest) {
        this._isCommandLineRequest = commandLineRequest;
    }

    public boolean isHadWarnings() {
        return this._hadWarnings;
    }

    public void setHadWarnings(boolean hadWarnings) {
        this._hadWarnings = hadWarnings;
    }

    public void setCloneOptions(CourseCloneConfig.CloneOptions archiveCSItems) {
        this._csCloneOptions = archiveCSItems;
    }

    public void addWarningMessage(String bundle, String key, Object[] args) {
        this._warningMessages.add(new BundleMessage(bundle, key, args));
    }

    public ArrayList<BundleMessage> getWarningMessages() {
        return this._warningMessages;
    }

    public CopyType getCopyType() {
        if (this._copyType == null) {
            this._copyType = this.isAreaIncluded(Area.ALL) ? CopyType.COPY_EXACT_COURSE : CopyType.COPY_NEW_COURSE;
        }
        return this._copyType;
    }

    public void setCopyType(CopyType copyType) {
        this._copyType = copyType;
    }

    public void setCopyType(String copyType) {
        if (StringUtil.notEmpty((String)copyType)) {
            this._copyType = CopyType.fromName(copyType);
        }
    }

    public boolean getCsDirVerified() {
        return this._csDirVerified;
    }

    public void setCsDirVerified(boolean csDirVerified) {
        this._csDirVerified = csDirVerified;
    }

    public String getSrcHomeDir() {
        return this._srcHomeDir;
    }

    public void setSrcHomeDir(String srcHomeDir) {
        this._srcHomeDir = srcHomeDir;
    }

    public Set<String> getExcludedCsFolderIds() {
        return this._excludedCsFolderIds;
    }

    public void setExcludedCsFolderIds(String[] excludedXythosIds) {
        if (excludedXythosIds != null && excludedXythosIds.length > 0) {
            if (this._excludedCsFolderIds == null) {
                this._excludedCsFolderIds = new HashSet<String>();
            }
            for (String xythosId : excludedXythosIds) {
                if (!StringUtil.notEmpty((String)xythosId)) continue;
                this._excludedCsFolderIds.add(xythosId);
            }
        }
    }

    public String getCsDir() {
        return this._csDir;
    }

    public void setCsDir(String csDir) {
        this._csDir = csDir;
    }

    public void resetCsDir() {
        this._csDir = this._rawCsDir;
        this._csDirVerified = false;
    }

    public String getRawCsDir() {
        return this._rawCsDir;
    }

    public void setRawCsDir(String rawCsDir) {
        this._rawCsDir = rawCsDir;
        this._csDir = rawCsDir;
    }

    public CourseCloneConfig.CloneOptions getCloneOptions() {
        return this._csCloneOptions;
    }

    public boolean shouldCopyAnyCSItems() {
        return this._csCloneOptions != CourseCloneConfig.CloneOptions.LINKS;
    }

    public boolean shouldCopyAllCSItems() {
        return this._csCloneOptions == CourseCloneConfig.CloneOptions.LINKS_AND_COURSE_FILES;
    }

    public boolean shouldCopyCSItemByArea() {
        return this._csCloneOptions == CourseCloneConfig.CloneOptions.LINKS_AND_REGISTERED;
    }

    public void setIsFromAdminPanel(boolean fromAdminPanel) {
        this._fromAdminPanel = fromAdminPanel;
    }

    public boolean isFromAdminPanel() {
        return this._fromAdminPanel;
    }

    public boolean isCloneForDecrossList() {
        return this._cloneForDecrossList;
    }

    public void setCloneForDecrossList(boolean cloneForDecrossList) {
        this._cloneForDecrossList = cloneForDecrossList;
    }

    public void setUseCourseCopyLog(boolean useCopyLog) {
        this._useCourseCopyLog = useCopyLog;
    }

    public boolean canUseCourseCopyLog() {
        return this._useCourseCopyLog;
    }

    public Map<Area, Set<String>> getIncludeObjectMap() {
        return this._includeObjectMap;
    }

    public void setIncludeObjectMap(Map<Area, Set<String>> includeObjectMap) {
        this._includeObjectMap = includeObjectMap;
    }

    public List<Id> getNodes() {
        return this._nodes;
    }

    public void setNodes(List<Id> nodes) {
        this._nodes = nodes;
    }

    public Id getPrimaryNode() {
        return this._primaryNode;
    }

    public void setPrimaryNode(Id node) {
        this._primaryNode = node;
    }

    public long getQuota() {
        return this._quota;
    }

    public void setQuota(long quota) {
        this._quota = quota;
    }

    public static class Area
    extends BbEnum {
        public static final Area ASSESSMENT = new Area("ASSESSMENT", "jsp.contentarea.assessment");
        public static final Area CATEGORY_MEMBERSHIP = new Area("CATEGORY_MEMBERSHIP");
        public static final Area ANNOUNCEMENT = new Area("ANNOUNCEMENT", "jsp.contentarea.announcement");
        public static final Area GLOSSARY = new Area("GLOSSARY", "jsp.contentarea.glossary");
        public static final Area CALENDAR = new Area("CALENDAR", "jsp.contentarea.calendar");
        public static final Area RUBRIC = new Area("RUBRIC", "jsp.contentarea.learnrubrics");
        public static final Area TASK = new Area("TASKS", "jsp.contentarea.tasks");
        public static final Area BLOG = new Area("BLOG", "jsp.contentarea.blogs");
        public static final Area JOURNAL = new Area("JOURNAL", "jsp.contentarea.journals");
        public static final Area SETTING = new Area("SETTING", "jsp.contentarea.settings");
        public static final Area STD_ALIGNMENT = new Area("STD_ALIGNMENT", "jsp.contentarea.alignments");
        public static final Area CONTENT = new Area("CONTENT");
        public static final Area COURSE_TOC = new Area("COURSE_TOC");
        public static final Area CHAT_ARCHIVE = new Area("CHATARCHIVE", "jsp.contentarea.collabarchives");
        public static final Area CHAT_SESSION = new Area("CHATSESSION", "jsp.contentarea.collabsessions");
        public static final Area DROP_BOX = new Area("DROPBOX", "jsp.contentarea.dropbox");
        public static final Area COURSE_STATISTICS = new Area("COURSESTATISTICS", "jsp.content.stats");
        public static final Area STAFF_INFORMATION = new Area("STAFFINFORMATION", "jsp.contentarea.staffinformation");
        public static final Area EARLY_WARNING_SYSTEM = new Area("EARLY_WARNING_SYSTEM", "jsp.contentarea.notificationrule");
        public static final Area DISCUSSION_BOARD = new Area("DISCUSSIONBOARD", "jsp.contentarea.discussionboard");
        public static final Area DISCUSSION_BOARD_ARCHIVE = new Area("DISCUSSIONBOARDARCHIVE");
        public static final Area GROUP = new Area("GROUP", "jsp.contentarea.groups");
        public static final Area GRADEBOOK = new Area("GRADEBOOK", "jsp.contentarea.gradebookitems");
        public static final Area GRADES = new Area("GRADES");
        public static final Area GRADEBOOK_CLEAR = new Area("GRADEBOOK_CLEAR");
        public static final Area MEMBERSHIP = new Area("MEMBERSHIP", "jsp.course.enrollments");
        public static final Area MEMBERSHIP_EXACT = new Area("MEMBERSHIP_EXACT");
        public static final Area COURSE_CARTRIDGE = new Area("COURSE_CARTRIDGE");
        public static final Area DISCUSSION_CARTRIDGE = new Area("DISCUSSION_CARTRIDGE", "jsp.contentarea.discussionboard.cartridge");
        public static final Area ASSESSMENT_CARTRIDGE = new Area("ASSESSMENT_CARTRIDGE", "jsp.contentarea.assessment.cartridge");
        public static final Area AVAILABILITY_RULE = new Area("AVAILABILITY_RULE", "jsp.contentarea.availabilityrule");
        public static final Area ALL = new Area("ALL");
        public static final Area DEFAULT = (Area)Area.defineDefault((BbEnum)ALL);
        private String _displayKey;
        private static final long serialVersionUID = 1L;

        protected Area(String enumFieldName, String displayKey) {
            super(enumFieldName);
            this._displayKey = displayKey;
        }

        protected Area(String enumFieldName) {
            super(enumFieldName);
            this._displayKey = "";
        }

        public static Area[] getValues() {
            return (Area[])BbEnum.getValues(Area.class);
        }

        public static Area fromExternalString(String externalString) throws IllegalArgumentException {
            return (Area)BbEnum.fromExternalString((String)externalString, Area.class);
        }

        public boolean hasDisplayKey() {
            return StringUtil.notEmpty((String)this._displayKey);
        }

        public String getDisplayKey() {
            return this._displayKey;
        }
    }

    public static enum CopyType {
        COPY_NEW_COURSE("N"),
        COPY_EXISTING_COURSE("O"),
        COPY_EXACT_COURSE("E");

        private String _name;

        private CopyType(String mappingName) {
            this._name = mappingName;
        }

        public String getName() {
            return this._name;
        }

        public static CopyType fromName(String name) {
            for (CopyType type : CopyType.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return null;
        }
    }
}

