/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course;

import blackboard.admin.persist.course.CloneConfig;
import blackboard.data.course.Course;
import blackboard.platform.filesystem.FileSystemException;
import blackboard.platform.filesystem.FileSystemServiceFactory;
import blackboard.platform.filesystem.manager.CourseFileManager;
import blackboard.platform.log.LogService;
import blackboard.util.FileUtil;
import blackboard.util.FileUtilEx;
import blackboard.util.GeneralUtil;
import blackboard.util.StringUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CourseCopyLogFileSpecifications {
    private String _logFileName;
    private List<LogSpecification> _specifications = new ArrayList<LogSpecification>();
    public static final String LOG_DIR_NAME = "course-copy";
    public static final String DECROSSLIST_FILE_NAME = "Decrosslist_";
    public static final String FILE_NAME = "CourseCopy_";
    public static final String EXT = ".txt";
    public static final String DETAILED_LOG_POSTFIX = "_detailed";

    private CourseCopyLogFileSpecifications() {
    }

    public List<LogSpecification> getSpecifications() {
        return this._specifications;
    }

    public String getLogFileName() {
        return this._logFileName;
    }

    private void setLogFileName(String logFileName) {
        this._logFileName = logFileName;
    }

    private void addSpecification(LogSpecification specification) {
        this._specifications.add(specification);
    }

    public static CourseCopyLogFileSpecifications generate(String courseId, CloneConfig cloneConfig) {
        File destDir = new File(CourseCopyLogFileSpecifications.getBaseCourseDir(courseId), LOG_DIR_NAME);
        FileUtilEx.mkdir((File)destDir);
        String prefix = null;
        prefix = cloneConfig.isCloneForDecrossList() ? DECROSSLIST_FILE_NAME : FILE_NAME;
        CourseCopyLogFileSpecifications specifications = new CourseCopyLogFileSpecifications();
        File log = new File(destDir, CourseCopyLogFileSpecifications.getSafeName(courseId, prefix, "", false));
        LogSpecification specification = new LogSpecification(log.getAbsolutePath(), LogService.Verbosity.INFORMATION);
        specifications.addSpecification(specification);
        String logFileName = FileUtil.getFileName((String)specification.getLogName());
        specifications.setLogFileName(logFileName);
        File detailedLog = new File(destDir, CourseCopyLogFileSpecifications.getSafeName(courseId, prefix, "", true));
        specifications.addSpecification(new LogSpecification(detailedLog.getAbsolutePath(), LogService.Verbosity.DEBUG));
        return specifications;
    }

    private static String getSafeName(String courseId, String prefix, String interfix, boolean detailed) {
        boolean escapeFileName = true;
        if (StringUtil.isEmpty((String)interfix)) {
            interfix = courseId;
            escapeFileName = false;
        }
        String name = prefix + interfix;
        String timestamp = GeneralUtil.logFileTimeStamp();
        String postfix = "_" + timestamp + CourseCopyLogFileSpecifications.getPostfix(detailed);
        name = StringUtil.truncateAndAppend((int)150, (String)name, (String)postfix);
        return escapeFileName ? FileUtil.escapeFileName((String)name) : name;
    }

    private static final File getBaseCourseDir(String courseId) {
        try {
            CourseFileManager fMgr = (CourseFileManager)FileSystemServiceFactory.getInstance().getFileManager(Course.DATA_TYPE);
            return fMgr.getRootDirectory(courseId);
        }
        catch (FileSystemException fse) {
            throw new RuntimeException("Failed to get base directory for course " + courseId, fse);
        }
    }

    private static String getPostfix(boolean detailed) {
        return detailed ? "_detailed.txt" : EXT;
    }

    public static class LogSpecification
    implements Serializable {
        private static final long serialVersionUID = -348834404981627365L;
        private String _strLogName = null;
        private LogService.Verbosity _verbosity = null;

        public LogSpecification(String strLogName, LogService.Verbosity verbosity) {
            this._strLogName = strLogName;
            this._verbosity = verbosity;
        }

        public String getLogName() {
            return this._strLogName;
        }

        public LogService.Verbosity getVerbosity() {
            return this._verbosity;
        }

        public boolean equals(Object obj) {
            boolean result = obj instanceof LogSpecification;
            if (result) {
                LogSpecification log = (LogSpecification)obj;
                result = result && this._verbosity.equals((Object)log._verbosity) && this._strLogName.equals(log._strLogName);
            }
            return result;
        }

        public int hashCode() {
            int prime = 23;
            int result = 1;
            result = 23 * result + (this._strLogName == null ? 0 : this._strLogName.hashCode());
            result = 23 * result + (this._verbosity == null ? 0 : this._verbosity.hashCode());
            return result;
        }

        public String toString() {
            return "Log{name=" + this._strLogName + ", verbosity=" + (this._verbosity == null ? "default" : this._verbosity.toExternalString()) + "}";
        }
    }
}

