/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.course.AdminCourseCourse;
import blackboard.admin.persist.course.AdminCourseCoursePersister;
import blackboard.admin.persist.course.impl.AdminCourseCourseDbLoader;
import blackboard.admin.persist.course.impl.mapping.AdminCourseCourseDbMap;
import blackboard.admin.persist.course.impl.mapping.AdminCourseCourseDeleteDbMap;
import blackboard.admin.persist.impl.AdminInsertProcedureQuery;
import blackboard.admin.persist.impl.AdminRemoveProcedureQuery;
import blackboard.admin.persist.impl.AdminSaveProcedureQuery;
import blackboard.admin.persist.impl.AdminUpdateProcedureQuery;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.SnapshotDbPersister;
import blackboard.data.BbObject;
import blackboard.data.ValidationException;
import blackboard.data.course.Course;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.course.CourseDbLoader;
import blackboard.persist.impl.Query;
import java.util.List;

public class AdminCourseCourseDbPersister
extends SnapshotDbPersister<AdminCourseCourse>
implements AdminCourseCoursePersister {
    String[] CONSTRAINTS = new String[]{"COURSE_COURSE_PK", "COURSE_COURSE_AK1"};

    @Override
    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        return super._createSession(dataSourceBatchUid, "cc");
    }

    @Override
    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        super._createSession(dataSourceBatchUid, "cc", sessionId);
    }

    @Override
    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        super.closeSession(strSessionId, "cc");
    }

    @Override
    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.save((AdminCourseCourse)obj, strSessionId);
    }

    @Override
    public Results save(List<AdminCourseCourse> objList, String strSessionId) throws PersistenceException {
        this.resolveBatchUid(objList);
        return super.save(AdminCourseCourseDbMap.MAP, objList, strSessionId);
    }

    @Override
    public Results remove(List<AdminCourseCourse> objList) throws PersistenceException {
        return super.remove(AdminCourseCourseDeleteDbMap.MAP, objList);
    }

    @Override
    public void save(AdminCourseCourse objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        this.resolveBatchUid(objToSave);
        this.handleAttributeTokens(objToSave);
        objToSave.validate();
        AdminSaveProcedureQuery query = new AdminSaveProcedureQuery(AdminCourseCourseDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
        }
        catch (PersistenceException exc) {
            super._checkForConstraintViolation(exc, this.CONSTRAINTS);
        }
    }

    @Override
    public void save(AdminCourseCourse objToSave, String strSessionId) throws PersistenceException, ValidationException {
        this.resolveBatchUid(objToSave);
        super.save(AdminCourseCourseDbMap.MAP, objToSave, strSessionId);
    }

    @Override
    public void insert(AdminCourseCourse objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        objToSave.validate();
        AdminInsertProcedureQuery query = new AdminInsertProcedureQuery(AdminCourseCourseDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
        }
        catch (PersistenceException exc) {
            super._checkForConstraintViolation(exc, this.CONSTRAINTS);
        }
    }

    @Override
    public void update(AdminCourseCourse objToSave) throws PersistenceException, ConstraintViolationException, KeyNotFoundException, ValidationException {
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminUpdateProcedureQuery query = new AdminUpdateProcedureQuery(AdminCourseCourseDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
        }
        catch (PersistenceException exc) {
            super._checkForConstraintViolation(exc, this.CONSTRAINTS);
        }
    }

    @Override
    public void remove(AdminCourseCourse objToRemove) throws KeyNotFoundException, PersistenceException {
        AdminRemoveProcedureQuery query = new AdminRemoveProcedureQuery(AdminCourseCourseDeleteDbMap.MAP, (BbObject)objToRemove);
        super.runQuery((Query)query, null);
    }

    private void resolveBatchUid(AdminCourseCourse objInput) throws PersistenceException {
        if (!this._pm.isValidId(objInput.getId())) {
            CourseDbLoader courseLoader = CourseDbLoader.Default.getInstance();
            Course parentCourse = courseLoader.loadByBatchUid(objInput.getParentGroupBatchUid());
            Course childCourse = courseLoader.loadByBatchUid(objInput.getChildGroupBatchUid());
            objInput.setParentCourseId(parentCourse.getId());
            objInput.setChildCourseId(childCourse.getId());
            return;
        }
        AdminCourseCourseDbLoader loader = (AdminCourseCourseDbLoader)this._pm.getLoader("AdminCourseCourseLoader");
        AdminCourseCourse courseCourse = loader.loadById(objInput.getId());
        objInput.setParentGroupBatchUid(courseCourse.getParentGroupBatchUid());
        objInput.setChildGroupBatchUid(courseCourse.getChildGroupBatchUid());
        objInput.setDataSourceBatchUid(courseCourse.getDataSourceBatchUid());
    }

    private void resolveBatchUid(List<AdminCourseCourse> list) throws PersistenceException {
        for (AdminCourseCourse obj : list) {
            this.resolveBatchUid(obj);
        }
    }
}

