/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.course.CourseSite;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.CourseSitePersister;
import blackboard.admin.persist.course.impl.soap.admincourse.ClientUtility;
import blackboard.admin.persist.impl.AdminPersister;
import blackboard.admin.snapshot.persist.Results;
import blackboard.data.ValidationException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.platform.intl.BundleManagerFactory;
import blackboard.platform.log.LogServiceFactory;
import blackboard.platform.soap.ServerResponse;
import blackboard.util.ObjectSerializer;
import java.util.ArrayList;
import java.util.List;

public class CourseSiteRemotePersister
extends AdminPersister
implements CourseSitePersister {
    @Override
    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        super.checkApiLicensing();
        ClientUtility req = new ClientUtility();
        req.createSession(dataSourceBatchUid, "CourseSitePersister");
        ServerResponse response = this.executeSoapCall(req);
        return (String)response.getResults();
    }

    @Override
    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        super.checkApiLicensing();
        ClientUtility req = new ClientUtility();
        req.createSession(dataSourceBatchUid, "CourseSitePersister", sessionId);
        this.executeSoapCall(req);
    }

    @Override
    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        super.checkApiLicensing();
        ClientUtility req = new ClientUtility();
        req.closeSession(strSessionId, "CourseSitePersister");
        try {
            this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
    }

    @Override
    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        super.checkApiLicensing();
        try {
            this.save((CourseSite)obj, strSessionId);
        }
        catch (PersistenceException pe) {
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
    }

    @Override
    public Results save(List<CourseSite> objList, String strSessionId) throws PersistenceException {
        super.checkApiLicensing();
        ClientUtility req = new ClientUtility();
        req.save(objList, strSessionId);
        ServerResponse response = this.executeSoapCall(req);
        return this.resolveInternalId(objList, response, "admincourse.id.list");
    }

    @Override
    public Results remove(List<CourseSite> objList) throws PersistenceException {
        super.checkApiLicensing();
        ClientUtility req = new ClientUtility();
        req.remove(objList);
        ServerResponse response = this.executeSoapCall(req);
        return (Results)ObjectSerializer.deSerializeObject((String)((String)response.getResults()));
    }

    @Override
    public Results remove(List<CourseSite> objList, boolean removeContent) throws PersistenceException {
        String warningMesssage = BundleManagerFactory.getInstance().getBundle("snapshot").getString("snapshot.soap.delete.coursefiles.notsupported");
        LogServiceFactory.getInstance().logWarning(warningMesssage);
        return this.remove(objList);
    }

    @Override
    public void save(CourseSite objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        super.checkApiLicensing();
        objToSave.validate();
        ClientUtility req = new ClientUtility();
        req.save(objToSave);
        ServerResponse response = null;
        try {
            response = this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForConstraintViolationException(pe);
            throw pe;
        }
        this.resolveInternalId(objToSave, response);
    }

    @Override
    public void save(CourseSite objToSave, String strSessionId) throws PersistenceException, ValidationException {
        super.checkApiLicensing();
        objToSave.validate();
        ClientUtility req = new ClientUtility();
        req.save(objToSave, strSessionId);
        ServerResponse response = this.executeSoapCall(req);
        ArrayList<CourseSite> bList = new ArrayList<CourseSite>();
        bList.add(objToSave);
        this.resolveInternalId(bList, response, "admincourse.id.list");
    }

    @Override
    public void insert(CourseSite objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        super.checkApiLicensing();
        objToSave.validate();
        ClientUtility req = new ClientUtility();
        req.insert(objToSave);
        ServerResponse response = null;
        try {
            response = this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForConstraintViolationException(pe);
            throw pe;
        }
        this.resolveInternalId(objToSave, response);
    }

    @Override
    public void update(CourseSite objToSave) throws PersistenceException, KeyNotFoundException, ValidationException {
        super.checkApiLicensing();
        objToSave.validate();
        ClientUtility req = new ClientUtility();
        req.update(objToSave);
        ServerResponse response = null;
        try {
            response = this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
        this.resolveInternalId(objToSave, response);
    }

    @Override
    public void remove(CourseSite objToRemove) throws KeyNotFoundException, PersistenceException {
        super.checkApiLicensing();
        ClientUtility req = new ClientUtility();
        req.remove(objToRemove);
        try {
            this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
    }

    @Override
    public void changeKey(CourseSite objToSave, String newKey) throws PersistenceException, ValidationException, KeyNotFoundException {
        super.checkApiLicensing();
        objToSave.setReplacementBatchUid(newKey);
        this.update(objToSave);
    }

    @Override
    public void clone(String srcCrsBatchUid, String tgtCrsBatchUid, CloneConfig cfg) throws PersistenceException, KeyNotFoundException, ConstraintViolationException {
        ClientUtility req = new ClientUtility();
        req.clone(srcCrsBatchUid, tgtCrsBatchUid, cfg);
        try {
            this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForConstraintViolationException(pe);
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
    }
}

