/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl;

import blackboard.admin.data.course.CourseStandardSubDocument;
import blackboard.admin.persist.course.CourseStandardSubDocumentXmlPersister;
import blackboard.admin.persist.impl.AdminPersister;
import blackboard.data.ValidationException;
import blackboard.xml.XmlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CourseStandardSubDocumentXmlPersisterImpl
extends AdminPersister
implements CourseStandardSubDocumentXmlPersister {
    @Override
    public void persist(List<CourseStandardSubDocument> masterList, Document doc) throws ValidationException {
        Element root = doc.createElement("enterprise");
        doc.appendChild(root);
        for (List<CourseStandardSubDocument> list : this.mapByCourse(masterList).values()) {
            Element course = doc.createElement("group");
            root.appendChild(course);
            Element sourcedId = doc.createElement("sourcedid");
            XmlUtil.buildChildElement((Document)doc, (Element)sourcedId, (String)"source", (String)"Bb Platform");
            XmlUtil.buildChildElement((Document)doc, (Element)sourcedId, (String)"id", (String)list.get(0).getCourseBatchUid());
            course.appendChild(sourcedId);
            Element extension = doc.createElement("extension");
            course.appendChild(extension);
            Element associations = doc.createElement("course_std_sub_doc_associations");
            extension.appendChild(associations);
            for (CourseStandardSubDocument c : list) {
                XmlUtil.buildChildElement((Document)doc, (Element)associations, (String)"sub_doc_batch_uid", (String)c.getSubDocBatchUid());
            }
        }
    }

    private Map<String, List<CourseStandardSubDocument>> mapByCourse(List<CourseStandardSubDocument> masterList) throws ValidationException {
        HashMap<String, List<CourseStandardSubDocument>> map = new HashMap<String, List<CourseStandardSubDocument>>();
        for (CourseStandardSubDocument c : masterList) {
            c.validate();
            ArrayList<CourseStandardSubDocument> list = (ArrayList<CourseStandardSubDocument>)map.get(c.getCourseBatchUid());
            if (list == null) {
                list = new ArrayList<CourseStandardSubDocument>();
                map.put(c.getCourseBatchUid(), list);
            }
            list.add(c);
        }
        return map;
    }
}

