/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl;

import blackboard.admin.data.course.Enrollment;
import blackboard.admin.data.course.Membership;
import blackboard.admin.persist.course.EnrollmentLoader;
import blackboard.admin.persist.course.impl.MembershipSelectQuery;
import blackboard.admin.persist.course.impl.mapping.EnrollmentLoaderDbMap;
import blackboard.admin.persist.impl.AdminNewBaseDbLoader;
import blackboard.base.BbList;
import blackboard.base.ListFilter;
import blackboard.data.BbObject;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.SelectQuery;
import blackboard.util.FilteredList;
import blackboard.util.StringUtil;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;

public class EnrollmentDbLoader
extends AdminNewBaseDbLoader<Enrollment>
implements EnrollmentLoader {
    @Override
    public Enrollment load(String crsBatchUid, String personBatchUid) throws KeyNotFoundException, PersistenceException {
        MembershipSelectQuery query = new MembershipSelectQuery(EnrollmentLoaderDbMap.MAP);
        query.addWhere("GroupBatchUid", crsBatchUid);
        query.addWhere("PersonBatchUid", personBatchUid);
        return (Enrollment)super.loadObject((SelectQuery)query, null);
    }

    @Override
    public BbList<Enrollment> load(Enrollment template) throws PersistenceException {
        BitSet filterSet = new BitSet(2);
        if (template.getBbAttributes().getBbAttribute("PersonalInfo").getIsDirty()) {
            template.getBbAttributes().getBbAttribute("PersonalInfo").setIsDirty(false);
            filterSet.set(0);
        }
        if (template.getBbAttributes().getBbAttribute("Notes").getIsDirty()) {
            template.getBbAttributes().getBbAttribute("Notes").setIsDirty(false);
            filterSet.set(1);
        }
        if (template.getBbAttributes().getBbAttribute("FavoriteLinks").getIsDirty()) {
            template.getBbAttributes().getBbAttribute("FavoriteLinks").setIsDirty(false);
            filterSet.set(2);
        }
        MembershipSelectQuery query = new MembershipSelectQuery(EnrollmentLoaderDbMap.MAP);
        this.initQuery((SelectQuery)query);
        this.generateWhereClause((BbObject)template, query);
        BbList list = super.loadList((SelectQuery)query, null);
        List result = new FilteredList((List)list, (ListFilter)new MembershipFilter(template, filterSet)).apply();
        return new BbList((Collection)result);
    }

    protected static class MembershipFilter
    extends ListFilter {
        private final Membership _template;
        private final BitSet _filterSet;

        public MembershipFilter(Membership template, BitSet filterSet) {
            this._template = template;
            this._filterSet = filterSet;
        }

        protected boolean passesFilter(Object listElement) {
            Membership obj = (Membership)listElement;
            if (this._filterSet.get(0) && !this.compare(this._template.getPersonalInfo(), obj.getPersonalInfo())) {
                return false;
            }
            if (this._filterSet.get(1) && !this.compare(this._template.getNotes(), obj.getNotes())) {
                return false;
            }
            return !this._filterSet.get(2) || this.compare(this._template.getBbLinkAtPos(1).getName(), obj.getBbLinkAtPos(1).getName()) && this.compare(this._template.getBbLinkAtPos(1).getDescription(), obj.getBbLinkAtPos(1).getDescription()) && this.compare(this._template.getBbLinkAtPos(1).getUrl(), obj.getBbLinkAtPos(1).getUrl()) && this.compare(this._template.getBbLinkAtPos(2).getName(), obj.getBbLinkAtPos(2).getName()) && this.compare(this._template.getBbLinkAtPos(2).getDescription(), obj.getBbLinkAtPos(2).getDescription()) && this.compare(this._template.getBbLinkAtPos(2).getUrl(), obj.getBbLinkAtPos(2).getUrl()) && this.compare(this._template.getBbLinkAtPos(3).getName(), obj.getBbLinkAtPos(3).getName()) && this.compare(this._template.getBbLinkAtPos(3).getDescription(), obj.getBbLinkAtPos(3).getDescription()) && this.compare(this._template.getBbLinkAtPos(3).getUrl(), obj.getBbLinkAtPos(3).getUrl());
        }

        private boolean compare(String template, String obj) {
            if (template == null && obj != null) {
                return false;
            }
            if (template != null && obj == null) {
                return false;
            }
            if (template == null && obj == null) {
                return true;
            }
            template = StringUtil.valueOf((Object)template, (String)"").toLowerCase();
            obj = obj.toLowerCase();
            int idx = template.indexOf("%");
            if (idx == -1) {
                return template.equals(obj);
            }
            idx = obj.indexOf(template);
            return idx != -1;
        }
    }
}

