/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.course.AdminCourse;
import blackboard.admin.data.course.Organization;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.CourseSitePersister;
import blackboard.admin.persist.course.OrganizationPersister;
import blackboard.admin.persist.course.impl.CourseSiteDbPersister;
import blackboard.admin.persist.course.impl.OrganizationDbLoader;
import blackboard.admin.persist.course.impl.mapping.AdminCourseDeleteDbMap;
import blackboard.admin.persist.course.impl.mapping.AdminCourseInsertDbMap;
import blackboard.admin.persist.course.impl.mapping.AdminCoursePersisterDbMap;
import blackboard.admin.persist.impl.AdminInsertProcedureQuery;
import blackboard.admin.persist.impl.AdminRemoveProcedureQuery;
import blackboard.admin.persist.impl.AdminSaveProcedureQuery;
import blackboard.admin.persist.impl.AdminUpdateProcedureQuery;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.SnapshotDbPersister;
import blackboard.base.BbList;
import blackboard.data.BbObject;
import blackboard.data.Identifiable;
import blackboard.data.ImmutableException;
import blackboard.data.ValidationException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Query;
import blackboard.platform.filesystem.FileSystemException;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.ExceptionUtil;
import java.io.IOException;
import java.util.List;

public class OrganizationDbPersister
extends SnapshotDbPersister<Organization>
implements OrganizationPersister {
    String[] CONSTRAINTS = new String[]{"COURSE_MAIN_PK", "COURSE_MAIN_AK1", "COURSE_MAIN_AK2", "COURSE_MAIN_AK3"};
    String[] IMMUTABLE = new String[]{"immutable"};

    @Override
    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        super.checkApiLicensing();
        return super._createSession(dataSourceBatchUid, "org");
    }

    @Override
    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        super.checkApiLicensing();
        super._createSession(dataSourceBatchUid, "org", sessionId);
    }

    @Override
    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        super.checkApiLicensing();
        super.closeSession(strSessionId, "org");
    }

    @Override
    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.save((Organization)obj, strSessionId);
    }

    @Override
    public Results save(List<Organization> objList, String strSessionId) throws PersistenceException {
        this.resolveBatchUid(objList);
        Results res = super.save(AdminCoursePersisterDbMap.PROCESS_INTEGRATION_MAP, objList, strSessionId);
        this.flushCacheById(objList);
        return res;
    }

    @Override
    public Results remove(List<Organization> objList) throws PersistenceException {
        super.checkApiLicensing();
        try {
            OrganizationDbPersister.archiveOrganizationContent(objList);
        }
        catch (Exception exc) {
            LogServiceFactory.getInstance().logWarning("Failure occurred during organization archival", (Throwable)exc);
        }
        Results res = super.remove(AdminCourseDeleteDbMap.MAP, objList);
        this.flushCacheById(objList);
        return res;
    }

    @Override
    public void save(Organization objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        super.checkApiLicensing();
        this.resolveBatchUid(objToSave);
        this.handleAttributeTokens(objToSave);
        objToSave.validate();
        AdminSaveProcedureQuery query = new AdminSaveProcedureQuery(AdminCoursePersisterDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
            this.resolveReplacementBatchUid(objToSave);
            this.flushCacheById((Identifiable)objToSave);
        }
        catch (PersistenceException e) {
            if (ExceptionUtil.isSqlConstraintViolation((Throwable)e, (String[])this.IMMUTABLE)) {
                throw new ImmutableException("Organization id cannot be modified.");
            }
            this._checkForConstraintViolation(e, this.CONSTRAINTS);
        }
    }

    @Override
    public void save(Organization objToSave, String strSessionId) throws PersistenceException, ValidationException {
        super.checkApiLicensing();
        this.resolveBatchUid(objToSave);
        try {
            super.save(AdminCoursePersisterDbMap.PROCESS_INTEGRATION_MAP, objToSave, strSessionId);
            this.flushCacheById((Identifiable)objToSave);
        }
        catch (PersistenceException pe) {
            if (ExceptionUtil.isSqlConstraintViolation((Throwable)pe, (String[])this.IMMUTABLE)) {
                throw new ImmutableException("Organization id cannot be modified.");
            }
            throw pe;
        }
        this.resolveReplacementBatchUid(objToSave);
        this.flushCacheById((Identifiable)objToSave);
    }

    @Override
    public void insert(Organization objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        super.checkApiLicensing();
        objToSave.validate();
        AdminInsertProcedureQuery query = new AdminInsertProcedureQuery(AdminCourseInsertDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
        }
        catch (PersistenceException exc) {
            super._checkForConstraintViolation(exc, this.CONSTRAINTS);
        }
    }

    @Override
    public void update(Organization objToSave) throws PersistenceException, ConstraintViolationException, KeyNotFoundException, ValidationException {
        super.checkApiLicensing();
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminUpdateProcedureQuery query = new AdminUpdateProcedureQuery(AdminCoursePersisterDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
            this.resolveReplacementBatchUid(objToSave);
            this.flushCacheById((Identifiable)objToSave);
        }
        catch (PersistenceException e) {
            if (ExceptionUtil.isSqlConstraintViolation((Throwable)e, (String[])this.IMMUTABLE)) {
                throw new ImmutableException("Organization id cannot be modified.");
            }
            this._checkForConstraintViolation(e, this.CONSTRAINTS);
        }
    }

    private void resolveReplacementBatchUid(Organization objToModify) {
        if (objToModify.getBbAttributes().getBbAttribute("ReplacementBatchUid").getIsDirty()) {
            objToModify.setBatchUid(objToModify.getReplacementBatchUid());
        }
    }

    @Override
    public void remove(Organization objToRemove) throws KeyNotFoundException, PersistenceException {
        super.checkApiLicensing();
        try {
            OrganizationDbPersister.archiveOrganizationContent(objToRemove);
        }
        catch (Exception exc) {
            LogServiceFactory.getInstance().logWarning("Failure occurred during organization archival", (Throwable)exc);
        }
        AdminRemoveProcedureQuery query = new AdminRemoveProcedureQuery(AdminCourseDeleteDbMap.MAP, (BbObject)objToRemove);
        super.runQuery((Query)query, null);
        this.flushCacheById((Identifiable)objToRemove);
    }

    @Override
    public void changeKey(Organization objToSave, String newKey) throws PersistenceException, ValidationException, ConstraintViolationException, KeyNotFoundException {
        super.checkApiLicensing();
        objToSave.setReplacementBatchUid(newKey);
        try {
            this.update(objToSave);
        }
        catch (PersistenceException e) {
            this._checkForConstraintViolation(e, this.CONSTRAINTS);
        }
    }

    @Override
    public void clone(String srcOrgBatchUid, String tgtOrgBatchUid, CloneConfig cfg) throws PersistenceException, KeyNotFoundException {
        CourseSitePersister csp = CourseSitePersister.Default.getInstance();
        try {
            csp.clone(srcOrgBatchUid, tgtOrgBatchUid, cfg);
        }
        catch (ConstraintViolationException e) {
            throw new PersistenceException((Throwable)e);
        }
        catch (ValidationException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    protected static void archiveOrganizationContent(List list) throws PersistenceException, IOException, FileSystemException {
        CourseSiteDbPersister.archiveCourseContent(list);
    }

    protected static void archiveOrganizationContent(AdminCourse crs) throws PersistenceException, IOException, FileSystemException {
        CourseSiteDbPersister.archiveCourseContent(crs);
    }

    private void resolveBatchUid(Organization objInput) throws PersistenceException {
        if (objInput.getBbAttributes().getBbAttribute("BatchUid").getIsDirty() || !this._pm.isValidId(objInput.getId())) {
            return;
        }
        OrganizationDbLoader loader = (OrganizationDbLoader)this._pm.getLoader("OrganizationLoader");
        Organization obj = new Organization();
        obj.setId(objInput.getId());
        BbList<Organization> list = loader.load(obj);
        Organization Organization2 = this.getSingleItem(list, obj);
        objInput.setBatchUid(Organization2.getBatchUid());
    }

    private void resolveBatchUid(List<Organization> list) throws PersistenceException {
        for (Organization obj : list) {
            this.resolveBatchUid(obj);
        }
    }
}

