/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.course.OrganizationMembership;
import blackboard.admin.persist.course.OrganizationMembershipPersister;
import blackboard.admin.persist.course.impl.OrganizationMembershipDbLoader;
import blackboard.admin.persist.course.impl.mapping.MembershipDeleteDbMap;
import blackboard.admin.persist.course.impl.mapping.OrganizationMembershipDbMap;
import blackboard.admin.persist.course.impl.mapping.OrganizationMembershipInsertDbMap;
import blackboard.admin.persist.impl.AdminInsertProcedureQuery;
import blackboard.admin.persist.impl.AdminRemoveProcedureQuery;
import blackboard.admin.persist.impl.AdminSaveProcedureQuery;
import blackboard.admin.persist.impl.AdminUpdateProcedureQuery;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.SnapshotDbPersister;
import blackboard.base.BbList;
import blackboard.data.BbObject;
import blackboard.data.ValidationException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Query;
import java.util.List;

public class OrganizationMembershipDbPersister
extends SnapshotDbPersister<OrganizationMembership>
implements OrganizationMembershipPersister {
    String[] CONSTRAINTS = new String[]{"COURSE_USERS_PK", "COURSE_USERS_AK1"};

    @Override
    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        return super._createSession(dataSourceBatchUid, "ou");
    }

    @Override
    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        super._createSession(dataSourceBatchUid, "ou", sessionId);
    }

    @Override
    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        super.closeSession(strSessionId, "ou");
    }

    @Override
    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.resolveBatchUid((OrganizationMembership)obj);
        super.save(OrganizationMembershipDbMap.MAP, obj, strSessionId);
    }

    @Override
    public Results save(List<OrganizationMembership> objList, String strSessionId) throws PersistenceException {
        this.resolveBatchUid(objList);
        Results results = super.save(OrganizationMembershipDbMap.MAP, objList, strSessionId);
        if (results.getErrorCount() == 0) {
            this.sendPostEnrollmentEvents(objList);
        }
        return results;
    }

    @Override
    public Results remove(List<OrganizationMembership> objList) throws PersistenceException {
        return super.remove(MembershipDeleteDbMap.MAP, objList);
    }

    @Override
    public void save(OrganizationMembership objToSave) throws PersistenceException, ValidationException {
        this.resolveBatchUid(objToSave);
        this.handleAttributeTokens(objToSave);
        objToSave.validate();
        AdminSaveProcedureQuery query = new AdminSaveProcedureQuery(OrganizationMembershipDbMap.MAP, (BbObject)objToSave);
        super.runQuery((Query)query, null);
    }

    @Override
    public void save(OrganizationMembership objToSave, String strSessionId) throws PersistenceException, ValidationException {
        this.resolveBatchUid(objToSave);
        super.save(OrganizationMembershipDbMap.MAP, objToSave, strSessionId);
    }

    @Override
    public void insert(OrganizationMembership objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        objToSave.validate();
        AdminInsertProcedureQuery query = new AdminInsertProcedureQuery(OrganizationMembershipInsertDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
        }
        catch (PersistenceException exc) {
            super._checkForConstraintViolation(exc, this.CONSTRAINTS);
        }
    }

    @Override
    public void update(OrganizationMembership objToSave) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminUpdateProcedureQuery query = new AdminUpdateProcedureQuery(OrganizationMembershipDbMap.MAP, (BbObject)objToSave);
        super.runQuery((Query)query, null);
    }

    @Override
    public void remove(OrganizationMembership objToRemove) throws KeyNotFoundException, PersistenceException {
        AdminRemoveProcedureQuery query = new AdminRemoveProcedureQuery(MembershipDeleteDbMap.MAP, (BbObject)objToRemove);
        super.runQuery((Query)query, null);
    }

    private void resolveBatchUid(OrganizationMembership objInput) throws PersistenceException {
        if (objInput.getBbAttributes().getBbAttribute("PersonBatchUid").getIsDirty() && objInput.getBbAttributes().getBbAttribute("GroupBatchUid").getIsDirty() || !this._pm.isValidId(objInput.getId())) {
            return;
        }
        OrganizationMembershipDbLoader loader = (OrganizationMembershipDbLoader)this._pm.getLoader("OrganizationMembershipLoader");
        OrganizationMembership obj = new OrganizationMembership();
        obj.setId(objInput.getId());
        BbList<OrganizationMembership> list = loader.load(obj);
        OrganizationMembership OrganizationMembership2 = this.getSingleItem(list, obj);
        objInput.setOrganizationBatchUid(OrganizationMembership2.getOrganizationBatchUid());
        objInput.setPersonBatchUid(OrganizationMembership2.getPersonBatchUid());
    }

    private void resolveBatchUid(List<OrganizationMembership> list) throws PersistenceException {
        for (OrganizationMembership obj : list) {
            this.resolveBatchUid(obj);
        }
    }
}

