/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl;

import blackboard.admin.persist.course.CourseEventListener;
import blackboard.data.course.Course;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.platform.extension.service.ExtensionRegistryFactory;
import blackboard.platform.log.LogServiceFactory;
import blackboard.platform.queue.BaseQueuedOperation;
import blackboard.platform.queue.data.QueueTask;
import blackboard.util.BundleUtil;
import blackboard.util.ExceptionUtil;
import blackboard.util.StringUtil;
import java.util.Collection;

public class PostCourseCreateOperation
extends BaseQueuedOperation {
    public boolean isEmailEnabled() {
        return false;
    }

    public String getTypeCode() {
        return "N";
    }

    public String getDisplayName() {
        return BundleUtil.getMessage((String)"platform", (String)"platform.queuetask.type.course-create");
    }

    public String execute() {
        String results = "create.msg.post.operation.successful";
        try {
            Id courseId = Id.generateId((DataType)Course.DATA_TYPE, (String)this._task.getArguments());
            if (StringUtil.isEmpty((String)this._task.getArguments())) {
                LogServiceFactory.getInstance().logWarning("Course id was empty: " + courseId, (Throwable)new InstantiationException());
            }
            Collection listeners = ExtensionRegistryFactory.getInstance().getExtensions("blackboard.cmsadmin.postCreateCourseEventListener");
            for (CourseEventListener listener : listeners) {
                try {
                    listener.courseCreated(courseId);
                }
                catch (Throwable t) {
                    LogServiceFactory.getInstance().logError("Error processing event handler", t);
                    results = "create.msg.post.operation.error";
                    ExceptionUtil.checkForThreadDeath((Throwable)t);
                }
            }
            this._status = QueueTask.Status.COMPLETE;
        }
        catch (Throwable e) {
            LogServiceFactory.getInstance().logError("An error occurred during event processing " + this._task);
            this._status = QueueTask.Status.COMPLETE_ERRORS;
            ExceptionUtil.checkForThreadDeath((Throwable)e);
        }
        return "copy|" + results;
    }
}

