/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone;

import blackboard.admin.persist.course.CloneConfig;
import blackboard.data.navigation.CourseToc;
import blackboard.data.user.User;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.persist.navigation.CourseTocDbLoader;
import blackboard.platform.context.ContextManagerFactory;
import blackboard.platform.cx.component.CxComponent;
import blackboard.platform.cx.component.CxComponentFactory;
import blackboard.platform.intl.BbResourceBundle;
import blackboard.platform.intl.BundleManagerFactory;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.CollectionUtils;
import blackboard.util.PlatformUtil;
import blackboard.util.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class CloneConfigReport {
    private CloneConfig _cloneConfig;
    private StringBuilder _report;
    private BbResourceBundle _copyBundle;
    private static final String TAB = "\t";

    public CloneConfigReport(CloneConfig cloneConfig) {
        this._cloneConfig = cloneConfig;
        this._report = new StringBuilder();
        this._copyBundle = BundleManagerFactory.getInstance().getBundle("copy");
    }

    public void log() {
        this._report.append("Course Copy Configuration:");
        this.logUserRunningCopy();
        this.logCopyOrigin();
        this.logCopyType();
        this.logCopiedMaterialsAndEnrollments();
        this.logCopiedCourseContentAreas();
        this.logCopiedCourseFiles();
        this._report.append(PlatformUtil.EOL());
        this._report.append(PlatformUtil.EOL());
        LogServiceFactory.getInstance().logInfo(this._report.toString());
    }

    private void logUserRunningCopy() {
        StringBuilder userInfo = new StringBuilder();
        userInfo.append(this.formatLineItem("User running copy: " + this.getUserRunningCopy()));
        this.appendTabbedLineItem(userInfo.toString());
    }

    private String getUserRunningCopy() {
        String userName = this._cloneConfig.getLoggedOnUser();
        if (StringUtil.isEmpty((String)userName)) {
            userName = this.getUserFromContext();
        }
        userName = userName == null ? "" : "[" + userName + "]";
        return userName;
    }

    private String getUserFromContext() {
        String userName = null;
        User user = ContextManagerFactory.getInstance().getContext().getUser();
        if (user != null) {
            userName = user.getUserName();
        }
        return userName;
    }

    private void logCopiedCourseFiles() {
        StringBuilder courseFilesInfo = new StringBuilder();
        courseFilesInfo.append(this.formatLineItem("Course Files"));
        boolean copyCourseFiles = this._cloneConfig.shouldCopyAnyCSItems();
        if (copyCourseFiles) {
            courseFilesInfo.append(this.formatedNestedLineItem("Copy Course Files to target Course"));
            Set<String> folderIds = this._cloneConfig.getExcludedCsFolderIds();
            if (CollectionUtils.notEmpty(folderIds)) {
                courseFilesInfo.append(this.formatedNestedLineItem("\tThe Ids of the following folders are to be excluded = " + folderIds.toString()));
            }
        } else {
            courseFilesInfo.append(this.formatedNestedLineItem("Copy links to Course Files in source Course"));
        }
        if (copyCourseFiles) {
            courseFilesInfo.append(this.formatedNestedLineItem("Target Course Files Folder = " + this._cloneConfig.getCsDir()));
        }
        this.appendTabbedLineItem(courseFilesInfo.toString());
    }

    private void logCopiedCourseContentAreas() {
        StringBuilder copiedContentAreas = new StringBuilder();
        copiedContentAreas.append(this.formatLineItem("Content Areas"));
        List<String> courseTocIdList = this._cloneConfig.getCourseTocIdList();
        if (CollectionUtils.isEmpty(courseTocIdList)) {
            copiedContentAreas.append(this.formatedNestedLineItem("None to copy"));
        } else {
            for (String courseTocId : courseTocIdList) {
                if (!StringUtil.notEmpty((String)courseTocId)) continue;
                try {
                    CourseToc courseToc = CourseTocDbLoader.Default.getInstance().loadById(Id.generateId((DataType)CourseToc.DATA_TYPE, (String)courseTocId));
                    copiedContentAreas.append(this.formatedNestedLineItem(courseToc.getLabel()));
                }
                catch (Exception e) {
                    LogServiceFactory.getInstance().getDefaultLog().logError("Failed to log courseTocId " + courseTocId + " for copy log", (Throwable)e);
                }
            }
        }
        this.appendTabbedLineItem(copiedContentAreas.toString());
    }

    public void logCopiedMaterialsAndEnrollments() {
        if (this._cloneConfig.getCopyType() == CloneConfig.CopyType.COPY_EXACT_COURSE) {
            return;
        }
        StringBuilder areasToCopy = new StringBuilder();
        areasToCopy.append(this.formatLineItem("Course Areas"));
        CloneConfig.Area[] areas = CloneConfig.Area.getValues();
        StringBuilder areasSelected = new StringBuilder();
        for (CloneConfig.Area area : areas) {
            if (!this._cloneConfig.isAreaIncluded(area)) continue;
            String displayValue = null;
            if (area.hasDisplayKey()) {
                displayValue = this._copyBundle.getString(area.getDisplayKey());
            }
            if (!StringUtil.notEmpty(displayValue)) continue;
            areasSelected.append(this.formatedNestedLineItem(displayValue));
        }
        Collection cxComponents = CxComponentFactory.getCxComponents();
        for (CxComponent cxComponent : cxComponents) {
            if (!this._cloneConfig.isCxComponentIncluded(cxComponent.getComponentHandle()) && cxComponent.getUsage() != CxComponent.Usage.ALWAYS) continue;
            areasSelected.append(this.formatedNestedLineItem(cxComponent.getName()));
        }
        if (StringUtil.isEmpty((StringBuilder)areasSelected)) {
            areasSelected.append(this.formatedNestedLineItem("No areas to copy"));
        }
        areasToCopy.append((CharSequence)areasSelected);
        this.appendTabbedLineItem(areasToCopy.toString());
    }

    public void logCopyOrigin() {
        StringBuilder copyOrigin = new StringBuilder();
        copyOrigin.append("Copy initiated from ");
        if (this._cloneConfig.getIsCommandLineRequest()) {
            copyOrigin.append("[Command Line]");
        } else if (this._cloneConfig.isFromAdminPanel()) {
            copyOrigin.append("[Administrator Panel]");
        } else {
            copyOrigin.append("[Control Panel]");
        }
        this.appendTabbedLineItem(copyOrigin.toString());
    }

    public void logCopyType() {
        StringBuilder copyTypeLog = new StringBuilder();
        copyTypeLog.append("Copy Type = ");
        CloneConfig.CopyType copyType = this._cloneConfig.getCopyType();
        if (copyType == CloneConfig.CopyType.COPY_EXACT_COURSE) {
            copyTypeLog.append("[Exact]");
        } else if (copyType == CloneConfig.CopyType.COPY_EXISTING_COURSE) {
            copyTypeLog.append("[Existing]");
        } else if (copyType == CloneConfig.CopyType.COPY_NEW_COURSE) {
            copyTypeLog.append("[New]");
        } else {
            copyTypeLog.append("[Not Specified]");
        }
        this.appendTabbedLineItem(copyTypeLog.toString());
    }

    public void appendTabbedLineItem(String lineItem) {
        this._report.append(this.formatLineItem(lineItem));
    }

    private String formatLineItem(String lineItem) {
        return PlatformUtil.EOL() + TAB + lineItem;
    }

    private String formatedNestedLineItem(String lineItem) {
        return PlatformUtil.EOL() + TAB + TAB + lineItem;
    }
}

