/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone;

import blackboard.admin.cxutil.CSFileCopyHandler;
import blackboard.admin.cxutil.CSFileCopyHandlerFactory;
import blackboard.admin.cxutil.CSResource;
import blackboard.admin.cxutil.CSResourceStatusMap;
import blackboard.admin.cxutil.CSResultSet;
import blackboard.admin.cxutil.CourseContentCopyUtil;
import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.AdminCourseCloneOperator;
import blackboard.admin.persist.course.impl.clone.StageReport;
import blackboard.base.AppVersion;
import blackboard.base.InitializationException;
import blackboard.data.course.Course;
import blackboard.db.BbDatabase;
import blackboard.db.ConnectionNotAvailableException;
import blackboard.db.DbUtil;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.DataType;
import blackboard.persist.DatabaseContainer;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Bb5Util;
import blackboard.persist.impl.StoredProcedureQuery;
import blackboard.platform.contentsystem.data.Resource;
import blackboard.platform.contentsystem.data.ResourceFolder;
import blackboard.platform.contentsystem.manager.PrivateDocumentManager;
import blackboard.platform.contentsystem.service.ContentSystemServiceExFactory;
import blackboard.platform.filesystem.LocationUtil;
import blackboard.platform.log.LogService;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.FileUtil;
import blackboard.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class CloneOperator {
    public static final String SOS_PK2 = "1";
    public static final String XYTHOS_ID_MAP = "XYTHOS_DATAVALUES";
    public static final String COURSE_CONTENTS_ID_MAP = "COURSE_CONTENTS";
    public static final String FILES_ID_MAP = "FILES";
    public static final String FORUM_ID_MAP = "FORUM_MAIN";
    public static final String BLOG_ID_MAP = "BLOGS";
    public static final String TAB_ID_MAP = "TAB";
    public static final String STAFFINFO_ID_MAP = "STAFFINFORMATION";
    public static final String ASSESSMENT_ID_MAP = "QTI_ASI_DATA";
    protected final BbPersistenceManager _pm;
    protected final AppVersion _appVersion;
    protected final BbDatabase _bbDatabase;
    protected final Map<String, Map<String, String>> _dbBasedIdMap;
    protected final boolean _bDebug;
    protected final CSResourceStatusMap _csLinkStatusMap;
    protected Course _srcSite;
    protected Course _tgtSite;
    protected CloneConfig _cfg;
    private CloneCallback _callback;
    protected String _sessionId;
    private boolean _inGoodState;

    public CloneOperator(AdminCourseCloneOperator parentOperator) {
        this(parentOperator._pm, parentOperator._appVersion, parentOperator._dbBasedIdMap, parentOperator._csLinkStatusMap);
    }

    public CloneOperator(BbPersistenceManager pm, AppVersion appVersion, Map<String, Map<String, String>> dbBasedIdMap, CSResourceStatusMap csLinkStatusMap) {
        this._pm = pm;
        this._appVersion = appVersion;
        this._bbDatabase = ((DatabaseContainer)pm.getContainer()).getBbDatabase();
        this._dbBasedIdMap = dbBasedIdMap;
        this._bDebug = LogServiceFactory.getInstance().getVerbosityLevel() == LogService.Verbosity.DEBUG;
        this._csLinkStatusMap = csLinkStatusMap;
    }

    protected void init(Course src, Course tgt, String sessionId, CloneConfig cfg) {
        this._srcSite = src;
        this._tgtSite = tgt;
        this._sessionId = sessionId;
        this._cfg = cfg;
        this._callback = cfg.getCallback();
        this._inGoodState = true;
    }

    public CloneConfig getCloneConfig() {
        return this._cfg;
    }

    public Course getSourceCourse() {
        return this._srcSite;
    }

    public Course getTargetCourse() {
        return this._tgtSite;
    }

    public String getSessionId() {
        return this._sessionId;
    }

    public abstract void doDatabaseTranslation() throws Exception;

    public abstract void doEmbeddedDatabaseIdTranslation() throws Exception;

    public String getDirectoryTranslation(String dir, String tableId) {
        Map<String, String> tmp = this.getDbBasedIdMap(tableId);
        return CourseContentCopyUtil.resolveTextBasedMapping(tmp, dir);
    }

    public abstract String getDirectoryTranslation(String var1);

    public abstract void doContentDirectoryTranslation() throws Exception;

    protected void doCallbackSegment(CloneCallback.Stage stage, String msg, long interval) {
        LogServiceFactory.getInstance().logDebug(StageReport.logStage(stage, msg, interval));
        if (this._callback == null) {
            return;
        }
        this._callback.callback(stage, msg, interval);
    }

    protected void executeCloneProcedure(String procedureName, int commitFrequency) throws SQLException, ConnectionNotAvailableException {
        CallableStatement stmt = null;
        Connection con = null;
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = CloneQuery.getCloneQuery(procedureName, con);
            CloneQuery.marshallParams(this._srcSite, this._tgtSite, this._sessionId, commitFrequency, stmt);
            stmt.execute();
        }
        catch (SQLException sqe) {
            try {
                LogServiceFactory.getInstance().logFatal("Stored Procedure " + procedureName + " failed execution", (Throwable)sqe);
                throw sqe;
            }
            catch (Throwable throwable) {
                DbUtil.close(stmt);
                this._bbDatabase.getConnectionManager().releaseConnection(con);
                throw throwable;
            }
        }
        DbUtil.close((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    protected void executeCloneProcedureForGb(String procedureName, int commitFrequency, Boolean bVal) throws SQLException, ConnectionNotAvailableException {
        CallableStatement stmt = null;
        Connection con = null;
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = CloneQuery.getCloneQuery(procedureName, con, bVal);
            CloneQuery.marshallParams(this._srcSite, this._tgtSite, this._sessionId, commitFrequency, stmt, bVal);
            stmt.execute();
        }
        catch (SQLException sqe) {
            try {
                LogServiceFactory.getInstance().logError("GB Stored Procedure " + procedureName + " failed execution", (Throwable)sqe);
                throw sqe;
            }
            catch (Throwable throwable) {
                DbUtil.close(stmt);
                this._bbDatabase.getConnectionManager().releaseConnection(con);
                throw throwable;
            }
        }
        DbUtil.close((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    protected void executeCloneProcedureForCrsToolRec(String procedureName, int commitFrequency) throws SQLException, ConnectionNotAvailableException {
        CallableStatement stmt = null;
        Connection con = null;
        try {
            String courseType = this._srcSite.isOrganization() ? "O" : "C";
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = CloneQuery.getCloneQuery(procedureName, con);
            CloneQuery.marshallParams(courseType, this._srcSite, this._tgtSite, commitFrequency, stmt);
            stmt.execute();
        }
        catch (SQLException sqe) {
            try {
                LogServiceFactory.getInstance().logFatal("Stored Procedure " + procedureName + " failed execution", (Throwable)sqe);
                throw sqe;
            }
            catch (Throwable throwable) {
                DbUtil.close(stmt);
                this._bbDatabase.getConnectionManager().releaseConnection(con);
                throw throwable;
            }
        }
        DbUtil.close((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    protected void executeCloneProcedure(String procedureName, int commitFrequency, String withProtectedCartridge) throws SQLException, ConnectionNotAvailableException {
        CallableStatement stmt = null;
        Connection con = null;
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            stmt = CloneQuery.getCloneQuery(procedureName, con, withProtectedCartridge);
            CloneQuery.marshallParams(this._srcSite, this._tgtSite, this._sessionId, commitFrequency, stmt, withProtectedCartridge);
            stmt.execute();
        }
        catch (SQLException sqe) {
            try {
                LogServiceFactory.getInstance().logError("Stored Procedure " + procedureName + " failed execution", (Throwable)sqe);
                throw sqe;
            }
            catch (Throwable throwable) {
                DbUtil.close(stmt);
                this._bbDatabase.getConnectionManager().releaseConnection(con);
                throw throwable;
            }
        }
        DbUtil.close((Statement)stmt);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    protected void doDirectoryPathTranslation(String strDirectory) throws Exception {
        File sourceDir = new File(strDirectory);
        if (sourceDir.exists()) {
            this.doLocalDirectoryPathTranslation(strDirectory);
        }
        this.doPrivateDirectoryPathTranslation(strDirectory);
    }

    protected void doLocalDirectoryPathTranslation(String strDirectory) throws Exception {
        File sourceDir = new File(strDirectory);
        String[] straAllFiles = FileUtil.getDirectoryListing((File)sourceDir);
        if (straAllFiles == null || straAllFiles.length == 0) {
            return;
        }
        for (int i = 0; i < straAllFiles.length; ++i) {
            File dir;
            if (!this.existsInTarget(straAllFiles[i]) || !(dir = new File(straAllFiles[i])).isDirectory()) continue;
            String strDestinationDir = this.getDirectoryTranslation(dir.getPath());
            FileUtil.moveDirectory((File)dir, (File)new File(strDestinationDir));
        }
    }

    protected void doPrivateDirectoryPathTranslation(String strDirectory) {
        File sourceDir = new File(strDirectory);
        String link = LocationUtil.getRelativeLink((String)this._tgtSite.getCourseId(), (File)sourceDir);
        PrivateDocumentManager pMgr = ContentSystemServiceExFactory.getInstance().getPrivateDocumentManager();
        ResourceFolder folder = null;
        List strAllFiles = null;
        try {
            folder = pMgr.loadFolder(this._tgtSite, link);
            strAllFiles = folder.getDirectoryListing();
        }
        catch (KeyNotFoundException knf) {
            return;
        }
        catch (PersistenceException pe) {
            LogServiceFactory.getInstance().logDebug("Failed loading resource listing.", (Throwable)pe);
        }
        if (strAllFiles == null || strAllFiles.isEmpty()) {
            return;
        }
        for (String strResource : strAllFiles) {
            link = LocationUtil.getRelativeLink((String)this._tgtSite.getCourseId(), (File)new File(strResource));
            try {
                Resource resource = pMgr.loadResource(this._tgtSite, link);
                if (resource.getType() == Resource.Type.FILE) continue;
                String strDestinationDir = this.getDirectoryTranslation(strResource);
                if (StringUtil.isEqual((String)strDestinationDir, (String)strResource)) {
                    this.handleContentNotTranslated(strDestinationDir);
                    continue;
                }
                pMgr.moveResources(this._tgtSite, LocationUtil.getRelativeLink((String)this._tgtSite.getCourseId(), (File)new File(strResource)), LocationUtil.getRelativeLink((String)this._tgtSite.getCourseId(), (File)new File(strDestinationDir)));
            }
            catch (Exception exc) {
                LogServiceFactory.getInstance().logWarning("Could not move resource:" + link, (Throwable)exc);
            }
        }
    }

    protected void handleContentNotTranslated(String strDestinationDir) {
    }

    protected boolean existsInTarget(String strPath) {
        String origPath = StringUtil.replace((String)strPath, (String)this._tgtSite.getCourseId(), (String)this._srcSite.getCourseId());
        File origFile = new File(origPath);
        return origFile.exists();
    }

    protected static void copyCourseGlossaryAndSettings(File in, File out, CloneConfig cfg) throws IOException, InitializationException {
        if (!in.exists()) {
            return;
        }
        if (!out.exists() && !out.mkdirs()) {
            throw new IOException("Could not create folders :" + out.getAbsolutePath());
        }
        String[] fileList = in.list();
        if (fileList.length == 0) {
            return;
        }
        for (String element : fileList) {
            File srcFile = new File(in, element);
            if (!srcFile.exists() || srcFile.isDirectory()) continue;
            if (element.equalsIgnoreCase("glossary.properties")) {
                if (!cfg.isAreaIncluded(CloneConfig.Area.GLOSSARY)) continue;
                Properties tgt = new Properties();
                File tgtFile = new File(out, element);
                FileUtil.createNewFile((File)tgtFile, (boolean)true);
                FileUtil.addPropertiesFromFile((Properties)tgt, (File)tgtFile, (boolean)true);
                FileUtil.addPropertiesFromFile((Properties)tgt, (File)srcFile, (boolean)true);
                FileUtil.writePropertyFile((File)tgtFile, (Properties)tgt);
                continue;
            }
            if (!cfg.isAreaIncluded(CloneConfig.Area.SETTING)) continue;
            FileUtil.copyFile((File)srcFile, (File)new File(out, element));
        }
    }

    protected String getSqlForSelectList(String selectClause, Collection<String> idList, String whereClauseKeyword, String idColumnName) {
        String strSql = null;
        if (idList != null && !idList.isEmpty()) {
            StringBuilder sql = new StringBuilder();
            sql.append(selectClause);
            String keyWord = StringUtil.isEmpty((String)whereClauseKeyword) ? " where " : whereClauseKeyword;
            String idColumn = StringUtil.isEmpty((String)idColumnName) ? " pk1 " : idColumnName;
            sql.append(keyWord + idColumn + " in ( ");
            for (int i = 0; i < idList.size(); ++i) {
                sql.append("?, ");
            }
            sql.replace(sql.lastIndexOf(","), sql.lastIndexOf(",") + 1, ")");
            strSql = sql.toString();
        }
        return strSql;
    }

    protected List<PreparedStatement> prepareStatement(String selectClause, Collection<String> idList, DataType datatype, Connection con, CloneConfig config) throws PersistenceException, SQLException {
        return this.prepareStatement(selectClause, idList, datatype, con, config, null, null);
    }

    protected List<PreparedStatement> prepareStatement(String selectClause, Collection<String> idList, DataType datatype, Connection con, CloneConfig config, String whereClauseKeyword, String idColumnName) throws PersistenceException, SQLException {
        int transactionCount = config.getMaximumTransactionCount();
        int inExpressionParameterLimit = this._bbDatabase.getType().getDML().getDefaultInExpressionParameterLimit();
        transactionCount = config.getMaximumTransactionCount() <= inExpressionParameterLimit ? config.getMaximumTransactionCount() : inExpressionParameterLimit;
        ArrayList<PreparedStatement> stmtList = new ArrayList<PreparedStatement>();
        if (idList != null && !idList.isEmpty()) {
            ArrayList<String> allIdList = new ArrayList<String>(idList);
            int startIndex = 0;
            while (startIndex < allIdList.size()) {
                int endIndex = startIndex + transactionCount <= allIdList.size() ? startIndex + transactionCount : allIdList.size();
                List<String> currentIdList = allIdList.subList(startIndex, endIndex);
                String sql = this.getSqlForSelectList(selectClause, currentIdList, whereClauseKeyword, idColumnName);
                PreparedStatement stmt = con.prepareStatement(sql);
                int bindIndex = 1;
                for (String strId : currentIdList) {
                    Id id = Id.generateId((DataType)datatype, (String)strId);
                    Bb5Util.setId((PreparedStatement)stmt, (int)bindIndex++, (Id)id);
                }
                stmtList.add(stmt);
                startIndex = endIndex;
            }
        }
        return stmtList;
    }

    public void addCsLinkStatus(CSResultSet resultSet) {
        if (this._csLinkStatusMap != null && resultSet != null && resultSet.hasLinkStatusData()) {
            this._csLinkStatusMap.addCsLinkStatus(resultSet);
        }
    }

    public List<CSResource> getCsLinkStatusList(CSResource.CSStatus status) {
        if (null == this._csLinkStatusMap) {
            return null;
        }
        return this._csLinkStatusMap.getCsLinkStatusList(status);
    }

    public Map<String, String> getDbBasedIdMap(String tableName) {
        Map<String, String> map = this._dbBasedIdMap.get(tableName);
        if (null == map) {
            map = new HashMap<String, String>();
            this._dbBasedIdMap.put(tableName, map);
        }
        return map;
    }

    public String parseVTBEText(String vtbeStr, CSResultSet resultSet) throws Exception {
        CSFileCopyHandler csFileHandler = CSFileCopyHandlerFactory.getInstance();
        return csFileHandler.parseVTBEText(vtbeStr, this._cfg.getSrcHomeDir(), this._cfg.getCsDir(), this._tgtSite, this._srcSite, this._cfg.shouldCopyCSItemByArea(), this.getDbBasedIdMap(XYTHOS_ID_MAP), resultSet, true, this._cfg.isFromAdminPanel(), this._cfg.getExcludedCsFolderIds());
    }

    protected void saveNewKey(String tableName, Id oldId, Id newId) throws Exception {
        if (this._sessionId == null) {
            return;
        }
        SaveNewKeyQuery qry = new SaveNewKeyQuery(tableName, oldId, newId);
        qry.run();
    }

    public boolean isInGoodState() {
        return this._inGoodState;
    }

    public void setInGoodState(boolean inGoodState) {
        this._inGoodState = inGoodState;
    }

    private class SaveNewKeyQuery
    extends StoredProcedureQuery {
        private final String _tableName;
        private final Id _oldId;
        private final Id _newId;

        public SaveNewKeyQuery(String tableName, Id oldId, Id newId) {
            super("save_new_key");
            this._tableName = tableName;
            this._oldId = oldId;
            this._newId = newId;
            this.addInputParameter("p_table_name");
            this.addInputParameter("p_old_pk1");
            this.addInputParameter("p_session_id");
            this.addInputParameter("p_new_pk1");
        }

        protected void marshallParams(CallableStatement stmt) throws SQLException {
            DbUtil.setString((PreparedStatement)stmt, (int)this.getColumnPosition("p_table_name"), (String)this._tableName);
            Bb5Util.setId((PreparedStatement)stmt, (int)this.getColumnPosition("p_old_pk1"), (Id)this._oldId);
            DbUtil.setString((PreparedStatement)stmt, (int)this.getColumnPosition("p_session_id"), (String)CloneOperator.this._sessionId);
            Bb5Util.setId((PreparedStatement)stmt, (int)this.getColumnPosition("p_new_pk1"), (Id)this._newId);
        }
    }

    static class CloneQuery {
        CloneQuery() {
        }

        public static CallableStatement getCloneQuery(String procedureName, Connection con) throws SQLException {
            StringBuilder sqlStmt = new StringBuilder();
            sqlStmt.append("{ call " + procedureName);
            sqlStmt.append(" ( ?, ?, ?, ? ) } ");
            return con.prepareCall(sqlStmt.toString());
        }

        public static CallableStatement getCloneQuery(String procedureName, Connection con, String withProtectedCartridge) throws SQLException {
            StringBuilder sqlStmt = new StringBuilder();
            sqlStmt.append("{ call " + procedureName);
            sqlStmt.append(" ( ?, ?, ?, ?, ? ) } ");
            return con.prepareCall(sqlStmt.toString());
        }

        public static CallableStatement getCloneQuery(String procedureName, Connection con, boolean bVal) throws SQLException {
            StringBuilder sqlStmt = new StringBuilder();
            sqlStmt.append("{ call " + procedureName);
            sqlStmt.append(" ( ?, ?, ?, ?, ? ) } ");
            return con.prepareCall(sqlStmt.toString());
        }

        public static void marshallParams(Course srcCourse, Course tgtCourse, String sessionId, int commitFrequency, CallableStatement stmt) throws SQLException {
            Bb5Util.setId((PreparedStatement)stmt, (int)1, (Id)srcCourse.getId());
            Bb5Util.setId((PreparedStatement)stmt, (int)2, (Id)tgtCourse.getId());
            stmt.setInt(3, commitFrequency);
            stmt.setString(4, sessionId);
        }

        public static void marshallParams(String courseType, Course srcCourse, Course tgtCourse, int commitFrequency, CallableStatement stmt) throws SQLException {
            stmt.setString(1, courseType);
            Bb5Util.setId((PreparedStatement)stmt, (int)2, (Id)srcCourse.getId());
            Bb5Util.setId((PreparedStatement)stmt, (int)3, (Id)tgtCourse.getId());
            stmt.setInt(4, commitFrequency);
        }

        public static void marshallParams(Course srcCourse, Course tgtCourse, String sessionId, int commitFrequency, CallableStatement stmt, String withProtectedCartridge) throws SQLException {
            Bb5Util.setId((PreparedStatement)stmt, (int)1, (Id)srcCourse.getId());
            Bb5Util.setId((PreparedStatement)stmt, (int)2, (Id)tgtCourse.getId());
            stmt.setInt(3, commitFrequency);
            stmt.setString(4, sessionId);
            stmt.setString(5, withProtectedCartridge);
        }

        public static void marshallParams(Course srcCourse, Course tgtCourse, String sessionId, int commitFrequency, CallableStatement stmt, boolean bVal) throws SQLException {
            Bb5Util.setId((PreparedStatement)stmt, (int)1, (Id)srcCourse.getId());
            Bb5Util.setId((PreparedStatement)stmt, (int)2, (Id)tgtCourse.getId());
            stmt.setInt(3, commitFrequency);
            stmt.setString(4, sessionId);
            stmt.setString(5, bVal ? "Y" : "N");
        }
    }
}

