/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone;

import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.CourseCopyLogFileSpecifications;
import blackboard.admin.persist.course.impl.clone.CloneConfigReport;
import blackboard.data.course.Course;
import blackboard.platform.BbServiceException;
import blackboard.platform.intl.BbResourceBundle;
import blackboard.platform.intl.BundleManagerFactory;
import blackboard.platform.log.Log;
import blackboard.platform.log.LogService;
import blackboard.platform.log.LogServiceFactory;
import blackboard.platform.log.impl.BaseLogger;
import blackboard.platform.log.impl.FlushableLog;
import blackboard.util.ExceptionUtil;
import blackboard.util.FileUtilEx;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CourseCopyLogger
extends BaseLogger
implements Serializable {
    private static final long serialVersionUID = -5880367436495202230L;
    private List<Log> _registeredLogs;
    private BbResourceBundle _copyBundle;
    private boolean _bHaveCleanedUp;
    private Log _defaultLog = LogServiceFactory.getInstance().getDefaultLog();
    private boolean _open = true;

    public CourseCopyLogger(String logFileName) {
        super(logFileName, LogService.Verbosity.DEBUG);
        this._registeredLogs = new ArrayList<Log>();
        this._copyBundle = BundleManagerFactory.getInstance().getBundle("copy");
    }

    public void registerLogs(CourseCopyLogFileSpecifications logSpecifications) {
        LogService logService = LogServiceFactory.getInstance();
        for (CourseCopyLogFileSpecifications.LogSpecification log : logSpecifications.getSpecifications()) {
            String strLogFile = log.getLogName();
            try {
                File file = new File(strLogFile);
                if (file.exists()) {
                    FileUtilEx.deleteFile((File)file);
                }
                logService.defineNewFileLog(file.getName(), file.getAbsolutePath(), log.getVerbosity(), this._copyBundle.getLocale(), false);
                this._registeredLogs.add(logService.getConfiguredLog(file.getName()));
            }
            catch (BbServiceException bbse) {
                String message = "Failed to register Course Copy Logs";
                this._defaultLog.logError(message, (Throwable)bbse);
                throw new RuntimeException(message, bbse);
            }
        }
    }

    private String getLocalizedLogLevelKey(LogService.Verbosity verbosity) {
        String messageKey = "clone.log.debug";
        if (LogService.Verbosity.ERROR.equals((Object)verbosity)) {
            messageKey = "clone.log.error";
        } else if (LogService.Verbosity.FATAL.equals((Object)verbosity)) {
            messageKey = "clone.log.fatal";
        } else if (LogService.Verbosity.INFORMATION.equals((Object)verbosity)) {
            messageKey = "clone.log.info";
        } else if (LogService.Verbosity.WARNING.equals((Object)verbosity)) {
            messageKey = "clone.log.warning";
        }
        return messageKey;
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public void logException(Throwable t) {
        String msg = ExceptionUtil.getStackTrace((Throwable)t);
        this.logRaw(LogService.Verbosity.DEBUG, msg);
        this._defaultLog.logError(msg);
    }

    public void logHeader(CloneConfig cfg, Course srcCourse, Course tgtCourse) {
        this.logSrcAndTargetCourseInfo(srcCourse, tgtCourse);
        this.logConfig(cfg);
    }

    private void logConfig(CloneConfig cfg) {
        new CloneConfigReport(cfg).log();
    }

    private void logSrcAndTargetCourseInfo(Course srcCourse, Course tgtCourse) {
        StringBuilder courseInfo = new StringBuilder();
        courseInfo.append("Begin copy.  ");
        courseInfo.append("Source CourseID=[" + srcCourse.getCourseId() + "]");
        courseInfo.append(", Target CourseID=[" + tgtCourse.getCourseId() + "]");
        this.logInfo(courseInfo.toString());
    }

    protected void doLogMessage(String message, Throwable t, LogService.Verbosity verbosity) {
        this.logRaw(verbosity, message);
        if (t != null) {
            this.logException(t);
        }
    }

    protected void doLogMessage(String message, LogService.Verbosity verbosity) {
        this.doLogMessage(message, null, verbosity);
    }

    public void logRaw(LogService.Verbosity verbosity, String msg) {
        String[] args = new String[]{msg};
        String logMsg = this._copyBundle.getString(this.getLocalizedLogLevelKey(verbosity), args);
        for (Log log : this._registeredLogs) {
            log.log(logMsg, verbosity);
        }
    }

    public boolean isOpen() {
        return this._open;
    }

    public void open() {
        this._open = true;
    }

    public void close() {
        this._open = false;
    }

    public void flush() {
    }

    protected void finalize() {
        if (!this._bHaveCleanedUp) {
            this.cleanup();
        }
    }

    public void cleanup() {
        try {
            for (Log log : this._registeredLogs) {
                if (log == this._defaultLog || !(log instanceof FlushableLog)) continue;
                ((FlushableLog)log).close();
            }
            this._bHaveCleanedUp = true;
        }
        catch (Exception e) {
            this._defaultLog.logError("Failed to cleanup Course Copy Logger", (Throwable)e);
        }
    }
}

