/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone;

import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.snapshot.config.MsgConstants;
import blackboard.platform.dataintegration.DataIntegration;
import blackboard.platform.dataintegration.DataIntegrationLogFactory;
import blackboard.platform.log.Log;

public class DataIntegrationCloneCallback
implements CloneCallback {
    private final DataIntegration _di;
    private final Log _logger;

    public DataIntegrationCloneCallback(DataIntegration di) {
        this._di = di;
        this._logger = DataIntegrationLogFactory.getInstanceByDataIntegration((DataIntegration)this._di);
    }

    @Override
    public void callback(CloneCallback.Stage stage, String strMessage, long lTime) {
        if (stage != CloneCallback.Stage.TERMINUS && this._logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Copy Callback ...");
            sb.append(MsgConstants.MSG_CRLF);
            sb.append("Stage : ").append((Object)stage);
            sb.append(MsgConstants.MSG_CRLF);
            sb.append("Message : ").append(strMessage);
            sb.append(MsgConstants.MSG_CRLF);
            sb.append("Time(s) : ").append((float)lTime / 1000.0f);
            sb.append(MsgConstants.MSG_CRLF);
            sb.append("...............");
            sb.append(MsgConstants.MSG_CRLF);
            this._logger.logDebug(sb.toString());
        }
    }
}

