/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone;

import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.DataIntegrationCloneCallback;
import blackboard.admin.persist.course.impl.clone.QueuedCloneOperation;
import blackboard.data.course.Course;
import blackboard.data.user.User;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.persist.PersistenceException;
import blackboard.persist.user.UserDbLoader;
import blackboard.platform.dataintegration.DataIntegration;
import blackboard.platform.dataintegration.DataIntegrationLogFactory;
import blackboard.platform.dataintegration.DataIntegrationManagerFactory;
import blackboard.platform.dataintegration.impl.InternalDataIntegrationLogUtilManagerFactory;
import blackboard.platform.log.Log;
import blackboard.platform.log.LogServiceFactory;
import blackboard.platform.queue.data.QueueTask;

public class DataIntegrationCloneOperation
extends QueuedCloneOperation {
    private static final String TYPE_CODE = "DataIntegrationCloneOperation";
    private static final String DATA_INTEGRATION_ARG = "data.int.id";
    private static final String DATA_SET_UID_ARG = "data.set.uid";

    public DataIntegrationCloneOperation() {
    }

    private DataIntegrationCloneOperation(Course srcSite, Course tgtSite, CloneConfig cfg, boolean protectedCartridge, Id dataIntegrationId, String dataSetUid) {
        super(srcSite, tgtSite, cfg, protectedCartridge);
        this._args.put(DATA_INTEGRATION_ARG, dataIntegrationId.toExternalString());
        this._args.put(DATA_SET_UID_ARG, dataSetUid);
    }

    @Override
    public String getTypeCode() {
        return TYPE_CODE;
    }

    public boolean isEmailEnabled() {
        return false;
    }

    public boolean isDeleteTaskImmediately() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doClone(CloneConfig cfg, String sourceBatchUid, String targetBatchUid) {
        DataIntegration di = null;
        try {
            Id dataIntegrationId = this.getDataIntegrationId();
            di = DataIntegrationManagerFactory.getInstance().loadById(dataIntegrationId);
        }
        catch (Exception e) {
            String dataIntegrationIdStr = (String)this._args.get(DATA_INTEGRATION_ARG);
            LogServiceFactory.getInstance().logError("Error loading dataIntegration " + dataIntegrationIdStr, (Throwable)e);
        }
        try {
            if (di != null) {
                DataIntegrationLogFactory.startAggregating((DataIntegration)di);
                Log diLog = DataIntegrationLogFactory.getInstanceByDataIntegration((DataIntegration)di);
                LogServiceFactory.getInstance().setDefaultThreadLog(diLog);
                String dataSetUid = (String)this._args.get(DATA_SET_UID_ARG);
                InternalDataIntegrationLogUtilManagerFactory.getInstance().setLoggerDataSetUid(diLog, dataSetUid);
                diLog.logInfo("Copying " + sourceBatchUid + " to " + targetBatchUid);
                cfg.setCallback(new DataIntegrationCloneCallback(di));
            }
            cfg.setUseCourseCopyLog(false);
            String string = super.doClone(cfg, sourceBatchUid, targetBatchUid);
            return string;
        }
        finally {
            if (di != null) {
                Log diLog = DataIntegrationLogFactory.getInstanceByDataIntegration((DataIntegration)di);
                diLog.logInfo("Copy complete");
                LogServiceFactory.getInstance().setDefaultThreadLog(null);
                DataIntegrationLogFactory.finishAggregating((DataIntegration)di, (boolean)true);
                InternalDataIntegrationLogUtilManagerFactory.getInstance().setLoggerDataSetUid(diLog, null);
            }
        }
    }

    private Id getDataIntegrationId() throws PersistenceException {
        String dataIntegrationIdStr = (String)this._args.get(DATA_INTEGRATION_ARG);
        return Id.generateId((DataType)DataIntegration.DATA_TYPE, (String)dataIntegrationIdStr);
    }

    public static QueueTask createTask(Course srcSite, Course tgtSite, CloneConfig cfg, boolean protectedCartridge, Id dataIntegrationId, String dataSetUid) throws PersistenceException {
        User admin = UserDbLoader.Default.getInstance().loadByUserName("administrator");
        if (null == dataIntegrationId) {
            return QueuedCloneOperation.createTask(srcSite, tgtSite, cfg, admin.getId(), protectedCartridge);
        }
        DataIntegrationCloneOperation op = new DataIntegrationCloneOperation(srcSite, tgtSite, cfg, protectedCartridge, dataIntegrationId, dataSetUid);
        return op.createQueueTask(srcSite, tgtSite, admin.getId());
    }
}

