/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone;

import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.CourseEventListener;
import blackboard.persist.Id;
import blackboard.platform.log.LogServiceFactory;
import blackboard.platform.nautilus.internal.NautilusBlitzConfig;
import blackboard.platform.nautilus.service.impl.NautilusToolbox;
import blackboard.platform.nautilus.service.internal.InternalDiscoveryManager;
import blackboard.platform.nautilus.service.internal.InternalDiscoveryManagerFactory;

public class NautilusPostCloneCourseHandler
implements CourseEventListener {
    @Override
    public void courseCloned(Id sourceCourseId, Id targetCourseId, CloneConfig config) throws Exception {
        try {
            if (!config.isCloneForDecrossList()) {
                InternalDiscoveryManager.BlitzDataType dataType = InternalDiscoveryManager.BlitzDataType.CONTENT;
                if (config.isAreaIncluded(CloneConfig.Area.MEMBERSHIP) || config.isAreaIncluded(CloneConfig.Area.MEMBERSHIP_EXACT)) {
                    dataType = InternalDiscoveryManager.BlitzDataType.CONTENT_AND_ENROLLMENT;
                }
                NautilusBlitzConfig blitzConfig = new NautilusBlitzConfig(targetCourseId.toExternalString(), dataType.getName(), config.getHostName(), config.getSourceName());
                InternalDiscoveryManagerFactory.getInstance().initiateNotificationBlitz(blitzConfig);
            }
        }
        catch (Exception e) {
            String message = "Exception in handling Course/Snapshot Copy Notifications in NautilusPostCourseCloneHandler for course: " + targetCourseId.toExternalString();
            LogServiceFactory.getInstance().logError(message, (Throwable)e);
            NautilusToolbox.logError((String)message, (Throwable)e);
            throw e;
        }
    }

    @Override
    public void courseCreated(Id courseId) {
    }
}

