/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone;

import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.CourseEventListener;
import blackboard.data.course.Course;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.platform.extension.service.ExtensionRegistryFactory;
import blackboard.platform.log.LogServiceFactory;
import blackboard.platform.messagequeue.AbstractMessageQueueHandler;
import blackboard.platform.messagequeue.MessageQueueMessage;
import blackboard.util.ObjectSerializer;
import java.util.Collection;

public class PostCourseCloneMessageHandler
extends AbstractMessageQueueHandler {
    private static final String SOURCE_ARG = "source.id";
    private static final String TARGET_ARG = "target.id";
    private static final String CONFIG_ARG = "clone.config";

    public PostCourseCloneMessageHandler() {
        super("bb-post-course-clone", true);
    }

    public static void submit(Id srcCourseId, Id tgtCourseId, CloneConfig cfg) {
        try {
            MessageQueueMessage msg = new MessageQueueMessage();
            msg.set(SOURCE_ARG, (Object)srcCourseId.toExternalString());
            msg.set(TARGET_ARG, (Object)tgtCourseId.toExternalString());
            msg.set(CONFIG_ARG, (Object)ObjectSerializer.serializeObject((Object)cfg));
            new PostCourseCloneMessageHandler().getMessageQueue().sendMessage(msg);
        }
        catch (Exception e) {
            String errMsg = String.format("Failed to submit event for srcCourse=%s, tgtCourse=%s", srcCourseId.toExternalString(), tgtCourseId.toExternalString());
            LogServiceFactory.getInstance().logError(errMsg);
        }
    }

    public void onMessage(MessageQueueMessage message) throws Exception {
        Id sourceId = Id.generateId((DataType)Course.DATA_TYPE, (String)((String)message.get(SOURCE_ARG)));
        Id targetId = Id.generateId((DataType)Course.DATA_TYPE, (String)((String)message.get(TARGET_ARG)));
        CloneConfig config = (CloneConfig)ObjectSerializer.deSerializeObject((String)((String)message.get(CONFIG_ARG)));
        Collection listeners = ExtensionRegistryFactory.getInstance().getExtensions("blackboard.cmsadmin.postCloneCourseEventListener");
        for (CourseEventListener listener : listeners) {
            try {
                listener.courseCloned(sourceId, targetId, config);
            }
            catch (Exception e) {
                LogServiceFactory.getInstance().logError("Error processing event handler: " + listener.getClass().getName(), (Throwable)e);
            }
        }
    }
}

