/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone;

import blackboard.persist.PersistenceException;
import blackboard.persist.impl.ModificationQuery;
import blackboard.platform.context.ContextManager;
import blackboard.platform.context.ContextManagerFactory;
import blackboard.platform.log.LogServiceFactory;
import blackboard.platform.vxi.data.VirtualInstallation;
import blackboard.platform.vxi.service.VirtualInstallationManager;
import blackboard.platform.vxi.service.VirtualInstallationManagerFactory;
import blackboard.util.ExceptionUtil;
import blackboard.util.singleton.SingletonTimerTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class PurgeCorruptLinkTask
extends SingletonTimerTask {
    private static final String LOCK_ID = "bb.corrupt.link.purge";
    private ContextManager _contextMgr = ContextManagerFactory.getInstance();
    private VirtualInstallationManager _viMgr = VirtualInstallationManagerFactory.getInstance();

    public PurgeCorruptLinkTask() {
        super(LOCK_ID);
    }

    public void execute() throws Exception {
        try {
            for (VirtualInstallation vi : this._viMgr.getAllVirtualInstallations()) {
                this.purgeCorruptLink(vi);
            }
        }
        catch (Throwable t) {
            ExceptionUtil.checkForThreadDeath((Throwable)t);
            LogServiceFactory.getInstance().logError(((Object)((Object)this)).getClass().getName(), t);
        }
    }

    private void purgeCorruptLink(VirtualInstallation vi) throws PersistenceException {
        this._contextMgr.setContext(vi);
        new PurgeCorruptLinkQuery().run();
    }

    private static class PurgeCorruptLinkQuery
    extends ModificationQuery {
        private static final String QUERY_SQL = "DELETE FROM link WHERE course_toc_pk1 IS NULL AND course_contents_pk1 IS NULL AND announcements_pk1 IS NULL";

        private PurgeCorruptLinkQuery() {
        }

        protected Statement prepareStatement(Connection con) throws SQLException, PersistenceException {
            return con.prepareStatement(QUERY_SQL);
        }
    }
}

