/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone;

import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.CourseSitePersister;
import blackboard.data.ValidationException;
import blackboard.data.course.Course;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.course.CourseDbLoader;
import blackboard.platform.institutionalhierarchy.service.NodeAssociationManagerEx;
import blackboard.platform.institutionalhierarchy.service.NodeManagerExFactory;
import blackboard.platform.institutionalhierarchy.service.ObjectType;
import blackboard.platform.intl.BundleMessage;
import blackboard.platform.log.LogServiceFactory;
import blackboard.platform.queue.BaseQueuedOperation;
import blackboard.platform.queue.data.QueueTask;
import blackboard.util.BundleUtil;
import blackboard.util.ObjectSerializer;
import blackboard.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueuedCloneOperation
extends BaseQueuedOperation {
    private static final String SOURCE_ARG = "src.clone";
    private static final String TARGET_ARG = "tgt.clone";
    private static final String CONFIG_ARG = "cfg.clone";
    private static final String CARTRIDGE_CONFLICT = "cfg.different.cartridge";
    private static final String TYPE_CODE = "C";
    protected Map<String, Object> _args;
    private boolean _cartridgeConflict;
    private ArrayList<BundleMessage> _warnings;

    public QueuedCloneOperation() {
    }

    protected QueuedCloneOperation(Course srcSite, Course tgtSite, CloneConfig cfg, boolean protectedCartridge) {
        this._args = new HashMap<String, Object>();
        this._args.put(SOURCE_ARG, srcSite.getBatchUid());
        this._args.put(TARGET_ARG, tgtSite.getBatchUid());
        this._args.put(CONFIG_ARG, cfg);
        if (protectedCartridge && srcSite.getCartridgeId() != null && srcSite.getCartridgeId().isSet() && tgtSite.getCartridgeId() != null && tgtSite.getCartridgeId().isSet() && !tgtSite.getCartridgeId().equals((Object)srcSite.getCartridgeId())) {
            this._args.put(CARTRIDGE_CONFLICT, "Y");
        }
    }

    public String getTypeCode() {
        return TYPE_CODE;
    }

    public String getDisplayName() {
        return BundleUtil.getMessage((String)"platform", (String)"platform.queuetask.type.course-copy");
    }

    public String execute() {
        try {
            Map args;
            this._args = args = (Map)ObjectSerializer.deSerializeObject((String)this._task.getArguments());
        }
        catch (PersistenceException e) {
            LogServiceFactory.getInstance().logError("Error parsing the arguments", (Throwable)e);
            this._status = QueueTask.Status.COMPLETE_ERRORS;
            return "copy|copy.msg.clone.operation.persistence.arg.error";
        }
        CloneConfig cfg = (CloneConfig)this._args.get(CONFIG_ARG);
        String results = this.doClone(cfg, (String)this._args.get(SOURCE_ARG), (String)this._args.get(TARGET_ARG));
        results = this.doNodeAssociation(results, (String)this._args.get(TARGET_ARG), cfg.getNodes(), cfg.getPrimaryNode(), cfg.getCopyType());
        this._cartridgeConflict = "Y".equals(this._args.get(CARTRIDGE_CONFLICT));
        if (cfg.isHadWarnings()) {
            results = "copy.msg.clone.operation.warning";
            this._warnings = cfg.getWarningMessages();
        }
        if (this._status != QueueTask.Status.COMPLETE_ERRORS) {
            this._status = QueueTask.Status.COMPLETE;
        }
        return "copy|" + results;
    }

    protected String doClone(CloneConfig cfg, String sourceBatchUid, String targetBatchUid) {
        String results = "copy.msg.clone.operation.success";
        try {
            CourseSitePersister persister = CourseSitePersister.Default.getInstance();
            persister.clone(sourceBatchUid, targetBatchUid, cfg);
        }
        catch (KeyNotFoundException e) {
            LogServiceFactory.getInstance().logError("Error finding the key.", (Throwable)e);
            results = "copy.msg.clone.operation.key.error";
            this._status = QueueTask.Status.COMPLETE_ERRORS;
        }
        catch (ConstraintViolationException e) {
            LogServiceFactory.getInstance().logError("Error due to database constraint.", (Throwable)e);
            results = "copy.msg.clone.operation.database.error";
            this._status = QueueTask.Status.COMPLETE_ERRORS;
        }
        catch (ValidationException e) {
            LogServiceFactory.getInstance().logError("Error during validation.", (Throwable)e);
            results = "copy.msg.clone.operation.validation.error";
            this._status = QueueTask.Status.COMPLETE_ERRORS;
        }
        catch (Exception e) {
            LogServiceFactory.getInstance().logError("Error during persistence.", (Throwable)e);
            results = "copy.msg.clone.operation.persistence.error";
            this._status = QueueTask.Status.COMPLETE_ERRORS;
        }
        return results;
    }

    private String doNodeAssociation(String results, String targetBatchUid, List<Id> nodes, Id primaryNode, CloneConfig.CopyType ctype) {
        NodeAssociationManagerEx assocManager = NodeManagerExFactory.getAssociationManagerEx();
        if (StringUtil.isEqual((String)results, (String)"copy.msg.clone.operation.success") && (ctype == CloneConfig.CopyType.COPY_EXACT_COURSE || ctype == CloneConfig.CopyType.COPY_NEW_COURSE) && nodes != null && !nodes.isEmpty()) {
            try {
                Course targetCourse = CourseDbLoader.Default.getInstance().loadByBatchUid(targetBatchUid, null);
                ObjectType ot = targetCourse.isOrganization() ? ObjectType.Organization : ObjectType.Course;
                assocManager.associateToNodes(targetCourse.getId(), ot, nodes);
                assocManager.updatePrimaryNode(targetCourse.getId(), ot, primaryNode);
            }
            catch (Exception e) {
                LogServiceFactory.getInstance().logError("Error associating the course copy to nodes", (Throwable)e);
                this._status = QueueTask.Status.COMPLETE_ERRORS;
                results = "copy.msg.associate.nodes.operation.error";
            }
        }
        return results;
    }

    public String getStatusSummary(String strLocale) {
        if (this._status == QueueTask.Status.COMPLETE || this._status == QueueTask.Status.COMPLETE_ERRORS) {
            return this.buildString(strLocale, "platform", "platform.queuetask.notify.subject.course-copy");
        }
        return this.buildString(strLocale, "platform", "platform.queuetask.notify.subject.failed.course-copy");
    }

    public String getStatusDetail(String strLocale) {
        String title = this._task.getTitle(strLocale);
        StringBuilder result = new StringBuilder();
        if (this._status == QueueTask.Status.COMPLETE || this._status == QueueTask.Status.COMPLETE_ERRORS) {
            result.append(this.buildString(strLocale, "platform", "platform.queuetask.notify.message.course-copy", new Object[]{title}));
        } else {
            result.append(this.buildString(strLocale, "platform", "platform.queuetask.notify.message.failed.course-copy", new Object[]{title}));
        }
        if (this._cartridgeConflict) {
            result.append("\n\n");
            result.append(this.buildString(strLocale, "platform", "platform.queuetask.notify.message.course-copy.bothCartridge.differentCKey"));
        }
        if (this._warnings != null) {
            for (BundleMessage message : this._warnings) {
                result.append("\n\n");
                result.append(message.getBundleMessage(strLocale));
            }
        }
        return result.toString();
    }

    public static QueueTask createTask(Course srcSite, Course tgtSite, CloneConfig cfg, Id userId, boolean protectedCartridge) throws PersistenceException {
        QueuedCloneOperation op = new QueuedCloneOperation(srcSite, tgtSite, cfg, protectedCartridge);
        return op.createQueueTask(srcSite, tgtSite, userId);
    }

    protected QueueTask createQueueTask(Course srcSite, Course tgtSite, Id userId) throws PersistenceException {
        QueueTask task = new QueueTask();
        task.setType(this.getTypeCode());
        task.setArguments(ObjectSerializer.serializeObject(this._args));
        task.setTitle("copy|course.copy.queue.task.label|" + tgtSite.getCourseId() + "," + srcSite.getCourseId());
        task.setInitiatorUserId(userId);
        return task;
    }
}

