/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone;

import blackboard.admin.manager.impl.TemporarySnapshotSessionManagerFactory;
import blackboard.platform.impl.services.task.BackendProcess;
import blackboard.platform.impl.services.task.TaskDescriptor;
import blackboard.platform.log.LogService;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.ExceptionUtil;
import blackboard.util.singleton.SingletonTimerTask;
import java.util.Properties;

@BackendProcess
public class TempKeyMapCleanupTask
extends SingletonTimerTask {
    public static final String LOCK_ID = "bb.admin.clone.key.invalidation";
    private static final String INVALID = "minutesToInvalid";
    private LogService _log = LogServiceFactory.getInstance();
    private int _minutes = 10080;

    public TempKeyMapCleanupTask() {
        super(LOCK_ID);
    }

    public void init(TaskDescriptor td) {
        super.init(td);
        Properties taskProps = td.getTaskProperties();
        String invalid = taskProps.getProperty(INVALID, "-1");
        try {
            this._minutes = Integer.valueOf(invalid);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void execute() throws Exception {
        try {
            TemporarySnapshotSessionManagerFactory.getInstance().purgeSessionsOlderThan(this._minutes);
        }
        catch (Throwable t) {
            this._log.logError(((Object)((Object)this)).getClass().getName(), t);
            ExceptionUtil.checkForThreadDeath((Throwable)t);
        }
    }
}

