/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.cxutil.CSFileCopyHandler;
import blackboard.admin.cxutil.CSFileCopyHandlerFactory;
import blackboard.admin.cxutil.CSResultSet;
import blackboard.admin.cxutil.CourseContentCopyUtil;
import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.AdminCourseCloneOperator;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.helper.GradebookColumnCopier;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.data.Identifiable;
import blackboard.data.course.Course;
import blackboard.db.BbDatabase;
import blackboard.db.DbUtil;
import blackboard.persist.Container;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Bb5Util;
import blackboard.platform.blog.Blog;
import blackboard.platform.blog.BlogEntry;
import blackboard.platform.blog.impl.BlogDAO;
import blackboard.platform.contentsystem.data.Resource;
import blackboard.platform.contentsystem.data.ResourceFolder;
import blackboard.platform.contentsystem.manager.PrivateDocumentManager;
import blackboard.platform.contentsystem.service.ContentSystemServiceExFactory;
import blackboard.platform.filesystem.FileSystemServiceFactory;
import blackboard.platform.filesystem.LocationUtil;
import blackboard.platform.filesystem.manager.CourseFileManager;
import blackboard.platform.gradebook2.GradableItem;
import blackboard.platform.gradebook2.GroupAttempt;
import blackboard.platform.gradebook2.GroupAttemptManagerFactory;
import blackboard.platform.gradebook2.impl.GradableItemDAO;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.FileUtil;
import blackboard.util.StringUtil;
import blackboard.util.UuidFactory;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Map;

public class BlogCloneOperator
extends CloneOperator {
    public BlogCloneOperator(AdminCourseCloneOperator parentOperator) {
        super(parentOperator);
    }

    @Override
    public void doDatabaseTranslation() throws Exception {
        long lStart = System.currentTimeMillis();
        if (!this._cfg.isAreaIncluded(this.getArea())) {
            return;
        }
        this.executeCloneProcedureForGb("blog_journal_cp", this._cfg.getMaximumTransactionCount(), this.isJournal());
        this.createGradeCenterColumns();
        if (this._cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP_EXACT)) {
            this.executeCloneProcedureForGb("blog_journal_entry_cp", this._cfg.getMaximumTransactionCount(), this.isJournal());
            this.executeCloneProcedureForGb("blog_entry_user_status_cp", this._cfg.getMaximumTransactionCount(), this.isJournal());
        }
        this.createGroupAttempt();
        this.doCallbackSegment(CloneCallback.Stage.BLOG, ConfigurationManager.getGlobalLocaleExceptionMessage(this.isJournal() ? "clone.journal" : "clone.blog"), System.currentTimeMillis() - lStart);
    }

    private void createGroupAttempt() {
        if (!this._cfg.isAreaIncluded(CloneConfig.Area.GRADES) || !this._cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP)) {
            List blogs = BlogDAO.get().loadByCourseId(this._tgtSite.getId(), false, this.isJournal(), false);
            for (Blog blog : blogs) {
                GradableItem gradableItem;
                String gradeHandle;
                if (!blog.isGroupBlog() || null != blog.getGroupAttemptId() || !StringUtil.notEmpty((String)(gradeHandle = blog.getGradeHandle())) || null == (gradableItem = GradableItemDAO.get().getGradableItemByCourseIdAndLinkRefId(this._tgtSite.getId(), gradeHandle))) continue;
                GroupAttempt groupAttempt = GroupAttemptManagerFactory.getInstanceNoTransaction().createGroupAttempt(blog.getGroupId(), gradableItem.getId());
                blog.setGroupAttemptId(groupAttempt.getId());
                BlogDAO.get().persist((Identifiable)blog);
            }
        }
    }

    private void createGradeCenterColumns() {
        List linkRefIds = BlogDAO.get().getLinkRefIds(this._srcSite.getId(), this.isJournal(), false);
        if (this._cfg.isAreaIncluded(CloneConfig.Area.GRADEBOOK)) {
            this.updateGradeHandlerAndLinkRefIds(linkRefIds);
            return;
        }
        GradebookColumnCopier.BaseOnCopyHandler handler = new GradebookColumnCopier.BaseOnCopyHandler(){

            @Override
            public void afterCopy(GradableItem originalItem, GradableItem copiedItem) {
                BlogDAO.get().updateGradeHandler(originalItem.getLinkId(), copiedItem.getLinkId(), BlogCloneOperator.this._tgtSite.getId());
            }
        };
        GradebookColumnCopier copier = new GradebookColumnCopier(this._srcSite.getId(), this._tgtSite.getId(), linkRefIds);
        copier.copy(handler, true);
    }

    private void updateGradeHandlerAndLinkRefIds(List<String> linkRefIds) {
        for (String linkRefId : linkRefIds) {
            String newlinkId = UuidFactory.createFormattedUuid();
            BlogDAO.get().updateGradeHandler(linkRefId, newlinkId, this._tgtSite.getId());
            GradableItemDAO.get().updateLinkIdByCourseIdAndLinkId(this._tgtSite.getId(), linkRefId, newlinkId);
        }
    }

    @Override
    public String getDirectoryTranslation(String dir) {
        return this.getDirectoryTranslation(dir, "BLOGS");
    }

    @Override
    public void doContentDirectoryTranslation() throws Exception {
        if (!this._cfg.isAreaIncluded(this.getArea())) {
            return;
        }
        File tgtPath = ((CourseFileManager)FileSystemServiceFactory.getInstance().getFileManager(Course.DATA_TYPE)).getRootDirectory(this._tgtSite.getCourseId());
        tgtPath = new File(tgtPath, "blog");
        this.doDirectoryPathTranslation(tgtPath.getAbsolutePath());
    }

    @Override
    protected void doPrivateDirectoryPathTranslation(String strDirectory) {
        File sourceDir = new File(strDirectory);
        String link = LocationUtil.getRelativeLink((String)this._tgtSite.getCourseId(), (File)sourceDir);
        PrivateDocumentManager pMgr = ContentSystemServiceExFactory.getInstance().getPrivateDocumentManager();
        ResourceFolder folder = null;
        List strAllFiles = null;
        try {
            folder = pMgr.loadFolder(this._tgtSite, link);
            strAllFiles = folder.getDirectoryListing();
        }
        catch (KeyNotFoundException knf) {
            return;
        }
        catch (PersistenceException pe) {
            LogServiceFactory.getInstance().logDebug("Failed loading resource listing.", (Throwable)pe);
        }
        if (strAllFiles == null || strAllFiles.isEmpty()) {
            return;
        }
        for (String strResource : strAllFiles) {
            link = LocationUtil.getRelativeLink((String)this._tgtSite.getCourseId(), (File)new File(strResource));
            try {
                String strDestinationDir;
                Resource resource = pMgr.loadResource(this._tgtSite, link);
                if (resource.getType() == Resource.Type.FILE || StringUtil.isEqual((String)(strDestinationDir = this.getDirectoryTranslation(strResource)), (String)strResource)) continue;
                pMgr.moveResources(this._tgtSite, LocationUtil.getRelativeLink((String)this._tgtSite.getCourseId(), (File)new File(strResource)), LocationUtil.getRelativeLink((String)this._tgtSite.getCourseId(), (File)new File(strDestinationDir)));
                StringBuilder postLink = new StringBuilder(LocationUtil.getRelativeLink((String)this._tgtSite.getCourseId(), (File)new File(strDestinationDir)));
                postLink.append("/");
                postLink.append("post");
                try {
                    folder = pMgr.loadFolder(this._tgtSite, postLink.toString());
                }
                catch (KeyNotFoundException knf) {
                    continue;
                }
                List strChildFiles = folder.getDirectoryListing();
                if (strChildFiles == null || strChildFiles.isEmpty()) continue;
                for (String strChildResource : strChildFiles) {
                    link = LocationUtil.getRelativeLink((String)this._tgtSite.getCourseId(), (File)new File(strChildResource));
                    try {
                        String strChildDestinationDir;
                        resource = pMgr.loadResource(this._tgtSite, link);
                        if (resource.getType() == Resource.Type.FILE || StringUtil.isEqual((String)(strChildDestinationDir = this.getDirectoryTranslation(strChildResource, "BLOG_ENTRY")), (String)strChildResource)) continue;
                        pMgr.moveResources(this._tgtSite, LocationUtil.getRelativeLink((String)this._tgtSite.getCourseId(), (File)new File(strChildResource)), LocationUtil.getRelativeLink((String)this._tgtSite.getCourseId(), (File)new File(strChildDestinationDir)));
                    }
                    catch (Exception exc) {
                        LogServiceFactory.getInstance().logWarning("Could not move resource:" + link, (Throwable)exc);
                    }
                }
            }
            catch (Exception exc) {
                LogServiceFactory.getInstance().logWarning("Could not move resource:" + link, (Throwable)exc);
            }
        }
    }

    @Override
    protected void doLocalDirectoryPathTranslation(String strDirectory) throws Exception {
        File sourceDir = new File(strDirectory);
        String[] straAllFiles = FileUtil.getDirectoryListing((File)sourceDir);
        if (straAllFiles == null || straAllFiles.length == 0) {
            return;
        }
        for (int i = 0; i < straAllFiles.length; ++i) {
            File dir;
            if (!this.existsInTarget(straAllFiles[i]) || !(dir = new File(straAllFiles[i])).isDirectory()) continue;
            String strDestinationFile = this.getDirectoryTranslation(dir.getPath());
            File destinationDir = new File(strDestinationFile);
            FileUtil.moveDirectory((File)dir, (File)destinationDir);
            File sourceBlogEntryDir = new File(destinationDir, "post");
            String[] strAllBlogEntryFiles = FileUtil.getDirectoryListing((File)sourceBlogEntryDir);
            if (strAllBlogEntryFiles == null || strAllBlogEntryFiles.length == 0) {
                return;
            }
            for (String strAllBlogEntryFile : strAllBlogEntryFiles) {
                File sourceEntryDir = new File(strAllBlogEntryFile);
                if (!sourceEntryDir.isDirectory()) continue;
                String strEntryDestinationFile = this.getDirectoryTranslation(sourceEntryDir.getPath(), "BLOG_ENTRY");
                File entryDestinationDir = new File(strEntryDestinationFile);
                FileUtil.moveDirectory((File)sourceEntryDir, (File)entryDestinationDir);
            }
        }
    }

    @Override
    public void doEmbeddedDatabaseIdTranslation() throws Exception {
        if (!this._cfg.isAreaIncluded(this.getArea())) {
            return;
        }
        this.updateEmbeddedDatabaseIdForBlogs();
        this.updateEmbeddedDatabaseIdForBlogEntries();
        CSFileCopyHandler csFileHandler = CSFileCopyHandlerFactory.getInstance();
        csFileHandler.updateCSLinks(this._srcSite.getId(), this._tgtSite.getId(), Blog.DATA_TYPE, this.getDbBasedIdMap("BLOGS"), this.getDbBasedIdMap("XYTHOS_DATAVALUES"));
    }

    protected boolean isJournal() {
        return false;
    }

    protected CloneConfig.Area getArea() {
        return CloneConfig.Area.BLOG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEmbeddedDatabaseIdForBlogs() throws Exception {
        PreparedStatement select = null;
        PreparedStatement update = null;
        Connection con = null;
        String qrySelect = "select pk1, description, title from BLOGS where crsmain_pk1 = ?";
        String qryUpdate = "update BLOGS set description = ? where pk1 = ?";
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            select = con.prepareStatement(qrySelect);
            update = con.prepareStatement(qryUpdate);
            Bb5Util.setId((PreparedStatement)select, (int)1, (Id)this._tgtSite.getId());
            ResultSet rst = select.executeQuery();
            Map<String, String> blogIdMap = this.getDbBasedIdMap("BLOGS");
            Map<String, String> filesMap = this.getDbBasedIdMap("FILES");
            while (rst.next()) {
                Id cId = Bb5Util.unmarshallId((ResultSet)rst, (int)1, (DataType)Blog.DATA_TYPE, (Container)this._pm.getContainer());
                String text = DbUtil.getClob((BbDatabase)this._bbDatabase, (ResultSet)rst, (String)"description", null);
                String title = DbUtil.getString((ResultSet)rst, (String)"title", null);
                if (text == null || text.length() == 0) continue;
                String replace = CourseContentCopyUtil.resolveTextBasedMapping(filesMap, text);
                if (blogIdMap.containsValue(cId.toExternalString())) {
                    CSResultSet resultSet = new CSResultSet(this._tgtSite.getId(), cId, title, "cx.import.copy.link.component.name.blog");
                    try {
                        replace = this.parseVTBEText(replace, resultSet);
                    }
                    catch (Exception e) {
                        LogServiceFactory.getInstance().logError("Failed to update embedded Course Files link in the instruction of Blog with name: " + title + ", instruction:" + text, (Throwable)e);
                    }
                    this.addCsLinkStatus(resultSet);
                }
                if (text.equals(replace)) continue;
                DbUtil.setNClob((BbDatabase)this._bbDatabase, (PreparedStatement)update, (int)1, (String)replace);
                Bb5Util.setId((PreparedStatement)update, (int)2, (Id)cId);
                update.execute();
            }
            DbUtil.close((ResultSet)rst);
        }
        catch (Throwable throwable) {
            DbUtil.close(select);
            DbUtil.close(update);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
            throw throwable;
        }
        DbUtil.close((Statement)select);
        DbUtil.close((Statement)update);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEmbeddedDatabaseIdForBlogEntries() throws Exception {
        Map<String, String> blogEntryIdMap = this.getDbBasedIdMap("BLOG_ENTRY");
        if (blogEntryIdMap.isEmpty()) {
            return;
        }
        List<PreparedStatement> selectStmtList = null;
        PreparedStatement update = null;
        Connection con = null;
        String qrySelect = "select pk1, description, title from BLOG_ENTRY ";
        String qryUpdate = "update BLOG_ENTRY set description = ? where pk1 = ?";
        try {
            con = this._bbDatabase.getConnectionManager().getConnection();
            update = con.prepareStatement(qryUpdate);
            selectStmtList = this.prepareStatement(qrySelect, blogEntryIdMap.values(), BlogEntry.DATA_TYPE, con, this._cfg);
            for (PreparedStatement select : selectStmtList) {
                try {
                    ResultSet rst = select.executeQuery();
                    while (rst.next()) {
                        CSResultSet resultSet = null;
                        String text = null;
                        String title = null;
                        try {
                            String replace;
                            Id cId = Bb5Util.unmarshallId((ResultSet)rst, (int)1, (DataType)BlogEntry.DATA_TYPE, (Container)this._pm.getContainer());
                            text = DbUtil.getClob((BbDatabase)this._bbDatabase, (ResultSet)rst, (String)"description", null);
                            title = DbUtil.getString((ResultSet)rst, (String)"title", null);
                            if (!StringUtil.notEmpty((String)text) || StringUtil.isEqual((String)text, (String)(replace = this.parseVTBEText(text, resultSet = new CSResultSet(this._tgtSite.getId(), cId, title, "cx.import.copy.link.component.name.blog.entry"))))) continue;
                            DbUtil.setNClob((BbDatabase)this._bbDatabase, (PreparedStatement)update, (int)1, (String)replace);
                            Bb5Util.setId((PreparedStatement)update, (int)2, (Id)cId);
                            update.execute();
                        }
                        catch (Exception e) {
                            LogServiceFactory.getInstance().logError("Failed to update embedded Course Files link in the Blog Entry with title: " + title + ", description:" + text, (Throwable)e);
                        }
                        finally {
                            if (resultSet == null) continue;
                            this.addCsLinkStatus(resultSet);
                        }
                    }
                    DbUtil.close((ResultSet)rst);
                }
                catch (Exception e) {
                    LogServiceFactory.getInstance().logError("Failed to load Blog Entries for updating embedded links in VTBE.", (Throwable)e);
                }
                finally {
                    DbUtil.close((Statement)select);
                }
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(update);
            this._bbDatabase.getConnectionManager().releaseConnection(con);
            throw throwable;
        }
        DbUtil.close((Statement)update);
        this._bbDatabase.getConnectionManager().releaseConnection(con);
    }
}

