/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.AdminCourseCloneOperator;
import blackboard.admin.persist.course.impl.clone.CloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.data.course.Course;
import blackboard.platform.filesystem.FileSystemServiceFactory;
import blackboard.platform.filesystem.manager.CourseFileManager;
import java.io.File;

public class ChatArchiveCloneOperator
extends CloneOperator {
    public ChatArchiveCloneOperator(AdminCourseCloneOperator parentOperator) {
        super(parentOperator);
    }

    @Override
    public void doDatabaseTranslation() throws Exception {
        long lStart = System.currentTimeMillis();
        if (!this._cfg.isAreaIncluded(CloneConfig.Area.CHAT_ARCHIVE)) {
            return;
        }
        this.executeCloneProcedure("course_collab_archive_desc_cp", this._cfg.getMaximumTransactionCount());
        if (this._cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP)) {
            this.executeCloneProcedure("course_vc_archive_event_cp", this._cfg.getMaximumTransactionCount());
        }
        if (this._cfg.isAreaIncluded(CloneConfig.Area.GROUP)) {
            this.executeCloneProcedure("group_collab_archive_desc_cp", this._cfg.getMaximumTransactionCount());
            if (this._cfg.isAreaIncluded(CloneConfig.Area.MEMBERSHIP)) {
                this.executeCloneProcedure("group_vc_archive_event_cp", this._cfg.getMaximumTransactionCount());
            }
        }
        this.doCallbackSegment(CloneCallback.Stage.CHAT_ARCHIVE, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.chat.log"), System.currentTimeMillis() - lStart);
    }

    @Override
    public String getDirectoryTranslation(String dir) {
        return this.getDirectoryTranslation(dir, "VC_ARCHIVE_EVENT");
    }

    @Override
    public void doContentDirectoryTranslation() throws Exception {
        if (!this._cfg.isAreaIncluded(CloneConfig.Area.CHAT_ARCHIVE)) {
            return;
        }
        File tgtPath = ((CourseFileManager)FileSystemServiceFactory.getInstance().getFileManager(Course.DATA_TYPE)).getRootDirectory(this._tgtSite.getCourseId());
        tgtPath = new File(tgtPath, "collab" + File.separator + "archives");
        this.doDirectoryPathTranslation(tgtPath.getAbsolutePath());
    }

    @Override
    public void doEmbeddedDatabaseIdTranslation() throws Exception {
    }
}

