/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.course.impl.clone.operator;

import blackboard.admin.persist.course.CloneCallback;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.impl.clone.AdminCourseCloneOperator;
import blackboard.admin.persist.course.impl.clone.operator.ContentCloneOperator;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.base.BbList;
import blackboard.data.navigation.CourseToc;
import blackboard.db.DbUtil;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Bb5Util;
import blackboard.persist.impl.Query;
import blackboard.persist.impl.StoredProcedureQuery;
import blackboard.persist.navigation.CourseTocDbLoader;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class CourseCorrectionCloneOperator
extends ContentCloneOperator {
    public CourseCorrectionCloneOperator(AdminCourseCloneOperator parentOperator) {
        super(parentOperator);
    }

    @Override
    public void doDatabaseTranslation() throws Exception {
        StoredProcedureQuery query;
        long lStart = System.currentTimeMillis();
        if (this._cfg.isAreaIncluded(CloneConfig.Area.CONTENT) || this._cfg.isAreaIncluded(CloneConfig.Area.COURSE_TOC) || this._cfg.isAreaIncluded(CloneConfig.Area.ASSESSMENT) || this._cfg.isAreaIncluded(CloneConfig.Area.GRADEBOOK) || this._cfg.isAreaIncluded(CloneConfig.Area.GRADES)) {
            try {
                query = new PurgeCorruptAsmtQuery(this._tgtSite.getId());
                this._pm.runDbQuery((Query)query, null);
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
        }
        if (this._cfg.isAreaIncluded(CloneConfig.Area.CONTENT) || this._cfg.isAreaIncluded(CloneConfig.Area.COURSE_TOC) || this._cfg.isAreaIncluded(CloneConfig.Area.SETTING)) {
            query = new PurgeOrphanCourseModulePageQuery(this._tgtSite.getId());
            this._pm.runDbQuery((Query)query, null);
        }
        this.doCallbackSegment(CloneCallback.Stage.COURSE_CORRECTION, ConfigurationManager.getGlobalLocaleExceptionMessage("clone.course.correction"), System.currentTimeMillis() - lStart);
    }

    @Override
    public String getDirectoryTranslation(String dir) {
        return dir;
    }

    @Override
    public void doContentDirectoryTranslation() throws Exception {
    }

    @Override
    public void doEmbeddedDatabaseIdTranslation() throws Exception {
        if (this._cfg.getReconcileFlag().booleanValue() && (this._cfg.isAreaIncluded(CloneConfig.Area.CONTENT) || this._cfg.isAreaIncluded(CloneConfig.Area.STAFF_INFORMATION) || this._cfg.isAreaIncluded(CloneConfig.Area.COURSE_TOC) || this._cfg.isAreaIncluded(CloneConfig.Area.SETTING))) {
            this.reconcileCourseToc();
        }
    }

    private void reconcileCourseToc() throws Exception {
        CourseTocDbLoader cLoader = CourseTocDbLoader.Default.getInstance();
        BbList srcTocList = cLoader.loadByCourseId(this._srcSite.getId());
        BbList tgtTocList = cLoader.loadByCourseId(this._tgtSite.getId());
        Map<String, String> crsTocMap = this.getDbBasedIdMap("COURSE_TOC");
        for (CourseToc srcToc : srcTocList) {
            CourseToc tgtToc = null;
            if (srcToc.getTargetType() == CourseToc.Target.CONTENT_ITEM) continue;
            String tgtTocId = crsTocMap.get(srcToc.getId().toExternalString());
            if (tgtTocId != null) {
                Id id = Id.generateId((DataType)CourseToc.DATA_TYPE, (String)tgtTocId);
                tgtToc = this.matchTocById(id, (List<CourseToc>)tgtTocList);
            }
            if (tgtToc == null) {
                tgtToc = this.matchTocByAttributes(srcToc, (List<CourseToc>)tgtTocList);
            }
            if (tgtToc == null) continue;
            try {
                ReorderCourseTocQuery query = new ReorderCourseTocQuery(tgtToc.getId(), srcToc.getPosition());
                this._pm.runDbQuery((Query)query, null);
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
        }
    }

    private static class PurgeOrphanCourseModulePageQuery
    extends StoredProcedureQuery {
        private final Id _courseId;

        public PurgeOrphanCourseModulePageQuery(Id courseId) {
            super("purge_orphan_cmp");
            this._courseId = courseId;
            this.addInputParameter("crsmain_pk1");
        }

        protected void marshallParams(CallableStatement stmt) throws SQLException {
            Bb5Util.setId((PreparedStatement)stmt, (int)this.getColumnPosition("crsmain_pk1"), (Id)this._courseId);
        }
    }

    private static class ReorderCourseTocQuery
    extends StoredProcedureQuery {
        private Id _crsTocId = null;
        private int _iPosition = 0;

        public ReorderCourseTocQuery(Id crsTocId, int newPosition) {
            super("reposition_course_toc");
            this._crsTocId = crsTocId;
            this._iPosition = newPosition;
            this.addInputParameter("course_toc_pk1");
            this.addInputParameter("new_position");
        }

        protected void marshallParams(CallableStatement stmt) throws SQLException {
            Bb5Util.setId((PreparedStatement)stmt, (int)this.getColumnPosition("course_toc_pk1"), (Id)this._crsTocId);
            DbUtil.setInteger((PreparedStatement)stmt, (int)this.getColumnPosition("new_position"), (int)this._iPosition);
        }
    }

    private static class PurgeCorruptAsmtQuery
    extends StoredProcedureQuery {
        private Id _courseId = null;

        public PurgeCorruptAsmtQuery(Id courseId) {
            super("purge_corrupt_asmt_assignment");
            this._courseId = courseId;
            this.addInputParameter("crsmain_pk1");
        }

        protected void marshallParams(CallableStatement stmt) throws SQLException {
            Bb5Util.setId((PreparedStatement)stmt, (int)this.getColumnPosition("crsmain_pk1"), (Id)this._courseId);
        }
    }
}

